quilt.plot              package:fields              R Documentation

_I_m_a_g_e _p_l_o_t _f_o_r _i_r_r_e_g_u_l_a_r _s_p_a_t_i_a_l _d_a_t_a.

_D_e_s_c_r_i_p_t_i_o_n:

     Given a vector of z values associated with 2-d locations this 
     function produces an  image-like plot where the locations are
     discretized to a grid  and the z  values are coded as a color
     level from a color scale.

_U_s_a_g_e:

     quilt.plot(x, y, z, nrow = 64, ncol = 64, grid = NULL, 
                          add.legend=TRUE,add=FALSE,col=tim.colors(256),...)

_A_r_g_u_m_e_n_t_s:

       x: A vector of the x coordinates of the locations -or- a a 2
          column matrix of the x-y coordinates. 

       y: A vector of the y coordinates -or- if the locations are
          passed  in x the z vector  

       z: Values of the variable to be plotted.

    nrow: Number of grid boxes in x.

    ncol: Number of grid boxes in y. 

    grid: A grid in the form of a 'grid list'.  

add.legend: If TRUE a legend color strip is added

     add: If FALSE add to existing plot.

     col: Color scale for the image, the default is tim.colors - a
          pleasing spectrum.

     ...: arguments to be passed to the image.plot function 

_D_e_t_a_i_l_s:

     This function combines the discretization to an image by the
     function  'as.image' and is then graphed by 'image.plot'.
     Locations that fall into the same grid box will have their z
     values  averaged. 

     A similar function exists in the lattice package and produces good
     looking plots. The advantage of this fields version is that it
     uses the standard R graphics functions and is written in R code.
     Also, the aggregation to average values for z values in the same
     grid box allows for different choices of grids. If two locations
     are very close, separating them could result in very small boxes. 

     As always, legend placement is never completely automatic. Place
     the  legend independently for more control, perhaps using
     'image.plot' in tandem with 'split.screen' or enlarging the plot
     margin  See 'help(image.plot)' for examples of this function and
     these  strategies.

_A_u_t_h_o_r(_s):

     D.Nychka

_S_e_e _A_l_s_o:

     as.image, image.plot, lattice, persp, drape.plot

_E_x_a_m_p_l_e_s:

     data( ozone2)
     # plot 16 day of ozone data set

     quilt.plot( ozone2$lon.lat, ozone2$y[16,])
     US( add=TRUE, col="grey", lwd=2)

     #
     # and ... if you are fussy 
     # do it again 
     # quilt.plot( ozone2$lon.lat, ozone2$y[16,],add=TRUE)
     # to draw over the state boundaries. 
     #

     ### adding a legend strip "by hand"
     par( mar=c( 5,5,5,10)) # save some room for the legend
     quilt.plot( ozone2$lon.lat, ozone2$y[16,], add.legend=FALSE)
     image.plot(ozone2$lon.lat, ozone2$y[16,],legend.only=TRUE)
       

