ribbon.plot              package:fields              R Documentation

_A_d_d_s _t_o _a_n _e_x_i_s_t_i_n_g _p_l_o_t, _a _r_i_b_b_o_n _o_f _c_o_l_o_r, _b_a_s_e_d _o_n _v_a_l_u_e_s _f_r_o_m
_a _c_o_l_o_r _s_c_a_l_e, _a_l_o_n_g _a _s_e_q_u_e_n_c_e _o_f _l_i_n_e _s_e_g_m_e_n_t_s.

_D_e_s_c_r_i_p_t_i_o_n:

     Given a series of 2-d points and values at these segments,  the
     function colors the segments according to a color scale and the
     segment values. This is essentially an image plot restricted to
     line segments.

_U_s_a_g_e:

     ribbon.plot(x,y,z,zlim=NULL, col=tim.colors(256),
                    transparent.color="white",...)

_A_r_g_u_m_e_n_t_s:

       x: x locations of line segments

       y: y locations of line segments

       z: Values associated with each segment.

    zlim: Range for z values to determine color scale. 

     col: Color table used for strip. Default is our favorite 
          tim.colors being a scale from a dark blue to dark red.

transparent.color: Color used for missing values. Default is that
          missing values make the ribbon transparent.

     ...: Optional graphical arguments that are passed to the 'segment'
          plotting function. A favorite is lwd to make a broad ribbon. 

_D_e_t_a_i_l_s:

     Besides possible 2-d applications,  this function is useful to
     annotate a curve on a surface using colors.  The values mapped to
     acolor scheme could indicate a feature  other than the height of
     the surface.  For example, this function could indicate the slope
     of the surface.

_A_u_t_h_o_r(_s):

     Doug Nychka

_S_e_e _A_l_s_o:

     image.plot, arrow.plot, add.image, colorbar.plot

_E_x_a_m_p_l_e_s:

     plot( c(-1.5,1.5),c(-1.5,1.5), type="n")
     temp<- list( x= seq( -1,1,,40), y= seq( -1,1,,40))
     temp$z <- outer( temp$x, temp$y, "+")
     contour( temp, add=TRUE)

     t<- seq( 0,.5,,50)
     y<- sin( 2*pi*t)
     x<- cos( pi*t)
     z<- x + y

     ribbon.plot( x,y,z, lwd=10)

     persp(  temp, phi=15, shade=.8, col="grey")-> pm
     trans3d( x,y,z,pm)-> uv
     ribbon.plot( uv$x, uv$y, z**2,lwd=5)

