### Name: Wimage.info
### Title: Finds key indices related to a 2-d multiresolution
### Aliases: Wimage.info Wimage.i2s Wimage.s2i
### Keywords: spatial

### ** Examples

#Find a basis function.
# For a basis on a 64X64 image with cut.min=8 find a 
# horizontal basis function at second level of resolution in the (4,4)
# position. ( There are 16X16 horizontal basis functions at the 2 nd level
#
Wimage.s2i( i=3,j=2, level=2, flavor=1, m=64, n=64, cut.min=8)-> ind
tmp<- matrix( 0, 64,64)
tmp[ind] <- 1
Wtransform.image( tmp, cut.min=8, inv=TRUE)-> look
image.plot( look)

# A check of Wimage.i2s
Wimage.i2s( ind,m=64, n=64, cut.min=8)
# should get i=3,j=2, level=2, flavor=1

# complete check of functions
 Wimage.i2s( 1:512, cut.min=8, m=16, n=32)-> look
 Wimage.s2i( look, cut.min=8, m=16, n=32, mat=FALSE)-> look2
 sum( look2 - (1:512)) # sum should be zero 

# W transform of John Lennon image

     data(lennon)
     m<- nrow(lennon)
     n<- ncol(lennon)

# add an grey strip down middle columns

     lennon[ , 128:132]<- 120

     look<- Wtransform.image( lennon, cut.min=8)

# get info 
     info<- Wimage.info( n, m, cut.min=8)

# Zero out all V basis functions coefficients, 

tmp<- look

Vind<- info$V
for (lev in 1: info$Lmax){
tmp[ Vind[lev,1]: Vind[lev,2], Vind[lev,3]: Vind[lev,4]]<- 0 
}

look2<- Wtransform.image( tmp, cut.min=8, inv=TRUE)

# take a look at vertically  filtered image
set.panel( 2,1)
par( pty="s")
image( lennon, col=grey(seq(0,1,,256)))
image( look2, col=grey(seq(0,1,,256)))

# NOTE:
# What is vertical and horizontal is confusing here
# due to the convention of the R image plot of running rows 
# of the image as the X coordinate
# The grey column in lennon image is plotted as 
# a horizontal line  
# 




