### Name: Covariance functions
### Title: Exponential family, radial basis functions,cubic spline,
###   compactly supported Wendland family and stationary covariances.
### Aliases: Exp.cov Exp.simple.cov Rad.cov Rad.simple.cov stationary.cov
###   stationary.taper.cov wendland.cov cubic.cov
### Keywords: spatial

### ** Examples

# exponential covariance matrix ( marginal variance =1) for the ozone
#locations 
out<- Exp.cov( ozone$x, theta=100)

# out is a 20X20 matrix

out2<- Exp.cov( ozone$x[6:20,],ozone$x[1:2,], theta=100)
# out2 is 15X2 matrix 

# Kriging fit where the nugget variance is found by GCV 
# Matern covariance shape with range of 100.
# 

fit<- Krig( ozone$x, ozone$y, Covariance="Matern", theta=100,smoothness=2)

data( ozone2)
x<- ozone2$lon.lat
y<- ozone2$y[16,]

# example of calling the taper version directly 
# Note that default covariance is exponential and default taper is 
# Wendland (k=2).
## Not run: 
##D 
##D stationary.taper.cov( x,x, theta=1.5, Taper.args= list(k=2, theta=2.0),
##D                            mean.neighbor= 200 )-> temp
##D # temp is a tapered covariance matrix in sparse format. 
##D 
##D  is.spam( temp)  # evaluates to TRUE
##D 
##D  temp<-  spam2full(temp) # should be identical to
##D  temp2<- Exp.cov( x,x, theta=1.5) * wendland.cov(x,x, 
##D                       theta= 2.0*1.5,spam.format=FALSE)
##D 
##D  test.for.zero( temp, temp2)
## End(Not run)

# Here is an example of how the cross covariance multiply works
# and lots of options on the arguments

 Ctest<- rnorm(10)
 
 temp<- stationary.cov( x,x[1:10,], C= Ctest, 
        Covariance= "Wendland", 
            k=2, dimension=2, theta=1.5 )

# do multiply explicitly

 temp2<- stationary.cov( x,x[1:10,],
        Covariance= "Wendland",
            k=2, dimension=2, theta=1.5 )%*% Ctest

 test.for.zero( temp, temp2)

# use the tapered stationary version 
# cov.args is part of the argument list passed to stationary.taper.cov
# within Krig. 
# This example needs the spam package.
# 

## Not run: 
##D 
##D Krig(x,y, cov.function = "stationary.taper.cov", theta=1.5,
##D       cov.args= list( Taper.args= list(k=2, theta=2.0) )
##D            ) -> out2 
## End(Not run)

# BTW  this is very similar to 
## Not run: 
##D  Krig(x,y, theta= 1.5)-> out
## End(Not run)




