### Name: interp.surface
### Title: Fast bilinear interpolator from a grid.
### Aliases: interp.surface interp.surface.grid
### Keywords: spatial

### ** Examples

#
# evaluate an image at a finer grid
# 

data( lennon)
# create the surface object
obj<- list( x= 1:20, y=1:20, z= lennon[ 201:220, 201:220])

# sample at 50 equally spaced points 
temp<- seq( 1,20,,50)
make.surface.grid( list( temp,temp))-> loc
interp.surface( obj, loc)-> look
# take a look
image.plot( as.surface( loc, look))




