### Name: predict.se.Krig
### Title: Standard errors of predictions for Krig spatial process estimate
### Aliases: predict.se.Krig predict.se.KrigA
### Keywords: spatial

### ** Examples

# 
# Note: in these examples predict.se will default to predict.se.Krig using 
# a Krig object  

  fit<- Krig(ozone$x,ozone$y,cov.function="Exp.cov", theta=10)    # Krig fit 
  predict.se.Krig(fit)      # std errors of predictions at obs.

# make a  grid of X's  
  xg<-make.surface.grid( 
  list(East.West=seq(-27,34,,20),North.South=seq(-20,35,,20)))     
  out<- predict.se.Krig(fit,xg)   # std errors of predictions 

#at the grid points out is a vector of length 400 
#reshape the grid points into a 20X20 matrix etc.  

   out.p<-as.surface( xg, out) 
   surface( out.p, type="C") 

# this is equivalent to  the single step function  
# (but default is not to extrapolation beyond data
# out<- predict.surface.se( fit) 
# image.plot( out) 





