### Name: predict.surface
### Title: Evaluates a fitted function or its standard errors as a surface
###   object
### Aliases: predict.surface predict.surface.se
### Keywords: spatial

### ** Examples

fit<- Tps( BD[,1:4], BD$lnya)  # fit surface to data 

# evaluate fitted surface for  first two 
# variables holding other two fixed at median values

out.p<- predict.surface(fit)
surface(out.p, type="C") 

#
# plot surface for second and fourth variables 
# on specific grid. 

glist<- list( KCL=29.77, MgCl2= seq(3,7,,25), KPO4=32.13, 
                     dNTP=seq( 250,1500,,25))

out.p<- predict.surface(fit, glist)
surface(out.p, type="C")

out.p<- predict.surface.se(fit, glist)
surface(out.p, type="C")





