### Name: sim.Krig
### Title: Conditonal simulation of a spatial process
### Aliases: sim.Krig.standard sim.Krig.grid
### Keywords: spatial

### ** Examples

data( ozone2)

set.seed( 399)

# fit to day 16 from Midwest ozone data set.
Krig( ozone2$lon.lat, ozone2$y[16,], Covariance="Matern", 
theta=1.0,smoothness=1.0, na.rm=TRUE)-> out

# NOTE theta =1.0 is not the best choice but 
# allows the sim.rf circulant embedding algorithm to 
# work without increasing the domain.

#six missing data locations
 xp<-  ozone2$lon.lat[ is.na(ozone2$y[16,]),]

# 50 draws from process at xp given the data 
# this is an exact calculation
 sim.Krig.standard( out,xp, M=50)-> sim.out

# Compare: stats(sim.out)[3,] to  Exact: predict.se( out, xp)

# simulations on a grid
# NOTE this is approximate due to the bilinear interpolation
# for simulating the unconditional random field. 

sim.Krig.grid(out,M=5)-> sim.out

# take a look at the ensemble members. 

predict.surface( out, grid= list( x=sim.out$x, y=sim.out$y))-> look

zr<- c( 40, 200)

set.panel( 3,2)
image.plot( look, zlim=zr)
title("mean surface")

for ( k in 1:5){
image( sim.out$x, sim.out$y, sim.out$z[,,k], col=tim.colors(), zlim =zr)
}




