### Name: tim.colors
### Title: Some useful color tables for images.
### Aliases: tim.colors two.colors designer.colors
### Keywords: aplot

### ** Examples


tim.colors(10) 
# returns an array of 10 strings in hex format
#e.g. (red, green,  blue) values of   (16,255, 239)
# translates to "#10FFEF" .

# veiw some color table choices
set.panel( 1,3)
par( pty="s")
z<- outer( 1:20,1:20, "+")

image( z, col=tim.colors( 200)) # 200 levels

image( z, col=two.colors() )

coltab<- designer.colors(col=c("blue", "grey", "green"),  x= c( 0,.3,1) ) 
image( z, col= coltab )

# peg colors at some desired quantiles  of data.
# NOTE need 0 and 1 for the color scale to make sense
x<- quantile( c(z), c(0,.25,.5,.75,1.0) )
# scale these to [0,1]
zr<- range( c(z))
x<- (x-zr[1])/ (zr[2] - zr[1])  

coltab<- designer.colors(256,rainbow(5), x)
image( z, col= coltab ) # see image.plot for adding all kinds of legends

# colors now change at quantiles of data

set.panel()




