### Name: options
### Title: Options Settings
### Aliases: spam.options spam.getOption .Spam
### Keywords: IO environment error print

### ** Examples

op <- spam.options()

# two ways of representing the options nicely.
utils::str(op)
noquote(unlist(format(op)) )

smat <- diag.spam( 1:8)
smat
spam.options( printsize=49)
smat

# Reset to default values:
spam.options( eps=.Machine$double.eps, drop=FALSE,             
   printsize=100,  imagesize=10000,   cex=1200, 
   trivalues=FALSE,   safemode=c(TRUE,TRUE,TRUE), 
   dopivoting=TRUE,       cholsymmetrycheck=TRUE,  
   cholpivotcheck=TRUE, cholupdatesingular="warning",
   cholincreasefactor=c(1.25,1.25),
   nearestdistincreasefactor=1.25,
   nearestdistnnz=c(400^2,400)     )




