### Name: spam solve
### Title: Linear Equation Solving for Sparse Matrices
### Aliases: solve.spam backsolve-methods backsolve,ANY-method
###   backsolve,spam-method backsolve,matrix-method backsolve
###   backsolve.spam backsolve.default forwardsolve-methods
###   forwardsolve,ANY-method forwardsolve,spam-method
###   forwardsolve,matrix-method forwardsolve forwardsolve.spam
###   forwardsolve.default solve solve,ANY-method solve,spam-method
### Keywords: algebra

### ** Examples

# Generate multivariate form a covariance inverse:
# (usefull for GRMF)
set.seed(13)
n <- 25    # dimension
N <- 1000  # sample size
Sigmainv <- .25^abs(outer(1:n,1:n,"-"))
Sigmainv <- as.spam( Sigmainv, eps=1e-4)

Sigma <- solve( Sigmainv)  # for verification 
iidsample <- array(rnorm(N*n),c(n,N))

mvsample <- backsolve( chol(Sigmainv), iidsample)
norm( var(t(mvsample)) - Sigma, type="HS")

# compare with:
mvsample <- backsolve( chol(as.matrix( Sigmainv)), iidsample)
norm( var(t(mvsample)) - Sigma, type="HS")


# 'solve' step by step:
b <- rnorm( n)
R <- chol(Sigmainv)
norm( backsolve( R, forwardsolve( R, b))-
      solve( Sigmainv, b),type="HS") 
norm( backsolve( R, forwardsolve( R, diag(n)))- Sigma,type="HS") 




