#include "auto_gamma.h"

double accept_reject(double alpha, double beta, double c, double peak, 
                     double y, double r, int seed)
{
   double u, f;
   int not_done=1;
   srand48(seed);

   u=drand48()*r;

   while(not_done)
   {
      f=gamma_dens(alpha,beta,u);
      if(u<peak)
      {
         if(f>y)
            not_done=0;
         else
            u=drand48()*r;
      }
   
      else
      {      
         if(c-f<y)
            not_done=0;
         else
            u=drand48()*r;
      }

   }

   return(u);
}

