#include "auto_gamma.h"

double sim_gamma(double alpha,double beta)
{
   double x, y, u, mu, lambda, t, ratio;
   int not_done=1;

   if(alpha>=1)
   {
      lambda=sqrt(2*alpha-1);
      mu=pow(alpha,lambda);
 
      while(not_done)
      {
         u=drand48();
         y=pow(mu/u-mu,1/lambda);
         u=drand48();
         t=1/(4*pow(alpha,alpha)*mu)*pow(mu+pow(y,lambda),2)
           *pow(y,alpha-lambda)*exp(alpha-y);                

         if(u<t)
	 {
            x=y;
            not_done=0;
	 }
      }
   }
   else if((alpha>0) && (alpha<1))
   {
      ratio=exp(1)/(alpha+exp(1));
      while(not_done)
      {
         u=drand48();
         if(u<ratio)
	 {
            u=drand48();
            y=pow(u,1/alpha);
            u=drand48();
            if(u<exp(-y))
	    {
               x=y;
               not_done=0;
	    }
	 }
         else
	 {
            u=drand48();
            y=1-log(u);
            u=drand48();
            if(u<pow(y,alpha-1))
	    {
               x=y;
               not_done=0;
	    }
	 }
      }
   }

   else
   {
      printf("alpha < 0!!\n");
      exit(1);
   }

   return(x/beta);
}
