#include "auto_gamma.h"

double slice_gamma1(double alpha, double beta, int *seed)
{
   double a, x, y, r, c, u, peak, gamma, inc;

   srand48(seed[0]);
   inc=0.01;

   if(alpha<1)
   {
      x=sim_gamma(alpha,beta);
      y=drand48()*gamma_dens(alpha,beta,x);
      r=find_limit(alpha,beta,x,y,0,0);
      gamma=drand48()*r;
      gamma=draw_unif(gamma,alpha,beta,y,0,0);

   }
 
   else  
   {
      a=alpha-1;
      c=pow(a,a)*exp(-a);
      peak=a/beta;

      x=sim_gamma(alpha,beta);
      u=drand48();
      y=draw_y(alpha,beta,u,x,peak,c);
      r=find_limit(alpha,beta,x,y,c,peak);
      gamma=accept_reject(alpha,beta,c,peak,y,r,seed[1]);
   }

   return(gamma);
}
