"Wu3.taper" <-
function (x1, x2, theta = 1) 
{
distance<- rdist(x1, x2)/theta
ifelse(distance < 1, 
         ((1 - distance)^6 * (1 + 6 * distance + 41/3 * 
            distance^2 + 12 * distance^3 + 5 * distance^4 + 5/6 * 
            distance^5)), 0)

}

"fig0" <-
function(){
screen.plot( xi, yi)
US( add=TRUE)
}

"fig00" <-
function(){
set.panel( 1,2)
par( mar=c( 1,1,1,4))
image.plot(out$x, out$y, muhat, axes=FALSE, xlab="", ylab="")
US( add=TRUE)
title("seasonal mean")
image.plot(out$x, out$y, shat, axes=FALSE, xlab="", ylab="")
US( add=TRUE)
title( "seasonal standard deviation")
}

"fig000" <-
function(){
cor( ozone2$y, use="pairwise")-> hold
rdist.earth( ozone2$lon.lat, ozone2$lon.lat)-> dd
ind<- col(dd)> row( dd)
plot( dd[ind], hold[ind], pch=".", col="green", xlab="miles", 
ylab="correlation") 
bplot.xy( dd[ind], hold[ind], add=TRUE)

}

"fig1" <-
function(ens){
# well, this is pretty messy! 
# plots ensemble means and then first 5 members in a panel

set.panel( 2,3)  
par( mar= c( 2,1,1,1))
rowMeans( ens)-> ensM
#zr<- range( ens[,1:5]) 
zr<- c( 0,200)

image( out$x, out$y, matrix( ensM, 64,64), zlim=zr, col=tim.colors(256), 
xlab="", ylab="", axes=FALSE)  
US( add=TRUE)
title("mean")

for( J in 1:5){
image( out$x, out$y, matrix( ens[,J],64,64),col=tim.colors(256),
xlab="", ylab="", axes=FALSE, zlim=zr)
US( add=TRUE)
title( paste(J), adj=1, cex=2)
}
image.plot( zlim=zr, legend.only=TRUE, horizontal=TRUE)
}

"fig2" <-
function(NN){

# NN is the number of observations to update
ens<- ens.save

for ( k in 1:NN){  
 update(ens,k)-> ens  
}
fig1(ens)

}

"figD" <-
function(){

image.plot( out$x, out$y, muhat, zlim=c(0,200), xlab="", ylab="", 
axes=FALSE)
US( add=TRUE)
system("sleep 5")   


NN<- length( yi)
ens<- ens.save

for ( k in 1:NN){  
 update(ens,k)-> ens  
# rowMeans( ens)-> ensM
 image( out$x, out$y, matrix( rowMeans(ens), 64,64), 
    add=TRUE,col=tim.colors(),zlim=c(0,200)) 
 points(xi[1:k,1], xi[1:k,2] , pch="+")
 points(xi[k,1], xi[k,2] , pch="O", col="magenta", cex=2)
if( k < 3) {system("sleep 5")}
else{ system("sleep .25")}
}
system("sleep 5")
US( add=TRUE) 
title( "posterior mean") 
}

"figE" <-
function(alpha=0){

image.plot( out$x, out$y, muhat, zlim=c(0,200), xlab="", ylab="", 
axes=FALSE)

NN<- length( yi)
ens<- ens.save

for ( k in 1:NN){  
 update2(ens,k, alpha=alpha)-> ens  
# rowMeans( ens)-> ensM
 image( out$x, out$y, matrix( rowMeans(ens), 64,64), 
    add=TRUE,col=tim.colors(),zlim=c(0,200)) 
 points(xi[1:k,1], xi[1:k,2] , pch="+")
 points(xi[k,1], xi[k,2] , pch="O", col="magenta", cex=2)
#system("sleep .25")
}

US( add=TRUE) 
title( "posterior mean") 
}

"update" <-
function(ens,k, alpha=0){
# update ensembles with kth observation. 
# alpha is multiplier to set the sizeof measurement error (or the nugget 
# variance

I<- ind[k]  # actual position of kth obs in stacked array

# tapering function
taper <- c(Wu3.taper( xg,  matrix(xg[I,],ncol=2) , theta=4))

# measurment error ( default ~ 0 based on correlogram of ozone)

R<- alpha* shat[I]**2

# variance of I component of ensembles.
vI<- var( c( ens[I,]))
# the tapered Kalman Gain
wght<- c(var( t( ens), c(ens[I,])))*taper/(vI + R )

# random perturbation for the perturbed obs method. 
err<- rnorm(1)* sqrt( R)
#
# the update to all ensemble members
ens + wght*( yi[k]- ens[I] + err )

}

