
library( fields)

data(ozone2)

x<- ozone2$lon.lat
y<- ozone2$y[16,]
good<- !is.na(y)

x<- x[good,]
y<- y[good]
# sort y's 



# discretize ozone data to a 64X 64 grid
as.image( y, x=x, nrow=64, ncol=64)-> out

yi<- out$z[ out$ind] 
xi<- cbind( out$x[ out$ind[,1] ], out$y[ out$ind[,2] ] )

# position of observations in stacked array of image (see update)
ind<- matrix( 1:64**2, 64,64)[ out$ind]


# x y values of grid
grid<- list( x=out$x, y=out$y)
# these are all the 64**2 locations
xg<- make.surface.grid( grid)

# set up FFT for simulating a random field with Matern covariance
# default here is an exponential 
matern.image.cov( setup=TRUE, grid= grid, theta=4, M=512, N=512)-> cov.obj
# means and SDs

stats( ozone2$y)-> shold

# smooth surfaces now fit to means and sds and evaluated on the grid 
# values are then reformed as an image (matrix).

Tps( ozone2$lon.lat, shold[2,])-> mu.obj
muhat<- matrix( predict( mu.obj, xg),64,64)

Tps( ozone2$lon.lat, shold[3,])-> sd.obj
shat<- matrix( predict( sd.obj, xg),64,64)

# make up initial values for ensemble fields store as stacked vector

MM<- 100
ens<- matrix( NA, 64**2, MM)

# fix seed so results are reproducable.
set.seed(123)

# generate MM random fields.
cat( "generating " , MM , "member initial ensemble, this takes a 
while ... ",fill=TRUE) for (  k in 1:MM){
cat( k, " ")
ens[,k]<- sim.rf( cov.obj)
}

cat( " all done", fill=TRUE)

# ensembles have mean 0 and variance 1. 
# coerce so that their sample means and variances match the 
# marginal quantities
ens<- c(shat)* t(scale(t(ens))) + c(muhat)

# save these initial ensembles

ens.save<- ens

NN<- length( yi)

# see figD and fig2 for updating ensemble with data points

