#! /bin/csh -f

if !(-d $CASEBUILD/rtmconf) mkdir -p $CASEBUILD/rtmconf

#------------------------------
# Verify rof grid is supported

set check_grid = "fail"
if (${ROF_GRID} == "null")set check_grid = "OK"
if (${ROF_GRID} == "r05") set check_grid = "OK"
if (${ROF_GRID} == "r01") set check_grid = "OK"

if (${check_grid} != "OK") then
  echo "ROF_GRID=${ROF_GRID} not supported in rtm"
  echo "  rtm support on null (for single point runs), r05 and r01 ROF_GRIDs only"
  exit -2
endif

#------------------------------

set default_rof_in_filename = "rof_in"

set inst_counter = 1
while ($inst_counter <= $NINST_ROF)

if ($NINST_ROF > 1) then
   set inst_string = `printf _%04d $inst_counter`
else
   set inst_string = ""       
endif
set rof_in_filename = ${default_rof_in_filename}${inst_string}

setenv INST_STRING $inst_string

cd $CASEBUILD/rtmconf  

if (-e $CASEBUILD/rtm.input_data_list) rm $CASEBUILD/rtm.input_data_list

# The following is for backwards compatibility when runoff restart data was on clm restart files
set finidat_rtm = ""
set nrevsn_rtm = ""
if (${ROF_GRID} != "null") then
if ($RUN_TYPE == 'hybrid' || $RUN_TYPE == "branch" ) then

  # set search directory
  if ($GET_REFCASE == 'TRUE') then
    set refdir = "$DIN_LOC_ROOT/ccsm4_init/$RUN_REFCASE/$RUN_REFDATE"
  else
    set refdir = "$RUNDIR"
  endif

  # search for clm or rtm files with instance or not
  set fncheck = "${RUN_REFCASE}.rtm${inst_string}.r.${RUN_REFDATE}-${RUN_REFTOD}.nc"
  if !(-e "$refdir/$fncheck") then
    set fncheck = "${RUN_REFCASE}.rtm.r.${RUN_REFDATE}-${RUN_REFTOD}.nc"
    if !(-e "$refdir/$fncheck") then
      set fncheck = "${RUN_REFCASE}.clm2${inst_string}.r.${RUN_REFDATE}-${RUN_REFTOD}.nc"
      if !(-e "$refdir/$fncheck") then
        set fncheck = "${RUN_REFCASE}.clm2.r.${RUN_REFDATE}-${RUN_REFTOD}.nc"
        if !(-e "$refdir/$fncheck") then
          echo "WARNING: rtm.buildnml.csh could not find restart file for branch or hybrid start"
          echo "WARNING: looking for a file with a name like:"
          echo "  ${refdir}/${RUN_REFCASE}.[rtm${inst_string},clm2${inst_string}].r.${RUN_REFDATE}-${RUN_REFTOD}.nc"
#         exit -8
          set fncheck = "unknown at this time"
        endif
      endif
    endif
  endif

  # set the namelist variable needed
  if ($RUN_TYPE == "hybrid") then
    set finidat_rtm = "finidat_rtm = '$fncheck'"
  endif
  if ($RUN_TYPE == "branch") then
    set nrevsn_rtm = "nrevsn_rtm = '$refdir/$fncheck'"
  endif

endif
endif

cat >! $CASEBUILD/rtmconf/cesm_namelist << EOF2
&rtm_inparm
 $finidat_rtm
 $nrevsn_rtm
 $RTM_NAMELIST_OPTS
EOF2
if (-e $CASEROOT/user_nl_rtm${inst_string}) then
  $UTILROOT/Tools/user_nl_add -user_nl_file $CASEROOT/user_nl_rtm${inst_string} >> $CASEBUILD/rtmconf/cesm_namelist  || exit -2
endif
cat >> $CASEBUILD/rtmconf/cesm_namelist << EOF2
/
EOF2

cd $CASEBUILD/rtmconf  
$CODEROOT/rof/rtm/bld/build-namelist \
    -infile $CASEBUILD/rtmconf/cesm_namelist \
    -caseroot $CASEROOT \
    -scriptsroot $SCRIPTSROOT \
    -inst_string "$inst_string" $RTM_BLDNML_OPTS || exit -4

if (-d ${RUNDIR}) then
  cp $CASEBUILD/rtmconf/rof_in ${RUNDIR}/$rof_in_filename || exit -2
endif

@ inst_counter = $inst_counter + 1

end


