
# Publications using DART

 **This list gets updated as frequently as possible, however some more
 recent publications may also be available on the UCAR/NCAR online
 database [https://opensky.ucar.edu](https://opensky.ucar.edu/).**
 Simply use it and search for "ensemble data assimilation" (for
 example). Many, if not most, are related to DART. The following list
 also contains some publications from our collaborators. If you would
 like to list your publication that uses DART, please let us know!
 (dart@ucar.edu)

### To cite DART:

The DOI for DART is [doi:10.5065/D6WQ0202](http://doi.org/10.5065/D6WQ0202)  

and the seminal reference is:   

**Anderson, J. L., T. Hoar, K. Raeder, H. Liu, N. Collins, R. Torn
and A. Arellano**, 2009  
The Data Assimilation Research Testbed: A Community Facility.  
*Bulletin of the American Meteorological Society*, **90**, 1283-1296,
[doi:10.1175/2009BAMS2618.1](http://dx.doi.org/10.1175/2009BAMS2618.1)

----
## 2018
----

 ![](http://www.image.ucar.edu/images/pin4.gif) **Aydoğdu, A., Hoar, T. J.,
   Vukicevic, T., Anderson, J. L., Pinardi, N., Karspeck, A., Hendricks, J.,
   Collins, N., Macchia, F., and Özsoy, E.** 2018  
     OSSE for a sustainable marine observing network in the Sea of Marmara.  
     *Nonlin. Processes Geophys*, **25**, 537-551,
     [doi.org/10.5194/npg-25-537-2018](https://doi.org/10.5194/npg-25-537-2018)


 ![](http://www.image.ucar.edu/images/pin4.gif) **El Gharamti M.**, 2018  
     Enhanced Adaptive Inflation Algorithm for Ensemble Filters.  
     *Monthly Weather Review*, **2**, 623-640,
     [doi:10.1175/MWR-D-17-0187.1](http://dx.doi.org/doi:10.1175/MWR-D-17-0187.1)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Karspeck, A. R., G. Danabasoglu,
   J. L. Anderson, S. Karol, N. Collins, M. Vertenstein, K. Raeder, T. Hoar, 
   R. Neale, J. Edwards and A. Craig**, 2018  
     A global coupled ensemble data assimilation system using the Community
     Earth System Model and the Data Assimilation Research Testbed.  
     *Quarterly Journal of the Royal Meteorological Society*  
     [doi:10.1002/qj.3308](http://dx.doi.org/doi:10.1002/qj.3308)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Toye, H., S. Kortas, P. Zhan
   and I. Hoteit**, 2018  
     A fault-tolerant HPC scheduler extension for large and operational ensemble
     data assimilation: Application to the Red Sea.  
     *Journal of Computational Science*, **27**, 46-56,
     [doi:10.1016/j.jocs.2018.04.018](http://dx.doi.org/doi:10.1016/j.jocs.2018.04.018)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Zhang, Y. -F., C. M. Bitz,
   J. L. Anderson, N. Collins, J. Hendricks, T. Hoar, K. Raeder and F. Massonnet**, 2018  
     Insights on Sea Ice Data Assimilation from Perfect Model Observing System
     Simulation Experiments.  
     *Journal of Climate*,
     [doi:10.1175/JCLI-D-17-0904.1](http://dx.doi.org/doi:10.1175/JCLI-D-17-0904.1)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Pedatella, N. M., H.‐L. Liu,
   D. R. Marsh, K. Raeder, J. L. Anderson, J. L. Chau, L. P. Goncharenko
   and T. A. Siddiqui**, 2018  
     Analysis and Hindcast Experiments of the 2009 Sudden Stratospheric
     Warming in WACCMX+ DART.  
     *Journal of Geophysical Research: Space Physics*, **123**, 3131-3153,
     [doi:10.1002/2017JA025107](http://dx.doi.org/doi:10.1002/2017JA025107)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Clark, A. J., I. L. Jirak,
   S. R. Dembek, G. J. Creager, F. Kong, K. W. Thomas, K. H. Knopfmeier, B. T. Gallo,
   C. J. Melick, M. Xue, and K. A. Brewster**, 2018  
     The Community Leveraged Unified Ensemble (CLUE) in the 2016 NOAA/Hazardous
     Weather Testbed Spring Forecasting Experiment.  
     *Bulletin of the American Meteorological Society*,
     [doi:10.1175/WAF-D-16-0178.1](http://dx.doi.org/doi:10.1175/WAF-D-16-0178.1)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Pan, S., J. Gao, D. J. Stensrud,
   X. Wang and T. A. Jones**, 2018  
     Assimilation of Radar Radial Velocity and Reflectivity,
     Satellite Cloud Water Path, and Total Precipitable Water for
     Convective-Scale NWP in OSSEs.  
     *Journal of Atmospheric and Oceanic Technology*, **35**, 67-89,
     [doi:10.1175/JTECH-D-17-0081.1](http://dx.doi.org/doi:10.1175/JTECH-D-17-0081.1)

---
## 2017
----

 ![](http://www.image.ucar.edu/images/pin4.gif) **Gaubert, B., H. M. Worden,
   A. F. J. Arellano, L. K. Emmons, S. Tilmes, J. Barré, S. Martinez Alonso,
   F. Vitt, J. L. Anderson, F. Alkemade, S. Houweling, D. P. Edwards**, 2017  
     Chemical feedback from decreasing carbon monoxide emissions.  
     *Geophysical Research Letters*, **44**, 9985-9995,
     [doi:10.1002/2017GL074987](http://dx.doi.org/doi:10.1002/2017GL074987)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Lee, J. A., J. P. Hacker,
   L. Delle Monache, B. Kosović, A. Clifton, F. Vandenberghe and J. S. Rodrigo**, 2017  
     Improving wind predictions in the marine atmospheric boundary layer through
     parameter estimation in a single-column model.  
     *Monthly Weather Review*, **145**, 5-24,
     [doi:10.1175/MWR-D-16-0063.1](http://dx.doi.org/doi:10.1175/MWR-D-16-0063.1)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Gu, S. -Y., H. Liu,
   N. M. Pedatella, X. Dou, and Y. Liu**, 2017  
     On the wave number 2 eastward propagating quasi 2 day wave at middle and high latitudes.  
     *Journal of Geophysical Research: Space Physics*, **122**, 4489-4499,
     [doi:10.1002/2016JA023353](http://dx.doi.org/doi:10.1002/2016JA023353)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Hodyss, D., J. L. Anderson,
   N. Collins, W. F. Campbell and P. A. Reinecke**, 2017  
     Quadratic polynomial regression using serial observation processing:
     Implementation within DART.  
     *Monthly Weather Review*, **145**, 4467-4479,
     [doi:10.1175/MWR-D-17-0089.1](http://dx.doi.org/doi:10.1175/MWR-D-17-0089.1)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Kwon, Y., Z. -L. Yang, T. J. Hoar
   and A. M. Toure**, 2017  
     Improving the radiance assimilation performance in estimating snow water
     storage across snow and land-cover types in North America.  
     *Journal of Hydrometeorology*, **18**, 651-668,
     [doi:10.1175/JHM-D-16-0102.1](http://dx.doi.org/doi:10.1175/JHM-D-16-0102.1)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Keclik, A. M., C. Evans,
   P. J. Roebber and G. S. Romine**, 2017  
     The influence of assimilated upstream, preconvective dropsonde observations
     on ensemble forecasts of convection initiation during the Mesoscale
     Predictability Experiment.  
     *Monthly Weather Review*, **145**, 4747-4770,
     [doi:10.1175/MWR-D-17-0159.1](http://dx.doi.org/doi:10.1175/MWR-D-17-0159.1)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Liu, X., A. P. Mizzi,
   J. L. Anderson, I. Y. Fung and R. C. Cohen**, 2017  
     Assimilation of satellite NO2 observations at high spatial resolution using OSSEs.  
     *Atmospheric Chemistry and Physics*, **17**, 7067-7081,
     [doi:10.5194/acp-17-7067-2017](http://dx.doi.org/doi:10.5194/acp-17-7067-2017)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Ha, S., C. Snyder, W. C. Skamarock,
   J. Anderson and N. Collins**, 2017  
     Ensemble Kalman filter data assimilation for the Model for
     Prediction Across Scales (MPAS).  
     *Monthly Weather Review*, **145**, 4673-4692,
     [doi:10.1175/MWR-D-17-0145.1](http://dx.doi.org/doi:10.1175/MWR-D-17-0145.1)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Rubin, J. I., J. S. Reid,
   J. A. Hansen, J. L. Anderson, B. N. Holben, P. Xian, D. L. Westphal and J. Zhang**, 2017  
     Assimilation of AERONET and MODIS AOT observations using variational
     and ensemble data assimilation methods and its impact on aerosol forecasting skill.  
     *Journal of Geophysical Research: Atmospheres*, **122**, 4967-4992,
     [doi:10.1002/2016JD026067](http://dx.doi.org/doi:10.1002/2016JD026067)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Chen, C. ‐H., C. Lin, Wei. ‐H. Chen,
   and T. Matsuo**, 2017  
     Modeling the ionospheric prereversal enhancement by using coupled
     thermosphere‐ionosphere data assimilation.  
     *Geophysical Research Letters*, **44**, 1652-1659,
     [doi:10.1002/2016GL071812](http://dx.doi.org/doi:10.1002/2016GL071812)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Poterjoy, J., R. A. Sobash
   and J. L. Anderson**, 2017  
     Convective-scale data assimilation for the weather research and forecasting
     model using the local particle filter.  
     *Monthly Weather Review*, **145**, 1897-1918,
     [doi:10.1175/MWR-D-16-0298.1](http://dx.doi.org/doi:10.1175/MWR-D-16-0298.1)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Chen, C. ‐H., C. Lin, Wei. ‐H. Chen,
   T. Matsuo and W. H. Chen**, 2017  
     The impact of FORMOSAT-5/AIP observations on the ionospheric space weather.  
     *Terrestrial, Atmospheric and Oceanic Sciences*, **28**, 129-137,
     [doi:10.3319/TAO.2016.09.30.01(EOF5)](http://dx.doi.org/doi:10.3319/TAO.2016.09.30.01(EOF5))


 ![](http://www.image.ucar.edu/images/pin4.gif) **Velden, C., W. E. Lewis, W. Bresky,
   D. Stettner, J. Daniels and S. Wanzong**, 2017  
     Assimilation of high-resolution satellite-derived atmospheric motion vectors:
     Impact on HWRF forecasts of tropical cyclone track and intensity.  
     *Monthly Weather Review*, **145**, 1107-1125,
     [doi:10.1175/MWR-D-16-0229.1](http://dx.doi.org/doi:10.1175/MWR-D-16-0229.1)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Kerr, C. A., D. J. Stensrud
   and X. Wang**, 2017  
     Verification of convection-allowing model ensemble analyses of near-storm
     environments using MPEX upsonde observations.  
     *Monthly Weather Review*, **145**, 857-875,
     [doi:10.1175/MWR-D-16-0287.1](http://dx.doi.org/doi:10.1175/MWR-D-16-0287.1)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Madaus, L. E. and C. F. Mass**, 2017  
     Evaluating Smartphone Pressure Observations for Mesoscale Analyses and Forecasts.  
     *Monthly Weather Review*, **32**, 511-531,
     [doi:10.1175/WAF-D-16-0135.1](http://dx.doi.org/doi:10.1175/WAF-D-16-0135.1)

---
## 2016
---

 ![](http://www.image.ucar.edu/images/pin4.gif) **Gaubert, B., A. F. Arellano Jr.,
   J. Barré, H. M. Worden, L. K. Emmons, S. Tilmes, R. R. Buchholz, F. Vitt,
   K. Raeder, N. Collins, J. L. Anderson, C. Wiedinmyer, S. Martinez Alonso,
   D. P. Edwards, M. O. Andreae, J. W. Hannigan, C. Petri, K. Strong, N. Jones** , 2016  
     Toward a chemical reanalysis in a coupled chemistry-climate model:
     An evaluation of MOPITT CO assimilation and its impact on tropospheric composition.  
     *Journal of Geophysical Research: Atmospheres*, **121**, 7310-7343,
     [doi:10.1002/2016JD024863](http://dx.doi.org/doi:10.1002/2016JD024863)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Jewtoukoff, V., R. Plougonven,
   A. Hertzog, C. Snyder and G. Romine**, 2016  
     On the prediction of stratospheric balloon trajectories:
     Improving winds with mesoscale simulations.  
     *Journal of Atmospheric and Oceanic Technology*, **33**, 1629-1647,
     [doi:10.1175/JTECH-D-15-0110.1](http://dx.doi.org/doi:10.1175/JTECH-D-15-0110.1)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Gu, S. -Y., H. -L. Liu,
   N. M. Pedatella, X. Dou and Z. Shu**, 2016  
     The quasi-2 day wave activities during 2007 boreal summer period as
     revealed by Whole Atmosphere Community Climate Model.  
     *Journal of Geophysical Research: Space Physics*, **121**, 2743-2754,
     [doi:10.1002/2015JA022225](http://dx.doi.org/doi:10.1002/2015JA022225)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Pedatella, N., J. Oberheide,
   E. K. Sutton, H. Liu, J. L. Anderson and K. D. Raeder**, 2016  
     Short-term nonmigrating tide variability in the mesosphere, thermosphere,
     and ionosphere.  
     *Journal of Geophysical Research: Space Physics*, **121**, 3621-3633,
     [doi:10.1002/2016JA022528](http://dx.doi.org/doi:10.1002/2016JA022528)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Zhao, L., Z. -L. Yang
   and T. J. Hoar**, 2016  
     Global soil moisture estimation by assimilating AMSR-E brightness
     temperatures in a coupled CLM4-RTM-DART system.  
     *Journal of Hydrometeorology*, **17**, 2431-2454,
     [doi:10.1175/JHM-D-15-0218.1](http://dx.doi.org/doi:10.1175/JHM-D-15-0218.1)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Dikpati, M., D. Mitra
   and J. L. Anderson**, 2016  
     Role of response time of a Babcock-Leighton solar dynamo model in
     meridional flow-speed reconstruction by EnKF data assimilation.  
     *Advances in Space Research*, **58**, 1589-1595,
     [doi:10.1016/j.asr.2016.08.004](http://dx.doi.org/doi:10.1016/j.asr.2016.08.004)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Mizzi, A. P., A. F. Arellano,
   D. P. Edwards, J. L. Anderson and G. Pfister**, 2016  
     Assimilating compact phase space retrievals of atmospheric composition
     with WRF-Chem/DART: a regional chemical transport/ensemble Kalman filter
     data assimilation system.  
     *Geoscientific Model Development*, **9**, 965-978,
     [doi:10.5194/gmd-9-965-2016](http://dx.doi.org/doi:10.5194/gmd-9-965-2016)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Dikpati M., J. L. Anderson
   and D. Mitra**, 2016  
     Data assimilation in a solar dynamo model using ensemble Kalman filters:
     Sensitivity and robustness in reconstruction of meridional flow speed.  
     *The Astrophysical Journal*, **828**, 91,
     [doi:10.3847/0004-637X/828/2/91](http://dx.doi.org/doi:10.3847/0004-637X/828/2/91)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Penny, A. B., J. P. Hacker,
   P. A. Harr**, 2016  
     Analysis of tropical storm formation based on ensemble data assimilation
     and high-resolution numerical simulations of a nondeveloping disturbance.  
     *Monthly Weather Review*, **144**, 3631-3649,
     [doi:10.1175/MWR-D-16-0100.1](http://dx.doi.org/doi:10.1175/MWR-D-16-0100.1)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Garcia, M., T. Hoar, M. Thomas,
   B. Bailey and J. Castillo**, 2016  
     Interfacing an ensemble Data Assimilation system with a 3D nonhydrostatic
     Coastal Ocean Model, an OSSE experiment.  
     *OCEANS MTS/IEEE Monterey*, pp. 1-11,
     [doi:10.1109/OCEANS.2016.7760992](http://dx.doi.org/doi:10.1109/OCEANS.2016.7760992)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Chartier, A. T., T. Matsuo,
   J. L. Anderson, N. S. Collins, T. J. Hoar, G. Lu, C. N. Mitchell, A. J. Coster,
   L. J. Paxton, G. S. Bust**, 2016  
     Ionospheric data assimilation and forecasting during storms.  
     *Journal of Geophysical Research: Space Physics*, **121**, 764-778,
     [doi:10.1002/2014JA020799](http://dx.doi.org/doi:10.1002/2014JA020799)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Rubin, J. I., J. S. Reid,
   J. A. Hansen, J. L. Anderson, N. S. Collins, T. J. Hoar, T. Hogan, P. Lynch,
   J. McLay, Carolyn A. Reynolds, W. R. Sessions, D. L. Westphal and J. Zhang**, 2016  
     Development of the Ensemble Navy Aerosol Analysis Prediction System (ENAAPS)
     and its application of the Data Assimilation Research Testbed (DART)
     in support of aerosol forecasting.  
     *Atmospheric Chemistry and Physics*, **15**, 28069-28132,
     [doi:10.5194/acpd-15-28069-2015](http://dx.doi.org/doi:10.5194/acpd-15-28069-2015)

---
## 2015
---

 ![](http://www.image.ucar.edu/images/pin4.gif) **Barré, J., B. Gaubert,
   A. F. J. Arellano, H. M. Worden, D. P. Edwards, M. Deeter, J. L. Anderson,
   K. D. Raeder, N. S. Collins, S. Tilmes, G. Francis, C. Clerbaux, L. Emmons,
   G. Pfister, P.-F. Coheur and D. Hurtmans**, 2015  
     Assessing the impacts of assimilating IASI and MOPITT CO retrievals using
     CESM-CAM-chem and DART  
     *Journal of Geophysical Research: Atmospheres*, **120**, no. 19,
     [doi:10.1002/2015JD023467](http://dx.doi.org/doi:10.1002/2015JD023467)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Bernardet, L., V. Tallapragada,
   S. Bao, S. Trahan, Y. Kwon, Q. Liu, M. Tong, M. Biswas, T. Brown, D. Stark,
   L. Carson, R. Yablonsky, E. Uhlhorn, S. Gopalakrishnan, X. Zhang, T. Marchok,
   Y. H. Kuo and R. Gall**, 2015  
     Community support and transition of research to operations for the
     Hurricane Weather Research and Forecasting Model.  
     *Bulletin of the American Meteorological Society*, **96**, 953-960,
     [doi:10.1175/BAMS-D-13-00093.1](http://dx.doi.org/doi:10.1175/BAMS-D-13-00093.1)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Ha, S.-Y., J. Berner
   and C. M. Snyder**, 2015  
     A comparison of model error representations in mesoscale ensemble data assimilation.  
     *Monthly Weather Review*, **143**, 3893-3911,
     [doi:10.1175/MWR-D-14-00395.1](http://dx.doi.org/doi:10.1175/MWR-D-14-00395.1)

---
## 2014
---

 ![](http://www.image.ucar.edu/images/pin4.gif) **Wu, T.-C., H. Liu, S. J. Majumdar,
   C. S. Velden, J. L. Anderson**, 2014  
     Influence of assimilating satellite-derived atmospheric motion vector observations
     on numerical analyses and forecasts of tropical cyclone track and intensity.  
     *Monthly Weather Review*, **142**, 49-71,
     [doi:10.1175/MWR-D-13-00023.1](http://dx.doi.org/doi:10.1175/MWR-D-13-00023.1)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Lei, L. and J. L. Anderson**, 2014  
     Impacts of frequent assimilation of surface pressure observations on
     atmospheric analyses.  
     *Monthly Weather Review*, **142** 4477-4483,
     [doi:10.1175/MWR-D-14-00097.1](http://dx.doi.org/doi:10.1175/MWR-D-14-00097.1)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Dikpati, M., J. L. Anderson
   and D. Mitra**, 2014  
     Ensemble Kalman filter data assimilation in a Babcock-Leighton solar dynamo
     model: An observation system simulation experiment for reconstructing
     meridional flow speed.  
     *Geophysical Research Letters*, **41** 5361-5369,
     [doi:10.3847/0004-637X/828/2/91](http://dx.doi.org/doi:10.3847/0004-637X/828/2/91)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Ha, S.-Y. and C. Snyder**, 2014  
     Influence of surface observations in mesoscale data assimilation using an
     ensemble Kalman filter.  
     *Monthly Weather Review*, **142** 1489-1508,
     [doi:10.1175/MWR-D-13-00108.1](http://dx.doi.org/doi:10.1175/MWR-D-13-00108.1)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Pedatella, N., K. D. Raeder,
   J. L. Anderson and H. Liu**, 2014  
     Ensemble data assimilation in the Whole Atmosphere Community Climate Model.  
     *Journal of Geophysical Research: Atmospheres*, **119** 9793-9809,
     [doi:10.1002/2014JD021776](http://dx.doi.org/doi:10.1002/2014JD021776)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Zhang, Y.-F., T. J. Hoar,
   Z.-L. Yang, J. L. Anderson, A. M. Toure and M. Rodell**, 2014  
     Assimilation of MODIS snow cover through the Data Assimilation Research Testbed
     and the Community Land Model version 4.  
     *Journal of Geophysical Research: Atmospheres*, **142** 1489-1508,
     [doi:10.1002/2013JD021329](http://dx.doi.org/doi:10.1002/2013JD021329)


---
## 2013
---

 ![](http://www.image.ucar.edu/images/pin4.gif) **Hoteit, I., T. J. Hoar,
   G. Gopalakrishnan, N. Collins, J. L. Anderson, B. Cornuelle, A. Kohl
   and P. Heimbach**, 2013  
     A MITgcm/DART ensemble analysis and prediction system with application
     to the Gulf of Mexico.  
     *Dynamics of Atmospheres and Oceans*, **63**, 1-23,
     [doi:10.1016/j.dynatmoce.2013.03.002](http://dx.doi.org/doi:10.1016/j.dynatmoce.2013.03.002)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Hacker, J. and W. Angevine**, 2013  
     Ensemble data assimilation to characterize surface-layer errors in
     numerical weather prediction models.  
     *Monthly Weather Review*, **141**, 1804-1821,
     [doi:10.1175/MWR-D-12-00280.1](http://dx.doi.org/doi:10.1175/MWR-D-12-00280.1)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Rostkier-Edelstein, D.
   and J. Hacker**, 2013  
     Impact of flow-dependence, column covariance, and forecast-model type on
     surface-observations assimilation for probabilistic PBL-profiles nowcasts.  
     *Weather Forecasting*, **28**, 29-54,
     [doi:10.1175/WAF-D-12-00043.1](http://dx.doi.org/doi:10.1175/WAF-D-12-00043.1)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Morozov, A. V., A. J. Ridley,
   D. S. Bernstein, N. Collins, T. J. Hoar and J. L. Anderson**, 2013  
     Data assimilation and driver estimation for the Global Ionosphere-Thermosphere Model
     using the Ensemble Adjustment Kalman Filter.  
     *Journal of Atmospheric and Solar-Terrestrial Physics*, **104**, 126-136,
     [doi:10.1016/j.jastp.2013.08.016](http://dx.doi.org/doi:10.1016/j.jastp.2013.08.016)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Morozov, A. V., A. J. Ridley,
   D. S. Bernstein, N. Collins, T. J. Hoar and J. L. Anderson**, 2013  
     Development and verification of a new wind speed forecasting system
     using an ensemble Kalman filter data assimilation technique in a fully
     coupled hydrologic and atmospheric model.  
     *Journal of Advances in Modeling Earth Systems*, **5**, 785-800,
     [doi:10.1002/jame.20051](http://dx.doi.org/doi:10.1002/jame.20051)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Romine, G. S., C. S. Schwartz,
   C. Snyder, J. L. Anderson and M. L. Weisman**, 2013  
     Model bias in a continuously cycled assimilation system and its influence
     on convection-permitting forecasts.  
     *Monthly Weather Review*, **141**, 1263-1284,
     [doi:10.1175/MWR-D-12-00112.1](http://dx.doi.org/doi:10.1175/MWR-D-12-00112.1)

---
## 2012
---

 ![](http://www.image.ucar.edu/images/pin4.gif) **Raeder, K, J. L., Anderson,
   N. Collins, T. J. Hoar, J. E. Kay, P. H., Lauritzen and R. Pincus**, 2012  
     DART/CAM: An Ensemble Data Assimilation for CESM Atmospheric Models.  
     *Journal of Climate*, **25**, 6304-6317,
     [doi:10.1175/JCLI-D-11-00395.1](http://dx.doi.org/doi:10.1175/JCLI-D-11-00395.1)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Dikpati, M. and J. L. Anderson**, 2012  
     Evaluating potential for data assimilation in a flux-transport dynamo model
     by assessing sensitivity and response to meridional flow variation.  
     *The Astrophysical Journal*, **756** 20 pp. 20 pp.,
     [doi:10.1088/0004-637X/756/1/20](http://dx.doi.org/doi:10.1088/0004-637X/756/1/20)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Lee, I-Te, T. Matsuo, A. D. Richmond,
   J. Y. Liu, Wenbin Wang, C. H. Lin, J. L. Anderson a nd M. Q. Chen**, 2012  
     Assimilation of FORMOSAT‐3/COSMIC electron density profiles into a coupled
     thermosphere/ionosphere model using ensemble Kalman filtering.  
     *Journal of Geophysical Research: Space Physics*, **117** A10,
     [doi:10.1029/2012JA017700](http://dx.doi.org/doi:10.1029/2012JA017700)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Lauritzen, P. H., A. A. Mirin,
   J. Truesdale, K. Raeder, J. L. Anderson, J. Bacmeister and R. B. Neale**, 2012  
     Implementation of new diffusion/filtering operators in the CAM-FV dynamical core.  
     The International Journal of High Performance Computing Applications, **26** 63-73,
     [doi:10.1177/1094342011410088](http://dx.doi.org/doi:10.1177/1094342011410088)


---
## 2011
---

 ![](http://www.image.ucar.edu/images/pin4.gif) **Pendergrass, A. G., G. J. Hakim,
   D. S. Battisti and G. Roe**, 2011  
     Coupled air-mixed-layer temperature predictability for climate reconstruction.  
     *Journal of Climate*, **25**, 459-472,
     [doi:10.1175/2011JCLI4094.1](http://dx.doi.org/doi:10.1175/2011JCLI4094.1)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Matsuo, T.
   and E. A. Araujo-Pradere**, 2011  
     Role of thermosphere-ionosphere coupling in a global ionospheric specification.  
     *Radio Science*, **46**, RS0D23, 7pp.,
     [doi:10.1029/2010RS004576](http://dx.doi.org/doi:10.1029/2010RS004576)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Zagar, N., J. Tribbia,
   J. L. Anderson and K. Raeder**, 2011  
     Balance of the Background-Error Variances in the Ensemble Assimilation System DART/CAM.  
     *Monthly Weather Review*, **139**, 2061-2079,
     [doi:10.1175/2011MWR3477.1](http://dx.doi.org/doi:10.1175/2011MWR3477.1)


 ![](http://www.image.ucar.edu/images/pin4.gif) **C. Lee, W. G. Lawson,
   M. I. Richardson, J. L. Anderson, N. Collins, T. Hoar and M. Mischna**, 2011  
     Demonstration of ensemble data assimilation for Mars using DART, MarsWRF,
     and radiance observations from MGS TES.  
     *Journal of Geophysical Research*, **116**, E11011, 17 pp.,
     [doi:10.1029/2011JE003815](http://dx.doi.org/doi:10.1029/2011JE003815)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Otkin, J. A.**, 2011  
     Assessing the impact of the covariance localization radius when assimilating
     infrared brightness temperature observations using an ensemble Kalman filter.  
     *Monthly Weather Review*, **140**, 543-561,
     [doi:10.1175/MWR-D-11-00084.1](http://dx.doi.org/doi:10.1175/MWR-D-11-00084.1)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Otkin, J. A., D. C. Hartung,
   D. D. Turner, R. Peterson, W. F. Feltz and E. Janzon**, 2011  
     Assimilation of surface-based boundary layer profiler observations during
     a cool season weather event using an Observation System Simulation Experiment.
     Part 1: Analysis impact.  
     *Monthly Weather Review*, **139**, 2309-2326,
     [doi:10.1175/2011MWR3622.1](http://dx.doi.org/doi:10.1175/2011MWR3622.1)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Otkin, J. A., D. C. Hartung,
   D. D. Turner, R. Peterson, W. F. Feltz and Erik Janzon**, 2011  
     Assimilation of surface-based boundary layer profiler observations during
     a cool season weather event using an Observation System Simulation Experiment.
     Part 2: Forecast assessment.  
     *Monthly Weather Review*, **139**, 2327-2346,
     [doi:10.1175/2011MWR3623.1](http://dx.doi.org/doi:10.1175/2011MWR3623.1)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Kay, J., K. Raeder, A. Gettelman
   and J. L. Anderson**, 2011  
     The boundary layer response to recent Arctic sea ice loss and implications
     for high-latitude climate feedbacks.  
     *Journal of Climate*, **24**, 428-447,
     [doi:10.1175/2010JCLI3651.1](http://dx.doi.org/doi:10.1175/2010JCLI3651.1)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Lauritzen, P.H., A. Mirin,
   J. E. Truesdale, K. Raeder, J. L. Anderson, J. Bacmeister and R. B. Neale**, 2011  
     Implementation of new diffusion/filtering operators in the CAM-FV dynamical core.  
     *International Journal of High Performance Computing Applications*, **26**, 63-73,
     [doi:10.1177/1094342011410088](http://dx.doi.org/doi:10.1177/1094342011410088)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Pincus, R., P. Hofmann, J. Robert,
   J. L. Anderson, K. Raeder, N. Collins and J. S. Whitaker**, 2011  
     Can Fully Accounting for Clouds in Data Assimilation Improve Short-Term
     Forecasts by Global Models?  
     *Monthly Weather Review*, **139**, 3, pp. 946-957,
     [doi:10.1175/2010MWR3412.1](http://dx.doi.org/doi:10.1175/2010MWR3412.1)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Dorita Rostkier-Edelstein
   and Joshua P. Hacker**, 2011  
     Experience and Conclusions from the Factor Separation Method:
     Ensemble Data Assimilation and Forecasting Applications  
     The Factor Separation Method in the Atmosphere- Applications and Future Prospects,  
     Pinhas Alpert and Tatiana Sholokhman, Cambridge University Press, ISBN: 9780521191739


---
## 2010
---


 ![](http://www.image.ucar.edu/images/pin4.gif) **Anderson, J. L.**, 2010  
     A Non-Gaussian Ensemble Filter Update for Data Assimilation.  
     *Monthly Weather Review*, **138** pp. 4186-4198,
     [doi:10.1175/2010MWR3253.1](http://dx.doi.org/doi:10.1175/2010MWR3253.1)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Arellano, A. F., P. G. Hess,
   D. P. Edwards and D. Baumgardner**, 2010  
     Constraints on black carbon aerosol distribution from Measurement Of Pollution
     In The Troposphere (MOPITT) CO  
     *Geophysical Research Letters*, **37** L17801,
     [doi:10.1029/2010GL044416](http://dx.doi.org/doi:10.1029/2010GL044416)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Aksoy, A., D. C. Dowell and C. Snyder**, 2010
     A multicase comparative assessment of the ensemble Kalman filter for
     assimilation of radar observations. Part II: Short-range ensemble forecasts.  
     *Monthly Weather Review*, **138**, pp 1273-1292,
     [doi:10.1175/2009MWR3086.1](http://dx.doi.org/doi:10.1175/2009MWR3086.1)


 ![](http://www.image.ucar.edu/images/pin4.gif) **C. Lee, M. I. Richardson, W. G. Lawson
    and J. L. Anderson**, 2010  
     Ensemble Data Assimilation of the Martian Atmosphere Using Temperature
     and Radiance Data from the Thermal Emission Spectrometer  
     *American Astronomical Society DPS meeting #42*, #30.09  
     Bulletin of the American Astronomical Society, Vol. 42, p.1029


 ![](http://www.image.ucar.edu/images/pin4.gif) **C. Lee, M. I. Richardson,
   W. G. Lawson, J. L. Anderson, N. Collins, T. Hoar, M. Mischna
   and A. D. Toigo**, 2010
     Initial Results from Ensemble Data Assimilation of Radiances and Retrieved
     Temperatures from TES and MCS in a Martian GCM.  
     *2010 AGU Fall Meeting*, San Francisco, Abstract P53E-1563.


 ![](http://www.image.ucar.edu/images/pin4.gif) **Davis, C., W. Wang, J. Dudhia
   and R. Torn**, 2010  
     Does increased horizontal resolution improve hurricane wind forecasts?  
     *Weather and Forecasting*, **25**, 1826-1841,
     [doi:10.1175/2010WAF2222423.1](http://dx.doi.org/doi:10.1175/2010WAF2222423.1)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Davis, C., W. Wang, S. Cavallo,
   J. Done, J. Dudhia, S. Fredrick, J. Michalakes, G. Caldwell, T. Engel and R. Torn**, 2010  
     High-resolution hurricane forecasts.  
     *Computing in Science and Engineering*, **13**, 22-30,
     [doi:10.1109/MCSE.2010.74](http://dx.doi.org/doi:10.1109/MCSE.2010.74)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Dowell, D., G. Romine and C. Snyder**, 2010  
     Ensemble storm-scale data assimilation and prediction for severe convective storms.  
     *25th Severe Local Storms Conference*  Denver, Colorado, Amer. Meteor. Soc., paper 9.5.  


 ![](http://www.image.ucar.edu/images/pin4.gif) **Otkin, J.A.**, 2010  
     Clear and cloudy-sky infrared brightness temperature assimilation
     using an ensemble Kalman filter.  
     *Journal of Geophysical Research*, **115**,**D19207**, 14pp,
     [doi:10.1029/2009JD013759](http://dx.doi.org/10.1029/2009JD013759)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Torn, R. D.**, 2010  
     Ensemble-based Sensitivity Analysis applied to African Easterly Waves.  
     *Weather and Forecasting*, **25**, 61-78,
     [doi:10.1029/2008JD011375](http://dx.doi.org/doi:10.1175/2009WAF2222255.1)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Torn, R. D.**, 2010  
     Performance of a Mesoscale Ensemble Kalman Filter (EnKF)
     During the NOAA High-Resolution Hurricane Test.  
     *Monthly Weather Review*, **138**, 4375-4392,
     [doi:10.1175/2010MWR3361.1](http://dx.doi.org/doi:10.1175/2010MWR3361.1)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Rostkier-Edelstein, D.
   and J. Hacker**, 2010  
     The roles of surface-observation ensemble assimilation and model complexity
     for nowcasting of PBL profiles: A factor separation analysis.  
     *Weather and Forecasting*, **25**, 1670-1690,
     [doi:10.1175/2010WAF2222435.1](http://dx.doi.org/doi:10.1175/2010WAF2222435.1)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Zagar, N., J. Tribbia,
   J. L. Anderson, K. Raeder and D. T. Kleist**, 2010  
     Diagnosis of systematic analysis increments by using normal modes.  
     *Quarterly Journal of the Royal Meteorological Society*, **136**, 61-76,
     [doi:10.1002/qj.533](http://dx.doi.org/doi:10.1002/qj.533)


## 2009

 ![](http://www.image.ucar.edu/images/pin4.gif) **Anderson, J. L., T. Hoar,
   K. Raeder, H. Liu, N. Collins, R. Torn and A. Arellano**, 2009  
     The Data Assimilation Research Testbed: A Community Facility.  
     *Bulletin of the American Meteorological Society*, **90**, 1283-1296,
     [doi:10.1175/2009BAMS2618.1](http://dx.doi.org/10.1175/2009BAMS2618.1)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Anderson, J. L.**, 2009  
     Spatially and temporally varying adaptive covariance inflation for ensemble filters.  
     *Tellus A*, **61**, 72-83,
     [doi:10.1111/j.1600-0870.2008.00361.x](http://dx.doi.org/doi:10.1111/j.1600-0870.2008.00361.x)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Anderson, J. L.**, 2009  
     Ensemble Kalman filters for large geophysical applications.  
     *IEEE Control Systems Magazine*, **29**, 66-82,
     [doi:10.1109/MCS.2009.932222](http://dx.doi.org/doi:10.1109/MCS.2009.932222)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Aksoy, A., D. C. Dowell
   and C. Snyder**, 2009  
     A Multicase Comparative Assessment of the Ensemble Kalman Filter
     for Assimilation of Radar Observations. Part I: Storm-Scale Analyses.  
     *Monthly Weather Review*, **137**, 1805-1824,
     [doi:10.1175/2008MWR2691.1](http://dx.doi.org/doi:10.1175/2008MWR2691.1)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Edwards, D. P., A. F. Arellano
   and M. N. Deeter**, 2009  
     A satellite observation system simulation experiment for carbon monoxide
     in the lowermost troposphere,  
     *J. Geophys. Res.* **114**, D14304,
     [doi:10.1029/2008JD011375](http://dx.doi.org/doi:10.1029/2008JD011375)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Hamill, T. M., J. S. Whitaker,
   J. L. Anderson and C. M. Snyder**, 2009  
     Comments on "Sigma-Point Kalman filter data assimilation methods for strongly
     nonlinear systems".  
     *Journal of the Atmospheric Sciences*, **66**, 3498-3500,
     [doi:10.1175/2009JAS3245.1](http://dx.doi.org/doi:10.1175/2009JAS3245.1)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Rostkier-Edelstein, D.
   and J. P. Hacker**, 2009  
     Probabilistic nowcasting of PBL profiles with surface observations
     and an ensemble filter.  
     *The 23rd Conference on Weather Analysis and Forecasting/19th
     Conference on Numerical Weather Prediction* , Omaha, NE, USA   
     [extended abstract](http://ams.confex.com/ams/23WAF19NWP/techprogram/paper_153200.htm)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Thomas, S. J., J. P. Hacker,
   and J. L. Anderson**, 2011  
     A robust formulation of the ensemble Kalman filter.  
     *Quarterly Journal of the Royal Meteorological Society*, **135**, 507-521,
     [doi:10.1002/qj.372](http://dx.doi.org/doi:10.1002/qj.372)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Zagar, N., J. Tribbia,
   J. L. Anderson, K. Raeder**, 2009  
     Uncertainties of estimates of inertia-gravity energy in the atmosphere.
     Part I: Intercomparison of four analysis systems  
     *Monthly Weather Review*, **137**, 3837-3857,
     [doi:10.1175/2009MWR2815.1](http://dx.doi.org/doi:10.1175/2009MWR2815.1)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Zagar, N., J. Tribbia,
   J. L. Anderson and K. Raeder**, 2009  
     Uncertainties of estimates of inertia-gravity energy in the atmosphere.
     Part II: Large-scale equatorial waves.  
     *Monthly Weather Review*, **137**, 3858-3873,
     [doi:10.1175/2009MWR2816.1](http://dx.doi.org/doi:10.1175/2009MWR2816.1)


---
## 2008
---


 ![](http://www.image.ucar.edu/images/pin4.gif) **Anthes, R. A., P. A. Bernhardt,
   Y. Chen, L. Cucurull, K. F. Dymond, D. Ector, S. Healy, S.-P. Ho, D. C. Hunt,
   Y.-H. Kuo, H. Liu, K. Manning, C. McCormick, T. K. Meehan, W. J. Randel,
   C. Rocken, W. Schreiner, S. V. Sokolovskiy, S. Syndergaard, D. C. Thompson,
   K. E. Trenberth, T.-K. Wee, N. L. Yen and Z. Zeng**,  
     The COSMIC/FORMOSAT-3 Mission: Early Results,  
     *Bulletin of the American Meteorological Society*, **89** No. 3, 313-333,
     [doi:10.1175/BAMS-89-3-313](http://dx.doi.org/doi:10.1175/BAMS-89-3-313)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Snyder, C., T. Bengtsson,
   P. Bickel and J. L. Anderson**, 2008
     Obstacles to high-dimensional particle filtering.
     *Monthly Weather Review*, **136**, 4629-4640,
     [doi:10.1175/2008MWR2529.1](http://dx.doi.org/doi:10.1175/2008MWR2529.1)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Zubrow, A., L. Chen
   and V. R. Kotamarthi**, 2008  
     EAKF-CMAQ: Introduction and evaluation of a data assimilation for CMAQ
     based on the ensemble adjustment Kalman filter,  
     *J. Geophys. Res.*, **113**, D09302,
     [doi:10.1029/2007JD009267](http://dx.doi.org/doi:10.1029/2007JD009267)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Liu H., J. L. Anderson,
   Y.-H. Kuo, C. Snyder and A. Caya**, 2008  
     Evaluation of a non-local observation operator in assimilation of
     CHAMP radio occultation refractivity with WRF.  
     *Monthly Weather Review*, **136** No.1, 242-256,
     [doi:10.1175/2007MWR2042.1](http://dx.doi.org/doi:10.1175/2007MWR2042.1)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Khare, S. P., J. L. Anderson,
   T. J. Hoar and D. W. Nychka**, 2008  
     An investigation into the application of an ensemble Kalman smoother to
     high-dimensional geophysical systems.  
     *Tellus Series A-dynamic Meteorology and Oceanography*, **60**, 97-112,
     [doi:10.1111/j.1600-0870.2007.00281.x](http://dx.doi.org/doi:10.1111/j.1600-0870.2007.00281.x)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Torn, R. D. and G. J. Hakim**, 2008  
     Ensemble-based sensitivity analysis.  
     *Monthly Weather Review*, **136**, 663-677,
     [doi:10.1175/2007MWR2132.1](http://dx.doi.org/doi:10.1175/2007MWR2132.1)


---
## 2007
---


 ![](http://www.image.ucar.edu/images/pin4.gif) **Anderson, J. L.**, 2007  
     An adaptive covariance inflation error correction algorithm for ensemble filters.  
     *Tellus A*, **59**, 210-224,
     [doi:10.1111/j.1600-0870.2006.00216.x](http://dx.doi.org/doi:10.1111/j.1600-0870.2006.00216.x)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Anderson, J. L.**, 2007  
     Exploring the need for localization in ensemble data assimilation using
     a hierarchical ensemble filter.  
     *Physica D*, **230**, 99-111,
     [doi:10.1016/j.physd.2006.02.011](http://dx.doi.org/doi:10.1016/j.physd.2006.02.011)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Anderson, J. and N. Collins**, 2007  
     Scalable Implementations of Ensemble Filter Algorithms for Data Assimilation.  
     *Journal of Atmospheric and Oceanic Technology*, **24**, 1452-1463,
     [doi:10.1175/JTECH2049.1](http://dx.doi.org/doi:10.1175/JTECH2049.1)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Arellano, A. F., K. Raeder,
   J. L. Anderson, P. Hess, L. K. Emmons, D. P. Edwards, G. G. Pfister,
   T. L. Campos and G. W. Sachse**: 2007  
     Evaluating model performance of an ensemble-based chemical data assimilation
     system during INTEX-B field mission,  
     *Atmos. Chem. Phys.*, **7**, 5695-5710,
     [doi:10.5194/acp-7-5695-2007](http://dx.doi.org/doi:10.5194/acp-7-5695-2007)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Arellano, A. F., P. Hess,
   D. Edwards, J. L. Anderson, K. Raeder, L. K. Emmons, G. G. Pfister,
   T. L. Campos, G. Diskin, J. Jimenez and R. Subramanian**, 2007  
     Chemical Data Assimilation of MOPITT CO and MODIS AOD Retrievals
     in the Community Atmosphere Model.  
     *Eos. Trans. AGU*, **88(52)**, Fall Meet. Suppl., Abstract A14D-03.  


 ![](http://www.image.ucar.edu/images/pin4.gif) **Edwards, D., A. Arellano
   and M. Deeter**, 2007  
     Defining Requirements for Future Satellite Air Quality Chemistry Observations.  
     *Eos. Trans. AGU*, **88(52)**, Fall Meet. Suppl., Abstract A54C-01.


 ![](http://www.image.ucar.edu/images/pin4.gif) **Lawson, W. G., M. I. Richardson,
   D. J. McCleese, J. T. Schofield, O. Aharonson, S. B. Calcutt, P. G. J. Irwin,
   D. M. Kass, C. B. Leovy, S.R. Lewis, D. A. Paige, P. L. Read, F. W. Taylor
   and R. W. Zurek**, 2007  
     Adapting State of the Art Data Assimilation Approaches for Use with the
     Mars Climate Sounder and the PlanetWRF Martian GCM.  
     Seventh International Conference on Mars, Pasadena, Californa,  
     LPI Contribution No. 1353, p 3321.


 ![](http://www.image.ucar.edu/images/pin4.gif) **Lawson, W. G., M. I. Richardson,
   D. J. McCleese, J. L. Anderson, Y. Chen and C. Snyder**, 2007  
     Ensemble-Based Data Assimilation with a Martian GCM  
     *Eos Trans. AGU*, 88(52), Fall Meeting Suppl., Abstract P11A-0251.


 ![](http://www.image.ucar.edu/images/pin4.gif) **Hacker, J. P., J. L. Anderson
   and M. Pagowski**, 2007  
     Improved vertical covariance estimates for ensemble filter assimilation
     of near-surface observations.  
     *Monthly Weather Review*, **135**, 1021-1036,
     [doi:10.1175/MWR3333.1](http://dx.doi.org/DOI:10.1175/MWR3333.1)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Hacker, J. P.
   and D. Rostkier-Edelstein**, 2007  
     PBL state estimation with surface observations, a column model, and an ensemble filter.  
     *Monthly Weather Review*, **135**, Issue 8, 2958-2972,
     [doi:10.1175/MWR3443.1](http://dx.doi.org/doi:10.1175/MWR3443.1)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Karspeck, A. and J. L. Anderson**, 2007  
     Experimental implementation of an ensemble adjustment filter
     for an intermediate ENSO model.  
     *Journal of Climate*, **20** 4638-4658,
     [doi:10.1175/JCLI4245.1](http://dx.doi.org/DOI:10.1175/JCLI4245.1)


----
## 2006
----

 ![](http://www.image.ucar.edu/images/pin4.gif) **Aksoy, A., F. Zhang
   and J. W. Nielsen-Gammon**, 2006  
     Ensemble-based simultaneous state and parameter estimation with MM5.  
     *Geophysical Research Letters*, **33**, L12801


 ![](http://www.image.ucar.edu/images/pin4.gif) **Aksoy, A., F. Zhang
   and J. W. Nielsen-Gammon**, 2006  
     Ensemble-based simultaneous state and parameter estimation in a
     two-dimensional sea breeze model.  
     *Monthly Weather Review*, **134**, 2951-2970,
     [doi:10.1175/MWR3224.1](http://dx.doi.org/DOI:10.1175/MWR3224.1)


 ![](http://www.image.ucar.edu/images/pin4.gif) **Chen, Y. and C. Snyder**, 2006  
     Assimilation of hurricane position with an ensemble Kalman Filter.  
     *Geophysical Research Abstracts*, **8**, 09910


 ![](http://www.image.ucar.edu/images/pin4.gif) **D. Rostkier-Edelstein, J. Hacker
   and M. Pagowski**, 2006  
     Estimates of boundary layer profiles by means of ensemble-filter
     assimilation of near surface observations in a parameterized PBL.  
     *Proceedings of the 17th Symposium on Boundary Layers and Turbulence*
     AMS, San Diego, 16-22 May 2006.

 ![](http://www.image.ucar.edu/images/pin4.gif) **W. G. Lawson, M. I. Richardson,
   D. J. McCleese, J. T. Schofield, O. Aharonson, S. B. Calcutt, P. G. J. Irwin,
   D. M. Kass, C. B. Leovy, S.R. Lewis, D. A. Paige, P. L. Read, F. W. Taylor
   and R. W. Zurek** 2006  
   Data Assimilation With the Mars Climate Sounder  
    *2006 Fall AGU Meeting*, abstract P23B-0061

 ![](http://www.image.ucar.edu/images/pin4.gif) **J. Hacker, M. Pagowski
   and D. Rostkier-Edelstein**, 2006  
    Parameter estimation in land-surface model using atmospheric data
    assimilation: finding distributions for use in an ensemble prediction system.  
    *Proceedings of the 17th Symposium on Boundary Layers and Turbulence*,
    AMS, San Diego, 16-22 May 2006.

---
## 2005
---

 ![](http://www.image.ucar.edu/images/pin4.gif) **Anderson, J. L., B. Wyman,
   S. Zhang and T. Hoar**, 2005  
    Assimilation of surface pressure observations using an ensemble
    filter in an idealized global atmospheric prediction system.  
     *Journal of the Atmospheric Sciences*, **62**, 2925-2938,
     [doi:10.1175/JAS3510.1](http://dx.doi.org/DOI:10.1175/JAS3510.1)


----
## BD ... Before DART
----

 ![](http://www.image.ucar.edu/images/pin4.gif) **Zhang, F., C. Snyder and J. Sun**, 2004  
     Impacts of initial estimate and observation availability on
     convective-scale data assimilation with an ensemble Kalman filter.  
     *Monthly Weather Review*, **132**, 1238-1253.

 ![](http://www.image.ucar.edu/images/pin4.gif) **Bengtsson, T., C. Snyder
   and D. Nychka**, 2003  
     A nonlinear filter that extends to high dimensional systems.  
     *Journal of Geophysical Research-Atmosphere*, **108**, 1-10

 ![](http://www.image.ucar.edu/images/pin4.gif) **Tribbia, J. J. and D. P. Baumhefner**, 2004  
     Scale interactions and atmospheric predictablility: An updated perspective.  
     *Monthly Weather Review*, **132**, 703-713.

 ![](http://www.image.ucar.edu/images/pin4.gif) **Anderson, J. L.**, 2003  
     A local least squares framework for ensemble filtering.  
     *Monthly Weather Review*, **131**, 634-642,
     [doi:10.1175/1520-0493(2003)131&lt;0634:ALLSFF&gt;2.0.CO;2](http://dx.doi.org/10.1175/1520-0493(2003)131%3C0634%3AALLSFF%3E2.0.CO%3B2)

 ![](http://www.image.ucar.edu/images/pin4.gif) **Tippett, M. K., J. L. Anderson,  
     C. H. Bishop, T. M. Hamill and J. S. Whitaker**, 2003  
     Ensemble square root filters.  
     *Monthly Weather Review*, **131**, 1485-1490.

 ![](http://www.image.ucar.edu/images/pin4.gif) **Zhang, S. and J. L. Anderson**, 2003  
     Impact of spatially and temporally varying estimates of error  
     covariance on assimilation in a simple atmospheric model.  
     *Tellus*, **55A**, 126-147.

 ![](http://www.image.ucar.edu/images/pin4.gif) **Snyder, C. and F. Zhang**, 2003  
     Assimilation of simulated Doppler radar observations with an ensemble Kalman filter  
     *Monthly Weather Review*, **131**, 1663-16776.

 ![](http://www.image.ucar.edu/images/pin4.gif) **Anderson, J. L.**, 2001  
     An Ensemble Adjustment Kalman Filter for Data Assimilation.  
     *Monthly Weather Review*, **129**, 2884-2903,
     [doi:10.1175/1520-0493(2001)129&lt;2884:AEAKFF&gt;2.0.CO;2](http://dx.doi.org/10.1175/1520-0493(2001)129%3C2884%3AAEAKFF%3E2.0.CO%3B2)

----

