      FUNCTION IDN30(ADN30,L30)

C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C
C SUBPROGRAM:    IDN30
C   PRGMMR: WOOLLEN          ORG: NP20       DATE: 1994-01-06
C
C ABSTRACT: THIS FUNCTION CONVERTS A DESCRIPTOR FROM ITS FIVE OR SIX
C   CHARACTER ASCII REPRESENTATION TO ITS BIT-WISE (INTEGER)
C   REPRESENTATION.
C
C PROGRAM HISTORY LOG:
C 1994-01-06  J. WOOLLEN -- ORIGINAL AUTHOR
C 1998-07-08  J. WOOLLEN -- REPLACED CALL TO CRAY LIBRARY ROUTINE
C                           "ABORT" WITH CALL TO NEW INTERNAL BUFRLIB
C                           ROUTINE "BORT"
C 2003-11-04  S. BENDER  -- ADDED REMARKS/BUFRLIB ROUTINE
C                           INTERDEPENDENCIES
C 2003-11-04  D. KEYSER  -- UNIFIED/PORTABLE FOR WRF; ADDED
C                           DOCUMENTATION (INCLUDING HISTORY); OUTPUTS
C                           MORE COMPLETE DIAGNOSTIC INFO WHEN ROUTINE
C                           TERMINATES ABNORMALLY
C DART $Id$
C
C USAGE:    IDN30 (ADN30, L30)
C   INPUT ARGUMENT LIST:
C     ADN30    - CHARACTER*(*): CHARACTER FORM OF DESCRIPTOR (FXY
C                VALUE)
C     L30      - INTEGER: LENGTH OF ADN30 (NUMBER OF CHARACTERS, 5 OR
C                6)
C
C   OUTPUT ARGUMENT LIST:
C     IDN      - INTEGER: BIT-WISE REPRESENTATION OF DESCRIPTOR (FXY)
C                VALUE
C
C REMARKS:
C    THIS ROUTINE CALLS:        ADN30    BORT     IFXY
C    THIS ROUTINE IS CALLED BY: RDBFDX
C                               Normally not called by any application
C                               programs.
C
C ATTRIBUTES:
C   LANGUAGE: FORTRAN 77
C   MACHINE:  PORTABLE TO ALL PLATFORMS
C
C$$$

      COMMON /HRDWRD/ NBYTW,NBITW,NREV,IORD(8)

      CHARACTER*(*) ADN30
      CHARACTER*128 BORT_STR

C----------------------------------------------------------------------
C----------------------------------------------------------------------

      IF(LEN(ADN30).LT.L30) GOTO 900
      IF(L30.EQ.5) THEN
         READ(ADN30,'(I5)') IDN30
         IF(IDN30.LT.0 .OR. IDN30.GT.65535) GOTO 901
      ELSEIF(L30.EQ.6) THEN
         IDN30 = IFXY(ADN30)
      ELSE
         GOTO 902
      ENDIF

C  EXITS
C  -----

      RETURN
900   WRITE(BORT_STR,'("BUFRLIB: IDN30 - FUNCTION INPUT STRING ",A,'//
     . '" CHARACTER LENGTH (",I4,") IS TOO SHORT (< L30,",I5)')
     . ADN30,LEN(ADN30),L30
      CALL BORT(BORT_STR)
901   WRITE(BORT_STR,'("BUFRLIB: IDN30 - DESCRIPTOR INTEGER '//
     . 'REPRESENTATION, IDN30 (",I8,"), IS OUTSIDE 16-BIT RANGE '//
     . '(0-65535)")') IDN30
      CALL BORT(BORT_STR)
902   WRITE(BORT_STR,'("BUFRLIB: IDN30 - FUNCTION INPUT STRING ",A,'//
     . '" CHARACTER LENGTH (",I4,") MUST BE EITHER 5 OR 6")')
     . ADN30,L30
      CALL BORT(BORT_STR)
      END
