	FUNCTION ISTDESC( IDN )

C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C
C SUBPROGRAM:    ISTDESC
C   PRGMMR: ATOR             ORG: NP12       DATE: 2004-08-18
C
C ABSTRACT:  GIVEN THE BIT-WISE REPRESENTATION OF THE FXY VALUE
C   FOR A DESCRIPTOR, THIS FUNCTION DETERMINES WHETHER THE DESCRIPTOR
C   IS A WMO-STANDARD DESCRIPTOR OR A LOCAL DESCRIPTOR.
C
C PROGRAM HISTORY LOG:
C 2004-08-18  J. ATOR    -- ORIGINAL AUTHOR
C DART $Id$
C
C USAGE:    ISTDESC( IDN )
C   INPUT ARGUMENT LIST:
C     IDN      - INTEGER: BIT-WISE REPRESENTATION OF FXY VALUE
C		 FOR DESCRIPTOR TO BE CHECKED
C
C   OUTPUT ARGUMENT LIST:
C     ISTDESC  - INTEGER: RETURN VALUE:
C		   0 - IDN IS A LOCAL DESCRIPTOR
C		   1 - IDN IS A WMO-STANDARD DESCRIPTOR
C
C REMARKS:
C    THIS ROUTINE CALLS:        ADN30
C    THIS ROUTINE IS CALLED BY: CMSGINI  RESTD       STNDRD
C                               Normally not called by application
C                               programs but it could be.
C
C ATTRIBUTES:
C   LANGUAGE: FORTRAN 77
C   MACHINE:  PORTABLE TO ALL PLATFORMS
C
C$$$

	CHARACTER*6	ADSC, ADN30

	ADSC = ADN30( IDN, 6 )

	READ(ADSC,'(I1,I2,I3)') IF,IX,IY
	IF  ( ( IF .EQ. 1 ) .OR. ( IF .EQ. 2 ) )  THEN

C	    ADSC IS EITHER A REPLICATOR OR TABLE C OPERATOR DESCRIPTOR.
C	    SINCE LOCAL VERSIONS OF SUCH DESCRIPTORS ARE NOT ALLOWED,
C	    THEN ADSC IS STANDARD BY DEFAULT.

	    ISTDESC = 1
	ELSE IF  ( ( IX .LT. 48 ) .AND. ( IY .LT. 192 ) )  THEN
	    ISTDESC = 1
	ELSE
	    ISTDESC = 0
	END IF

	RETURN
	END
