      SUBROUTINE PKVS1(IL,IV)

C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C
C SUBPROGRAM:    PKVS1
C   PRGMMR: ATOR            ORG: NP12       DATE: 2004-08-18
C
C ABSTRACT: THIS SUBROUTINE IS USED TO SPECIFY A VALUE IV TO BE WRITTEN
C   INTO BYTE IL OF SECTION 1 (OR INTO BYTE 8 OF SECTION 0, IF IL = 0)
C   FOR ALL BUFR MESSAGES THAT WILL BE OUTPUT BY FUTURE CALLS TO ANY
C   OF THE BUFR ARCHIVE LIBRARY SUBROUTINES WHICH CREATE SUCH MESSAGES
C   (E.G. WRITCP, WRITSB, COPYMG, WRITSA, WRITCA, ETC.). THIS SUBROUTINE  
C   CAN BE CALLED AT ANY TIME, INCLUDING BEFORE THE FIRST CALL TO BUFR
C   ARCHIVE LIBRARY SUBROUTINE OPENBF IF IT IS DESIRED FOR THE NEW VALUE
C   TO ALSO BE INCLUDED IN ANY DX DICTIONARY TABLE MESSAGES THAT WILL BE
C   OUTPUT BY BUFR ARCHIVE LIBRARY SUBROUTINE WRITDX.  IF MULTIPLE
C   VALUES ARE DESIRED TO BE CHANGED IN SECTION 1 (OR 0) OF FUTURE
C   OUTPUT MESSAGES, THEN EACH SUCH VALUE (AND CORRESPONDING LOCATION)
C   SHOULD BE SPECIFIED USING A SEPARATE CALL TO THIS SUBROUTINE.
C   IN ANY CASE, EACH CALL TO THIS SUBROUTINE WITH A PARTICULAR IL VALUE
C   OVERRIDES ANY PREVIOUS CALL(S) WITH THAT SAME IL VALUE (OR, IN THE
C   CASE OF THE FIRST CALL WITH A PARTICULAR IL VALUE, IT OVERRIDES THE
C   DEFAULT VALUE FOR THE CORRESPONDING BYTE LOCATION!).  NOTE THAT THIS
C   SUBROUTINE IS CONSIDERED OBSOLETE AND MAY BE REMOVED FROM THE BUFR
C   ARCHIVE LIBRARY IN A FUTURE VERSION; USERS SHOULD INSTEAD MIGRATE TO
C   THE USE OF BUFR ARCHIVE LIBRARY SUBROUTINE PKVS01.
C
C PROGRAM HISTORY LOG:
C 2004-08-18  J. ATOR    -- ORIGINAL AUTHOR
C 2005-11-29  J. ATOR    -- ADDED SPECIAL IL=-99 INITIALIZATION OPTION
C			    FOR INTERNAL USE WITHIN BUFRLIB; MARKED AS
C                           OBSOLETE AND ADDED PRINT NOTIFICATION
C DART $Id$
C
C USAGE:    CALL PKVS1(IL,IV)
C   INPUT ARGUMENT LIST:
C     IL       - INTEGER: BYTE TO OVERWRITE WITHIN SECTION 1 OF ALL
C                FUTURE OUTPUT BUFR MESSAGES:
C                       0 = OVERWRITE BYTE 8 OF SECTION 0
C		      -99 = SPECIAL FLAG TO FORCE INITIALIZATION OF
C			    NCOD=0 WITHIN COMMON /SECT01/; IN THIS
C			    CASE THE INPUT VALUE IV IS IGNORED
C			    (NOTE: AN APPLICATION PROGRAM SHOULD NEVER
C			    ITSELF NEED TO DO THIS!)
C     IV       - INTEGER: NEW VALUE FOR BYTE POINTED TO BY IL
C
C REMARKS:
C    THIS ROUTINE CALLS:        BORT
C    THIS ROUTINE IS CALLED BY: BFRINI
C                               Also called by application programs.
C
C ATTRIBUTES:
C   LANGUAGE: FORTRAN 77
C   MACHINE:  PORTABLE TO ALL PLATFORMS
C
C$$$

      PARAMETER (MXCOD=15)

      COMMON /SECT01/ NCOD,ILCOD(MXCOD),IVCOD(MXCOD)

      COMMON /QUIET / IPRT

      CHARACTER*128 BORT_STR

      DATA IFIRST/0/

      SAVE IFIRST

C-----------------------------------------------------------------------
C-----------------------------------------------------------------------

      IF(IFIRST.EQ.0) THEN

C	NOTE THAT WE ARE INITIALIZING NCOD=0 HERE (RATHER THAN WITHIN
C	SUBROUTINE BFRINI) IN ORDER TO ALLOW FOR THE POSSIBILITY THAT A
C	USER MAY CALL SUBROUTINE PKVS1 PRIOR TO CALLING SUBROUTINE
C	OPENBF (WHICH ITSELF CALLS BFRINI!).  HOWEVER, IF THE USER DOES
C	NOT DO THIS, THEN THE "CALL PKVS1(-99,-99)" STATEMENT WITHIN
C	BFRINI WILL ENSURE THAT THE REQUIRED INITIALIZATION OF NCOD=0
C	STILL GETS DONE; OTHERWISE, WE WOULD RUN THE RISK OF NCOD BEING
C	UNINITIALIZED WHEN REFERENCED LATER ON WITHIN SUBROUTINE MSGWRT!

        NCOD = 0
        IFIRST = 1

         IF( (IPRT.GE.0) .AND. (IL.NE.-99) ) THEN
      PRINT*
      PRINT*,'+++++++++++++++++BUFR ARCHIVE LIBRARY++++++++++++++++++++'
      PRINT 101
101   FORMAT(' BUFRLIB: PKVS1 - THIS SUBROUTINE IS NOW OBSOLETE; ',
     . 'USE SUBROUTINE PKVS01 INSTEAD')
      PRINT*,'+++++++++++++++++BUFR ARCHIVE LIBRARY++++++++++++++++++++'
      PRINT*
         ENDIF

      ENDIF

      IF (IL.EQ.-99) THEN
        RETURN
      ENDIF

C     IF AN IV HAS ALREADY BEEN ASSIGNED FOR THIS PARTICULAR IL, THEN
C     OVERWRITE THAT ENTRY IN COMMON /SECT01/ USING THE NEW IV VALUE.

      IF(NCOD.GT.0) THEN
        DO I=1,NCOD
          IF(IL.EQ.ILCOD(I)) THEN
            IVCOD(I) = IV
            RETURN
          ENDIF
        ENDDO
      ENDIF

C     OTHERWISE, USE THE NEXT AVAILABLE UNUSED ENTRY IN COMMON /SECT01/.

      IF(NCOD.GE.MXCOD) GOTO 900

      NCOD = NCOD + 1
      ILCOD(NCOD) = IL
      IVCOD(NCOD) = IV      

C  EXITS
C  -----

      RETURN
900   WRITE(BORT_STR,'("BUFRLIB: PKVS1 - CANNOT OVERWRITE MORE THAN '//
     . '",I2," DIFFERENT BYTES WITHIN SECTION 1")') MXCOD
      CALL BORT(BORT_STR)
      END
