      SUBROUTINE SUBUPD(LUNIT,LUN,IBYT)

C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C
C SUBPROGRAM:    SUBUPD
C   PRGMMR: WOOLLEN          ORG: NP20       DATE: 2003-11-04
C
C ABSTRACT: THIS SUBROUTINE PACKS UP THE CURRENT SUBSET WITHIN MEMORY
C  (ARRAY IBAY IN COMMON BLOCK /BITBUF/) AND THEN TRIES TO ADD IT TO
C  THE BUFR MESSAGE THAT IS CURRENTLY OPEN WITHIN MEMORY FOR LUNIT
C  (ARRAY MBAY IN COMMON BlOCK /BITBUF/).  IF THE SUBSET WILL NOT FIT
C  INTO THE CURRENTLY OPEN MESSAGE, THEN THAT MESSAGE IS FLUSHED TO
C  LUNIT AND A NEW ONE IS CREATED IN ORDER TO HOLD THE CURRENT SUBSET.
C  IF THE SUBSET IS LARGER THAN AN EMPTY MESSAGE, THE SUBSET IS
C  DISCARDED ANDA DIAGNOSTIC IS PRINTED.  THIS SUBROUTINE IS IDENTICAL
C  TO BUFR ARCHIVE LIBRARY SUBROUTINE MSGUPD EXCEPT SUBUPD DOES NOT PAD
C  THE PACKED SUBSET.
C
C PROGRAM HISTORY LOG:
C 2003-11-04  J. WOOLLEN -- ORIGINAL AUTHOR (WAS IN VERIFICATION
C                           VERSION)
C 2003-11-04  D. KEYSER  -- UNIFIED/PORTABLE FOR WRF; ADDED
C                           DOCUMENTATION
C 2004-08-09  J. ATOR    -- MAXIMUM MESSAGE LENGTH INCREASED FROM
C                           20,000 TO 50,000 BYTES
C DART $Id$
C
C USAGE:    CALL SUBUPD (LUNIT, LUN, IBYT)
C   INPUT ARGUMENT LIST:
C     LUNIT    - INTEGER: FORTRAN LOGICAL UNIT NUMBER FOR BUFR FILE
C     LUN      - INTEGER: I/O STREAM INDEX INTO INTERNAL MEMORY ARRAYS
C                (ASSOCIATED WITH FILE CONNECTED TO LOGICAL UNIT LUNIT)
C     IBYT     - INTEGER: NUMBER OF BYTES WITHIN IBAY CONTAINING PACKED
C                DATA
C
C   OUTPUT FILES:
C     UNIT 06  - STANDARD OUTPUT PRINT
C
C REMARKS:
C    THIS ROUTINE CALLS:        IUPB     MSGINI   MSGWRT   MVB
C                               PKB      USRTPL
C    THIS ROUTINE IS CALLED BY: None
C                               Perhaps a verification application
C                               program calls it (if not, remove it?)
C
C ATTRIBUTES:
C   LANGUAGE: FORTRAN 77
C   MACHINE:  PORTABLE TO ALL PLATFORMS
C
C$$$

      INCLUDE 'bufrlib.prm'

      COMMON /MSGPTR/ NBY0,NBY1,NBY2,NBY3,NBY4,NBY5
      COMMON /MSGCWD/ NMSG(NFILES),NSUB(NFILES),MSUB(NFILES),
     .                INODE(NFILES),IDATE(NFILES)
      COMMON /BITBUF/ MAXBYT,IBIT,IBAY(MXMSGLD4),MBYT(NFILES),
     .                MBAY(MXMSGLD4,NFILES)
      COMMON /QUIET / IPRT

C-----------------------------------------------------------------------
C-----------------------------------------------------------------------

C  SEE IF THE NEW SUBSET FITS
C  --------------------------

      IF(MBYT(LUN)+IBYT+8.GT.MAXBYT) THEN
c  .... NO it does not fit
         CALL MSGWRT(LUNIT,MBAY(1,LUN),MBYT(LUN))
         CALL MSGINI(LUN)
      ENDIF

      IF(MBYT(LUN)+IBYT+8.GT.MAXBYT) GOTO 900

C  SET A BYTE COUNT AND TRANSFER THE SUBSET BUFFER INTO THE MESSAGE
C  ----------------------------------------------------------------

      LBIT = 0
      CALL PKB(IBYT,16,IBAY,LBIT)
c  .... DK: Why the -3 in "MBYT(LUN)-3" ??
      CALL MVB(IBAY,1,MBAY(1,LUN),MBYT(LUN)-3,IBYT)

C  UPDATE THE SUBSET AND BYTE COUNTERS
C  --------------------------------------

      MBYT(LUN)   = MBYT(LUN)   + IBYT
      NSUB(LUN)   = NSUB(LUN)   + 1

      LBIT = (NBY0+NBY1+NBY2+4)*8
      CALL PKB(NSUB(LUN),16,MBAY(1,LUN),LBIT)

      LBYT = NBY0+NBY1+NBY2+NBY3
      NBYT = IUPB(MBAY(1,LUN),LBYT+1,24)
      LBIT = LBYT*8
      CALL PKB(NBYT+IBYT,24,MBAY(1,LUN),LBIT)

C  RESET THE USER ARRAYS AND EXIT NORMALLY
C  ---------------------------------------

      CALL USRTPL(LUN,1,1)
      GOTO 100

C  ON ENCOUTERING OVERLARGE SUBSETS, EXIT GRACEFULLY (SUBSET DISCARDED)
C  --------------------------------------------------------------------

900   IF(IPRT.GE.0) THEN
      PRINT*
      PRINT*,'+++++++++++++++++++++++WARNING+++++++++++++++++++++++++'
      PRINT*,'BUFRLIB: SUBUPD - SUBSET LONGER THAN ANY POSSIBLE ',
     . 'MESSAGE {SUBSET LENGTH= ',MBYT(LUN)+IBYT+8,', MESSAGE LENGTH= ',
     . MAXBYT,'}'
      PRINT*,'>>>>>>>OVERLARGE SUBSET DISCARDED FROM FILE<<<<<<<<'
      PRINT*,'+++++++++++++++++++++++WARNING+++++++++++++++++++++++++'
      PRINT*
      ENDIF

C  EXIT
C  ----

100   RETURN
      END
