###########################################################################
#!make
#
#!Makefile Name: SnglResSubsetter.mk
#
#!Description: Makefile for Subsetting L2 data sets from granules.
#
#!Variables:
#
#       Internal
#        Macros           Definition
#       ~~~~~~~~          ~~~~~~~~~~
#       COMPILE.F90       FORTRAN 90 compiler and options
#       ADD_F90FLAGS      Process specific FORTRAN 90 compiler options
#       INC               Accumlated include file search path
#       LIB               Accumulated library search path
#       OBJ               Accumulated set of object files
#       PATH_SRC          Directory path to L3 atmosphere shared source
#       TARGET            Executable file name
#
#!Env Variables
#
#         System
#       Environment
#        Variables    Definition
#       ~~~~~~~~~~~   ~~~~~~~~~~
#       F90           FORTRAN 90 compiler definition
#       F90FLAGS      FORTRAN 90 compiler options
#       API_INC       Directory path to M-API include files
#       HDFINC        Directory path to HDF include files
#       HDFLIB        Directory path to HDF library
#       PGSINC        Directory path to SDPTK include files
#       PGSLIB        Directory path to SDPTK library
#
#!Team-Unique Header:
#   Cloud Retrieval Group, NASA Goddard Space Flight Center
#
#!Revision History:
# 10/18/99  Moody, Eric Updated for Subsetting code.
# 03/26/98  Liqun Ma   Updated
#
#!Note:
#       1) Libraries must be entered in the sequential order: MAPI, SDPTK,
#          HDF, others
#       2) HDFLIB must be explicit and in order of -lmfhdf, -ldf, -ljpeg, -lz.
#       3) Environment variables must be defined before executing this
#          makefile.  This is done through running the shell script.
#       4) Only the path of the source code (PATH_SRC) should be altered.
#
#!END
###########################################################################

# Define Library references
LIB = -L$(HDFLIB) -lmfhdf -ldf -lz


# Define Include Files
INC = -I$(HDFINC) 

# Define compiler options
ADD_F90FLAGS = -ansi -r10000 -O3 -OPT:Olimit=0
COMPILE.F90 = $(F90) $(F90FLAGS) $(ADD_F90FLAGS) $(INC) -c

# *********************************************************************
# This is the path for the source code, alter it depending on where the
#   source code is located.
PATH_SRC = ./
# *********************************************************************

OBJ    = typeSizes.o\
	 SnglResSubsetterInputs.o\
	 hdf.o\
	 characterUtils.o\
	 hdfUtils.o\
	 dataUtils.o\
	 parse.o\
	 SDSReader.o\
	 SubsetterOutput.o\
	 SnglResSubsetterUtils.o\
	 Subsetter.o\
         SnglResSubsetter.o

TARGET = SnglResSubsetter.exe

$(TARGET): $(OBJ)
	$(F90) $(F90FLAGS) $(ADD_F90FLAGS) $(OBJ) $(LIB) -o $(TARGET)

clean:
	/bin/rm -f *.mod *.o

cleanall:
	/bin/rm -f *.mod *.o $(TARGET)

# Object definitions.  DO NOT ALTER.
typeSizes.o:  $(PATH_SRC)/typeSizes.f90
	$(COMPILE.F90) $?

SnglResSubsetterInputs.o:  $(PATH_SRC)/SnglResSubsetterInputs.f90 typeSizes.o
	$(COMPILE.F90) $?

hdf.o:  $(PATH_SRC)/hdf.f90 typeSizes.o
	$(COMPILE.F90) $?

characterUtils.o:  $(PATH_SRC)/characterUtils.f90 typeSizes.o
	$(COMPILE.F90) $?

parse.o:  $(PATH_SRC)/parse.f90 characterUtils.o typeSizes.o hdf.o
	$(COMPILE.F90) $?

hdfUtils.o:  $(PATH_SRC)/hdfUtils.f90 typeSizes.o hdf.o characterUtils.o
	$(COMPILE.F90) $?

dataUtils.o:  $(PATH_SRC)/dataUtils.f90 typeSizes.o hdf.o
	$(COMPILE.F90) $?

SDSReader.o:  $(PATH_SRC)/SDSReader.f90 typeSizes.o hdf.o
	$(COMPILE.F90) $?

SubsetterOutput.o:  $(PATH_SRC)/SubsetterOutput.f90 typeSizes.o SnglResSubsetterInputs.o hdf.o
	$(COMPILE.F90) $?

SnglResSubsetterUtils.o:  $(PATH_SRC)/SnglResSubsetterUtils.f90 typeSizes.o SnglResSubsetterInputs.o dataUtils.o
	$(COMPILE.F90) $?

Subsetter.o:  $(PATH_SRC)/Subsetter.f90 typeSizes.o hdf.o SDSReader.o SnglResSubsetterUtils.o SubsetterOutput.o
	$(COMPILE.F90) $?

SnglResSubsetter.o: $(PATH_SRC)/SnglResSubsetter.f90 
	$(COMPILE.F90) $?

#********************** END OF MAKEFILE ***************************
