module parse
  !*****************************************************************************
  ! !F90
  !
  ! !Description:
  !    This module contains the parsing routine to parse a value out of a
  !      character string.
  !  
  ! !Callable routines:
  !    parser()
  ! 
  ! !Revision History:
  ! $Log: parse.f90,v $
  ! Revision 1.0  1999/09/02  12:43:43  EGMoody
  ! Initial revision.
  !
  ! !Team-Unique Header:
  !   Cloud Retrieval Group, NASA Goddard Space Flight Center
  !
  ! !References and Credits:
  !   Written by
  !    Eric Moody
  !    Climate and Radiation Branch, Code 913
  !    NASA/GSFC
  !    Greenbelt MD 20771
  !    Eric.Moody@gsfc.nasa.gov
  !
  ! !Design Notes:
  !   This routine is set up to parse out a 8 byte Real value.  If the user requires
  !    another type of variable to be parsed out, this module must be
  !    appropriately altered to do so.
  !
  ! !END
  !*****************************************************************************

  !Dependencies:
  use CharacterUtils, only  : ChartoReal
  use typeSizes,      only  : EightByteRealKind

  implicit none
  private

  public :: parser


contains


  subroutine parser(string, name, value)

    implicit none
    character(len  = *), intent(in)                    :: string
    character(len  = *), intent(in)                    :: name
    real     (kind = EightByteRealKind), intent(out)   :: value
    ! !F90
    !
    ! !Description:
    !    Parses the specified 8 Byte Real variable out of a character string. 
    !  
    ! !Input Parameters:
    !   string : The character string to be parsed.
    !   name   : The name of the variable to be read in.
    !
    ! !Output Parameters:
    !   value: The value of the variable to be read in.
    ! 
    ! !Revision History:
    !    See module revision history in data section of module. 
    !
    ! !Team-Unique Header:
    !   Cloud Retrieval Group, NASA Goddard Space Flight Center
    !
    ! !References and Credits:
    !   Written by
    !    Eric Moody
    !    Climate and Radiation Branch, Code 913
    !    NASA/GSFC
    !    Greenbelt MD 20771
    !    Eric.Moody@gsfc.nasa.gov
    !
    ! !Design Notes:
    !  The parser relies on the structure of the String as follows:
    !       ...NAME...
    !       VALUE = value
    !  Thus the parser first looks for the name, and then for the first
    !   occurance of the word VALUE.  Then it reads in the value
    !   immeadiately after the equal sign and converts the string to a real.
    !
    ! !END

    !local variable
    integer                                            :: i,j,k

    !Parse from 1 to the length of the string minus the len of the name:
    beginparse: do i = 1, len(trim(string)) - len(trim(name))
       !Look for the name:
       if (  string( i : i + len(trim(name)) - 1 )  &
             == trim(name)  )                                 then

          do j = 1, 100
             !Look for the first occurance of the word "VALUE"
             if (  string( i+j : i+j+4 ) == "VALUE"  )        then
                
                do k = 1, 30
                   !Look for the "=" immeadiately after the word "VALUE"
                   if (  string( i+j+k : i+j+k+1 ) == "="  )  then
                      
                      !Read in the string containing the value, and convert
                      ! it to a real value:
                      value = ChartoReal(trim(string(i+j+k+2:i+j+k+15)))
                      exit beginparse
                      
                   end if
                end do
                
             end if
          end do
       
       end if
    end do beginparse
    
    !check to see if a value was found:
    if ( value == -50000.0 )  then                   
       print *,'Could not find the value for ' // trim(name)
       stop
    end if


  end subroutine parser





end module parse
  


