function TimeScatter( ObsTypeInd )
%% TimeScatter( ObsTypeInd ) is a prototype function. Much work to be done. 
%
%	a 2D scatterplot of (typically) the prior mean 
%		observation vs. the original observation. Both of
%		these can be changed however - the allowable set is defined
%		by the CopyMetaData variable in the netCDF file.

%% DART software - Copyright UCAR. This open source software is provided
% by UCAR, "as is", without charge, subject to all terms of use at
% http://www.image.ucar.edu/DAReS/DART/DART_download
%
% DART $Id$

ObsTypes = { 'GPSRO_REFRACTIVITY', ...
             'RADIOSONDE_U_WIND_COMPONENT', ...
             'RADIOSONDE_V_WIND_COMPONENT', ...
             'RADIOSONDE_SURFACE_PRESSURE', ...
             'RADIOSONDE_TEMPERATURE', ...
             'RADIOSONDE_SPECIFIC_HUMIDITY', ...
             'AIRCRAFT_U_WIND_COMPONENT', ...
             'AIRCRAFT_V_WIND_COMPONENT', ...
             'AIRCRAFT_TEMPERATURE', ...
             'ACARS_U_WIND_COMPONENT', ...
             'ACARS_V_WIND_COMPONENT', ...
             'ACARS_TEMPERATURE', ...
             'SAT_U_WIND_COMPONENT', ...
             'SAT_V_WIND_COMPONENT'};

fnames = {'/ptmp/thoar/POP/CAM/POP8/obs_sequence_001.nc', ...
          '/ptmp/thoar/POP/CAM/POP8/obs_sequence_002.nc', ...
          '/ptmp/thoar/POP/CAM/POP8/obs_sequence_003.nc', ...
          '/ptmp/thoar/POP/CAM/POP8/obs_sequence_004.nc', ...
          '/ptmp/thoar/POP/CAM/POP8/obs_sequence_005.nc', ...
          '/ptmp/thoar/POP/CAM/POP8/obs_sequence_006.nc', ...
          '/ptmp/thoar/POP/CAM/POP8/obs_sequence_007.nc', ...
          '/ptmp/thoar/POP/CAM/POP8/obs_sequence_008.nc'};

ObsTypes = { 'GPSRO_REFRACTIVITY', ...
             'RADIOSONDE_U_WIND_COMPONENT', ...
             'RADIOSONDE_V_WIND_COMPONENT', ...
             'RADIOSONDE_SURFACE_PRESSURE', ...
             'RADIOSONDE_TEMPERATURE', ...
             'RADIOSONDE_SPECIFIC_HUMIDITY', ...
             'AIRCRAFT_U_WIND_COMPONENT', ...
             'AIRCRAFT_V_WIND_COMPONENT', ...
             'AIRCRAFT_TEMPERATURE', ...
             'AIRCRAFT_SPECIFIC_HUMIDITY', ...
             'ACARS_U_WIND_COMPONENT', ...
             'ACARS_V_WIND_COMPONENT', ...
             'ACARS_TEMPERATURE', ...
             'ACARS_SPECIFIC_HUMIDITY', ...
             'SAT_U_WIND_COMPONENT', ...
             'SAT_V_WIND_COMPONENT'};

fnames = {'/ptmp/thoar/POP/CAM/AugRunThatWorked/obs_sequence_001.nc', ...
          '/ptmp/thoar/POP/CAM/AugRunThatWorked/obs_sequence_002.nc', ...
          '/ptmp/thoar/POP/CAM/AugRunThatWorked/obs_sequence_003.nc', ...
          '/ptmp/thoar/POP/CAM/AugRunThatWorked/obs_sequence_004.nc', ...
          '/ptmp/thoar/POP/CAM/AugRunThatWorked/obs_sequence_005.nc', ...
          '/ptmp/thoar/POP/CAM/AugRunThatWorked/obs_sequence_006.nc', ...
          '/ptmp/thoar/POP/CAM/AugRunThatWorked/obs_sequence_007.nc', ...
          '/ptmp/thoar/POP/CAM/AugRunThatWorked/obs_sequence_008.nc'};

ObsCopyString = 'NCEP BUFR observation';
CopyString    = 'prior ensemble mean';
QCString      = 'DART quality control';
region        = [220 300 20 60 -Inf Inf];

for i = 1:length(fnames)

   obs  = read_obs_netcdf(fnames{i}, ObsTypes{ObsTypeInd}, region, ObsCopyString, QCString, 0);
   copy = read_obs_netcdf(fnames{i}, ObsTypes{ObsTypeInd}, region,    CopyString, QCString, 0);

   %% replace the ill-posed values with NaN

   assim  = (copy.qc <= 1); nassim = sum(assim);
   away   = (copy.qc == 7);  naway = sum(away);
   good   =   assim | away;  ngood = sum(good);

   x = NaN * ones(size(obs.obs));
   y = NaN * ones(size(obs.obs));
   x(assim) = copy.obs(assim);
   y( away) = copy.obs( away);

   %% create the plot

   clf; hold on;
   s2 = scatter(obs.obs, y); set(s2,'MarkerEdgeColor','r','MarkerFaceColor','r');
   s1 = scatter(obs.obs, x); set(s1,'MarkerEdgeColor','k');
   xlabel(ObsCopyString);
   ylabel(CopyString);
   h = title({ObsTypes{ObsTypeInd}, ...
      sprintf('%s ---> %s',obs.timestring(1,:),obs.timestring(2,:)) });
   set(h,'Interpreter','none');

   xmin   = min(axis);
   xmax   = max(axis);
   axlims = [xmin xmax xmin xmax];
   axis(axlims);
   plot([xmin xmax],[xmin xmax],'k-'); hold off;
   grid

   %% annotate how many were kept vs. rejected

   lh = legend([s1 s2],'QC 0,1','QC 7'); set(lh,'Location','SouthEast')

   str0 = sprintf('total# %d',length(x));
   str1 = sprintf('QC 0,1 == %d',nassim);
   str2 = sprintf('QC   7 == %d',naway);
   str3 = sprintf('QC 2-6 == %d',length(x) - nassim - naway);

   tx  = xmin + 0.25*(xmax-xmin);
   ty0 = xmax - 0.05*(xmax-xmin);
   ty1 = xmax - 0.10*(xmax-xmin);
   ty2 = xmax - 0.15*(xmax-xmin);
   ty3 = xmax - 0.20*(xmax-xmin);

   h0 = text( tx, ty0, str0); set(h0,'HorizontalAlignment','right')
   h1 = text( tx, ty1, str1); set(h1,'HorizontalAlignment','right')
   h2 = text( tx, ty2, str2); set(h2,'HorizontalAlignment','right')
   h3 = text( tx, ty3, str3); set(h3,'HorizontalAlignment','right')

   print(gcf,'-dpsc','-append',ObsTypes{ObsTypeInd})

end

% <next few lines under version control, do not edit>
% $URL$
% $Revision$
% $Date$
