! DART software - Copyright UCAR. This open source software is provided
! by UCAR, "as is", without charge, subject to all terms of use at
! http://www.image.ucar.edu/DAReS/DART/DART_download
!
! $Id$

!----------------------------------------------------------------------
! WARNING!!  The file obs_def_mod.f90 is AUTOGENERATED by the
! 'preprocess' program.  Any changes made to this file will be
! overwritten when it is regenerated.  To make permanent changes
! in the code, edit DEFAULT_obs_def_mod.F90, or edit the 
! observation specific obs_def_xxx_mod.f90 files.
!----------------------------------------------------------------------

!----------------------------------------------------------------------
!----------------------------------------------------------------------
! Any observation-specific modules which contain executable code to
! handle the interpolation and/or reading and writing of the obs will
! have the module code inserted here.  Then models only have to use
! the obs_def_mod module, and only include obs_def_mod.f90 in their
! path_names files.  To change the observation types/kinds, edit the
! model-specific 'input.nml' file and add or remove lines from the
! &preprocess_nml section, the 'input_files' list.
!
! Start of any user-defined executable module code
!----------------------------------------------------------------------

! DART PREPROCESS MODULE CODE INSERTED HERE

!----------------------------------------------------------------------
! End of any user-defined executable module code
!----------------------------------------------------------------------
!----------------------------------------------------------------------

!----------------------------------------------------------------------
!----------------------------------------------------------------------


!----------------------------------------------------------------------
!----------------------------------------------------------------------
! Start of main obs_def_mod module code
!----------------------------------------------------------------------


module obs_def_mod

! Contains the basic parts of a module for defining and evaluating observation
! definitions. Can evaluate identity observations as is. The DART preprocess
! program is used to add in extra observation kinds at the indicated spots in
! the code.

use        types_mod,      only : r8, i8, missing_i, missing_r8, obstypelength
use    utilities_mod,      only : register_module, error_handler, E_ERR, E_MSG, &
                                  ascii_file_format
use     location_mod,      only : location_type, read_location, write_location, &
                             interactive_location, set_location_missing, &
                             operator(/=) 
use time_manager_mod, only : time_type, read_time, write_time, operator(/=), &
                             set_time_missing, interactive_time, set_time, print_time
use  assim_model_mod,      only : get_state_meta_data, interpolate
use     obs_kind_mod,      only : assimilate_this_type_of_obs, evaluate_this_type_of_obs, &
                                  get_name_for_type_of_obs, map_type_of_obs_table, &
                             get_type_of_obs_from_menu, use_ext_prior_this_type_of_obs
use ensemble_manager_mod,  only : ensemble_type
use obs_def_utilities_mod, only : track_status, set_debug_fwd_op

!----------------------------------------------------------------------
! This list is autogenerated by the 'preprocess' program.  To add types
! or kinds, edit the obs_def_xxx_mod.f90 files, and then add/remove them
! from the 'input_files' variable of the &preprocess_nml namelist
! in the model-specific work/input.nml file.
!
! Start of obs_def_xxx_mod specific types and kinds
!----------------------------------------------------------------------

! DART PREPROCESS USE FOR OBS_QTY_MOD INSERTED HERE

!----------------------------------------------------------------------
! End of obs_def_xxx_mod specific types and kinds
!----------------------------------------------------------------------

!----------------------------------------------------------------------
! This section is autogenerated by the 'preprocess' program. 
!
! Start of any obs_def_xxx_mod specific use statements
!----------------------------------------------------------------------

! If any observation types required specialized code, the module code
! will have been added above, and now a use statement will be generated
! here so the generic obs_def_mod has access to the code.

! DART PREPROCESS USE OF SPECIAL OBS_DEF MODULE INSERTED HERE

!----------------------------------------------------------------------
! End of any obs_def_xxx_mod specific use statements
!----------------------------------------------------------------------


implicit none
private

interface assignment(=)
   module procedure copy_obs_def
end interface

interface operator(==)
   module procedure eq_obs_def
end interface

interface operator(/=)
   module procedure ne_obs_def
end interface

public :: init_obs_def, get_obs_def_key, get_obs_def_location, get_obs_def_type_of_obs, &
   get_obs_def_time, get_obs_def_error_variance, set_obs_def_location, &
   set_obs_def_type_of_obs, set_obs_def_time, set_obs_def_error_variance, &
   set_obs_def_key, interactive_obs_def, write_obs_def, read_obs_def, &
   obs_def_type, get_expected_obs_from_def_distrib_state, destroy_obs_def, copy_obs_def, &
   assignment(=), set_obs_def_external_FO, set_obs_def_write_external_FO, &
   eq_obs_def, ne_obs_def, operator(==), operator(/=), print_obs_def

! version controlled file description for error handling, do not edit
character(len=256), parameter :: source   = &
   "$URL$"
character(len=32 ), parameter :: revision = "$Revision$"
character(len=128), parameter :: revdate  = "$Date$"

! FIXME: should write_external_FO be some kind of global instead of
! being per-obs?

type obs_def_type
! In revision, obs_kind module is responsible for taking care of 
! identity obs kinds, too
   private
   type(location_type)   :: location   ! center of mass, so to speak
   integer               :: kind       ! actually type
   type(time_type)       :: time
   real(r8)              :: error_variance
   integer               :: key        ! Used by specialized observation types
   logical               :: write_external_FO = .false.
   logical               :: has_external_FO   = .false.
   real(r8), allocatable :: external_FO(:)
   integer               :: external_FO_key
   integer               :: ens_size
end type obs_def_type

logical, save :: module_initialized = .false.

! define a fixed integer code that specifies whether a record 
! in a binary obs_sequence file is a precomputed FO rather than a time_type
integer, parameter :: external_prior_code = -123

contains

!----------------------------------------------------------------------------

subroutine initialize_module

call register_module(source, revision, revdate)
module_initialized = .true.

! Note that there is no namelist for this module now that 
! obs_kind has been revised

end subroutine initialize_module


!----------------------------------------------------------------------------

subroutine init_obs_def(obs_def, location, kind, time, error_variance)
! Need to add additional component arguments as optionals as needed

! Constructor for an obs_def

type(obs_def_type), intent(out) :: obs_def
type(location_type), intent(in) :: location
integer,             intent(in) :: kind
type(time_type),     intent(in) :: time
real(r8),            intent(in) :: error_variance

if ( .not. module_initialized ) call initialize_module

obs_def%location = location
obs_def%kind = kind
obs_def%time = time
obs_def%error_variance = error_variance
! No key assigned for standard observation defs
obs_def%key = -1

end subroutine init_obs_def

!---------------------------------------------------------------------

subroutine copy_obs_def(obs_def1, obs_def2)

! Copy function to be overloaded with '='

type(obs_def_type), intent(out) :: obs_def1
type(obs_def_type), intent(in) :: obs_def2

if ( .not. module_initialized ) call initialize_module

obs_def1%location       = obs_def2%location
obs_def1%kind           = obs_def2%kind
obs_def1%time           = obs_def2%time
obs_def1%error_variance = obs_def2%error_variance
obs_def1%key            = obs_def2%key
!deallocate(obs_def1%platform_qc)
!allocate(obs_def1%platform_qc(size(obs_def2%platform_qc))
! Should this be pointer assignment or regular
!obs_def1%platform_qc >= or == obs_def2%platform_qc
!obs_def1%aperture = obs_def2%aperture

obs_def1%has_external_FO = obs_def2%has_external_FO
if ( obs_def1%has_external_FO ) then
   call set_obs_def_external_FO(obs_def1, obs_def1%has_external_FO, obs_def2%write_external_FO,  &
                                obs_def2%external_FO_key, obs_def2%ens_size, obs_def2%external_FO)
endif

end subroutine copy_obs_def

!---------------------------------------------------------------------

subroutine print_obs_def(obs_def)

type(obs_def_type), intent(in) :: obs_def

character(len=256) :: string

if ( .not. module_initialized ) call initialize_module

call write_location(0, obs_def%location, charstring=string)
call error_handler(E_MSG, '', 'location: '//trim(string))

write(string, *) obs_def%kind, ', ', trim(get_name_for_type_of_obs(obs_def%kind))
call error_handler(E_MSG, '', 'type: '//trim(string))

call print_time(obs_def%time, ' time: ')

write(string, *) obs_def%error_variance
call error_handler(E_MSG, '', 'error variance: '//trim(string))

write(string, *) obs_def%key
call error_handler(E_MSG, '', 'private key: '//trim(string))

end subroutine print_obs_def

!---------------------------------------------------------------------

function eq_obs_def(obs_def1, obs_def2)

! Compare function to be overloaded with '=='

type(obs_def_type), intent(in) :: obs_def1
type(obs_def_type), intent(in) :: obs_def2
logical :: eq_obs_def

if ( .not. module_initialized ) call initialize_module

eq_obs_def = .false.

if (obs_def1%location       /= obs_def2%location) return
if (obs_def1%kind           /= obs_def2%kind) return
if (obs_def1%time           /= obs_def2%time) return
if (obs_def1%error_variance /= obs_def2%error_variance) return

! FIXME: should this be tested as well?  it could be different
! for identical obs - it's the key target that needs testing
! and that's type dependent.  for now, avoid testing it.
!if (obs_def1%key            /= obs_def2%key) return

eq_obs_def = .true.

end function eq_obs_def

!----------------------------------------------------------------------------

function ne_obs_def(obs_def1, obs_def2)

! Compare function to be overloaded with '/='

type(obs_def_type), intent(in) :: obs_def1
type(obs_def_type), intent(in) :: obs_def2
logical :: ne_obs_def

ne_obs_def = .not. eq_obs_def(obs_def1, obs_def2)

end function ne_obs_def

!----------------------------------------------------------------------------

function get_obs_def_key(obs_def)

type(obs_def_type), intent(in) :: obs_def
integer                        :: get_obs_def_key

if ( .not. module_initialized ) call initialize_module

get_obs_def_key = obs_def%key

end function get_obs_def_key

!----------------------------------------------------------------------------

function get_obs_def_error_variance(obs_def)

type(obs_def_type), intent(in) :: obs_def
real(r8)                       :: get_obs_def_error_variance

if ( .not. module_initialized ) call initialize_module

get_obs_def_error_variance = obs_def%error_variance

end function get_obs_def_error_variance

!----------------------------------------------------------------------------

function get_obs_def_location(obs_def)

! Returns observation location.

type(location_type)            :: get_obs_def_location
type(obs_def_type), intent(in) :: obs_def

if ( .not. module_initialized ) call initialize_module

get_obs_def_location = obs_def%location

end function get_obs_def_location

!----------------------------------------------------------------------------

function get_obs_def_type_of_obs(obs_def)

! Returns observation kind

integer                        :: get_obs_def_type_of_obs
type(obs_def_type), intent(in) :: obs_def

if ( .not. module_initialized ) call initialize_module

get_obs_def_type_of_obs = obs_def%kind

end function get_obs_def_type_of_obs

!----------------------------------------------------------------------------

function get_obs_def_time(obs_def)

! Returns observation time

type(time_type)                :: get_obs_def_time
type(obs_def_type), intent(in) :: obs_def

if ( .not. module_initialized ) call initialize_module

get_obs_def_time = obs_def%time

end function get_obs_def_time

!----------------------------------------------------------------------------

subroutine set_obs_def_location(obs_def, location)

! Sets the location of an obs_def

type(obs_def_type), intent(inout) :: obs_def
type(location_type),   intent(in) :: location

if ( .not. module_initialized ) call initialize_module

obs_def%location = location

end subroutine set_obs_def_location

!----------------------------------------------------------------------------

subroutine set_obs_def_error_variance(obs_def, error_variance)

! Sets the error variance of an obs_def

type(obs_def_type), intent(inout) :: obs_def
real(r8), intent(in) :: error_variance

if ( .not. module_initialized ) call initialize_module

obs_def%error_variance = error_variance

end subroutine set_obs_def_error_variance

!----------------------------------------------------------------------------

subroutine set_obs_def_key(obs_def, key)

! Sets the key of an obs_def

type(obs_def_type), intent(inout) :: obs_def
integer,            intent(in)    :: key

if ( .not. module_initialized ) call initialize_module

obs_def%key = key

end subroutine set_obs_def_key

!----------------------------------------------------------------------------

subroutine set_obs_def_external_FO(obs_def, has_external_FO, write_external_FO, external_FO_key, &
                                    ens_size, external_FO_values)

! Sets whether an obs_def has an external prior associated with it

type(obs_def_type), intent(inout) :: obs_def
logical,            intent(in)    :: has_external_FO
logical,            intent(in)    :: write_external_FO
integer,            intent(in)    :: external_FO_key, ens_size
real(r8),           intent(in)    :: external_FO_values(ens_size)

if ( .not. module_initialized ) call initialize_module

if ( .not. allocated(obs_def%external_FO)) allocate(obs_def%external_FO(ens_size))

obs_def%has_external_FO   = has_external_FO
obs_def%write_external_FO = write_external_FO
obs_def%external_FO_key   = external_FO_key
obs_def%ens_size          = ens_size
obs_def%external_FO(1:ens_size)  = external_FO_values(1:ens_size)

end subroutine set_obs_def_external_FO 

!----------------------------------------------------------------------------

subroutine set_obs_def_write_external_FO(obs_def, write_external_FO)

! Sets whether to write out the external FO values or not.
! Should be true for programs which create these obs in the first place,
! should also be true for programs like the obs_sequence_tool.  Should be
! false for filter.

type(obs_def_type), intent(inout) :: obs_def
logical,            intent(in)    :: write_external_FO

if ( .not. module_initialized ) call initialize_module

obs_def%write_external_FO = write_external_FO

end subroutine set_obs_def_write_external_FO 

!----------------------------------------------------------------------------

subroutine set_obs_def_type_of_obs(obs_def, kind)

! Sets the kind of an obs_def

type(obs_def_type), intent(inout) :: obs_def
integer,               intent(in) :: kind

if ( .not. module_initialized ) call initialize_module

obs_def%kind = kind

end subroutine set_obs_def_type_of_obs

!----------------------------------------------------------------------------

subroutine set_obs_def_time(obs_def, time)

! Sets the time of an obs_def

type(obs_def_type), intent(inout) :: obs_def
type(time_type), intent(in) :: time

if ( .not. module_initialized ) call initialize_module

obs_def%time = time

end subroutine set_obs_def_time

!----------------------------------------------------------------------------

subroutine get_expected_obs_from_def_distrib_state(state_handle, ens_size, copy_indices, key, obs_def, obs_kind_ind, &
   state_time, isprior, assimilate_this_ob, evaluate_this_ob, expected_obs, istatus)

! Compute forward operator for a particular obs_def
type(ensemble_type), intent(in)  :: state_handle
integer,             intent(in)  :: ens_size
integer,             intent(in)  :: copy_indices(ens_size)
integer,             intent(in)  :: key
type(obs_def_type),  intent(in)  :: obs_def
integer,             intent(in)  :: obs_kind_ind
type(time_type),     intent(in)  :: state_time
logical,             intent(in)  :: isprior
integer,             intent(out) :: istatus(ens_size)
logical,             intent(out) :: assimilate_this_ob, evaluate_this_ob
real(r8),            intent(out) :: expected_obs(ens_size)


type(location_type) :: location
type(time_type)     :: obs_time
integer             :: obs_key
real(r8)            :: error_var
logical             :: use_precomputed_FO

! Load up the assimilate and evaluate status for this observation kind
assimilate_this_ob = assimilate_this_type_of_obs(obs_kind_ind)
evaluate_this_ob = evaluate_this_type_of_obs(obs_kind_ind)
use_precomputed_FO = use_ext_prior_this_type_of_obs(obs_kind_ind)

! If not being assimilated or evaluated return with missing_r8 and istatus 0
if(assimilate_this_ob .or. evaluate_this_ob) then
   ! for speed, access directly instead of using accessor functions
   location  = obs_def%location
   obs_time  = obs_def%time
   obs_key   = obs_def%key
   error_var = obs_def%error_variance

   ! the decision process here is that if some external source computed
   ! the prior forward operator values then we can use them or not, but
   ! if we use them there is no way to compute a consistent posterior.
   ! so the posteriors are always marked as 'failed forward operator'.
   if (use_precomputed_FO) then 
      if (isprior) then
         if ( obs_def%has_external_FO ) then
            expected_obs(:) = obs_def%external_FO(:) 
            istatus = 0 
         else 
            call error_handler(E_ERR, 'get_expected_obs_from_def', &
                  'Attempt to access an external FO that is not present in the observation information.', &
                   source, revision, revdate, text2='observation type '//trim(get_name_for_type_of_obs(obs_def%kind)))
         endif 
      else ! posterior - missing value
         expected_obs(:) = missing_r8
         istatus = 1 
      endif
   else 
      ! Compute the forward operator.  In spite of the variable name,
      ! obs_kind_ind is in fact a 'type' index number.  use the function
      ! get_quantity_for_type_of_obs from the obs_kind_mod if you want to map
      ! from a specific type to a generic kind.  the third argument of
      ! a call to the 'interpolate()' function must be a kind index and
      ! not a type.  normally the preprocess program does this for you.
      select case(obs_kind_ind)
   
         ! arguments available to an obs_def forward operator code are:
         !   state_handle -- to access the state vector
         !   ens_size     -- the number of ensemble members to do at once (between 1 and ens_size)
         !   copy_indices -- the indicies the ensemble members (between 1 and ens_size)
         !   location     -- observation location
         !   obs_kind_ind -- the index of the observation specific type 
         !   obs_time     -- the time of the observation
         !   error_var    -- the observation error variance
         !   isprior      -- true for prior eval; false for posterior
         !
         ! the routine must return values for:
         !   expected_obs -- the computed forward operator values for all ensemble members
         !   istatus -- return code: 0=ok, >0 is error, <0 reserved for system use
         !
         ! to call interpolate() directly, the arg list MUST BE:
         !  interpolate(state_handle, ens_size, location, QTY_xxx, expected_obs, istatus)
         !
         ! the preprocess program generates lines like this automatically,
         ! and this matches the interfaces in each model_mod.f90 file.
         !
         ! CASE statements and algorithms for specific observation kinds are
         ! inserted here by the DART preprocess program.
   
         ! DART PREPROCESS GET_EXPECTED_OBS_FROM_DEF INSERTED HERE
   
         ! If the observation kind is not available, it is an error. The DART 
         ! preprocess program should provide code for all available kinds.
         case DEFAULT
            call error_handler(E_ERR, 'get_expected_obs_from_def', &
               'Attempt to evaluate or assimilate undefined obs_kind type.', &
                source, revision, revdate)
      end select
   endif 
else
   ! Not computing forward operator for this kind
   expected_obs(:) = missing_r8
   istatus = 0
endif

end subroutine get_expected_obs_from_def_distrib_state



  subroutine read_obs_def(ifile, obs_def, key, obs_val, fform)
!----------------------------------------------------------------------------
! subroutine read_obs_def(ifile, obs_def, key, obs_val, fform)
!
! ifile
! obs_def
! key
! obs_val    needed if you want to perform operations based on value 
! fform
!
! Reads an obs_def from file which is just an integer unit number in the
! current preliminary implementation.

integer,                    intent(in)    :: ifile
type(obs_def_type),         intent(inout) :: obs_def
integer,                    intent(in)    :: key
real(r8),                   intent(inout) :: obs_val
character(len=*), optional, intent(in)    :: fform

character(len=5)  :: header
integer           :: o_index
logical           :: is_ascii
character(len=32) :: fileformat   ! here for backwards compatibility only
character(len=256) :: errstring
character(len=11) :: header_external_FO 
integer           :: ii, secs,days 
character(len=128) :: string 
logical           :: time_set
integer, save     :: counter = 0

if ( .not. module_initialized ) call initialize_module

is_ascii = ascii_file_format(fform)

! here for backwards compatibility only; after the next release,
! remove this and force people in their own obs_def_xxx_mod.f90 code
! to set the last arg to read/write to be fform instead of fileformat
if (is_ascii) then
   fileformat = 'formatted'
else
   fileformat = 'unformatted'
endif

! Begin by reading five character ascii header, then location, kind, error variance, index

! Need to add additional error checks on read
if (is_ascii) then
   read(ifile, '(a5)') header
   if(header /= 'obdef') then
      write(errstring, *) 'read "//header//" instead'
      call error_handler(E_ERR,'read_obs_def', &
         'Expected header "obdef" in input file', &
          source, revision, revdate, text2=errstring)
   endif
endif

! Read the location, kind, time and error variance
obs_def%location = read_location(ifile, fform)
if (is_ascii) then
   read(ifile, '(a5)' ) header
   if(header /= 'kind ') then
      write(errstring, *) 'read "//header//" instead'
      call error_handler(E_ERR,'read_kind', &
         'Expected kind header "kind " in input file', &
          source, revision, revdate, text2=errstring)
   endif
   read(ifile, *) o_index
else
   read(ifile)    o_index
endif

! Negative value is identity obs, doesn't need mapped
! Positive value must use mapping to get to proper index in obs_kind
if(o_index < 0) then
   obs_def%kind = o_index
else
   obs_def%kind = map_type_of_obs_table(o_index)
endif

! This kind may have its own module that needs to read more
select case(obs_def%kind)
   ! More complicated kinds may require reading additional information from 
   ! an observation sequence file. Case code to do this is inserted here by 
   ! the DART preprocess program.

! DART PREPROCESS READ_OBS_DEF INSERTED HERE

! A negative value means identity observations, just move along
   case (:-1)
      continue

   case DEFAULT
      write(errstring, *) 'unknown type number was ', obs_def%kind
      call error_handler(E_ERR, 'read_obs_def', &
         'Attempt to read for undefined obs_kind type.', &
         source, revision, revdate, text2=errstring)
end select

! We need to see whether there is external prior metadata.
! If so, we need to read it in, but that doesn't necessarily mean
! the precomputed FO will acutally be used for that particular obs_type
time_set = .false.
obs_def%write_external_FO = .false.  ! Always false when actually running DART
if (is_ascii) then
   read(ifile,fmt='(a)') string
   if (string(1:11) /= 'external_FO') then 
      ! no metadata, we really just read the time.
      backspace(ifile) ! go back to previous line to prepare to read time
      obs_def%has_external_FO = .false.
   else ! we have a precomputed FO
      read(string, *) header_external_FO, obs_def%ens_size, obs_def%external_FO_key
      ! FIXME: remove this if * works ok
      !read(string, FMT='(a11, 2i8)') header_external_FO, obs_def%ens_size, obs_def%external_FO_key
      if ( .not. allocated(obs_def%external_FO)) allocate(obs_def%external_FO(obs_def%ens_size))
      read(ifile, *) (obs_def%external_FO(ii), ii=1,obs_def%ens_size)
      obs_def%has_external_FO = .true.
   endif
else
   read(ifile) secs, days
   if ( days /= external_prior_code ) then
      ! no metadata, we really just read the time
      ! can't use backspace on a binary file.
      obs_def%time = set_time(secs, days)
      time_set = .true.
      obs_def%has_external_FO = .false.
   else ! we have a precomputed FO
      counter = counter + 1
      obs_def%ens_size = secs
      obs_def%external_FO_key = counter
      if ( .not. allocated(obs_def%external_FO)) allocate(obs_def%external_FO(obs_def%ens_size))
      read(ifile)    (obs_def%external_FO(ii), ii=1,obs_def%ens_size)
      obs_def%has_external_FO = .true.
   endif
endif

! Read the time for the observation
if ( .not. time_set ) obs_def%time = read_time(ifile, fform) 

if (is_ascii) then
   read(ifile, *) obs_def%error_variance
else
   read(ifile)    obs_def%error_variance
endif

end subroutine read_obs_def

!----------------------------------------------------------------------------

subroutine write_obs_def(ifile, obs_def, key, fform)

! Writes an obs_def to file.

integer,                    intent(in) :: ifile
type(obs_def_type),         intent(in) :: obs_def
integer,                    intent(in) :: key
character(len=*), intent(in), optional :: fform

logical           :: is_ascii
character(len=32) :: fileformat   ! here for backwards compatibility only

integer            :: ii ! CSS

if ( .not. module_initialized ) call initialize_module

is_ascii = ascii_file_format(fform)

! here for backwards compatibility only; after the next release,
! remove this and force people in their own obs_def_xxx_mod.f90 code
! to set the last arg to read/write to be fform instead of fileformat
if (is_ascii) then
   fileformat = 'formatted'
else
   fileformat = 'unformatted'
endif

! Write the 5 character identifier for verbose formatted output
if (is_ascii) write(ifile, '("obdef")')

! Write out the location, kind and error variance
call write_location(ifile, obs_def%location, fform)
if (is_ascii) then
   write(ifile, '("kind")' )
   write(ifile, *) obs_def%kind
else
   write(ifile)    obs_def%kind
endif

! This kind may have its own module that needs to write more
select case(obs_def%kind)
   ! More complicated kinds may require writing additional information from 
   ! an observation sequence file. Case code to do this is inserted here by 
   ! the DART preprocess program.

   ! DART PREPROCESS WRITE_OBS_DEF INSERTED HERE

   ! A negative value means identity observations, just move along
   case (:-1)
      continue

   case DEFAULT
      call error_handler(E_ERR, 'write_obs_def', &
         'Attempt to write for undefined obs_kind type.', &
         source, revision, revdate)
end select

! obs_def%write_external_FO should only be true for program 
! actually WRITING the external data.  When running DART
! obs_def%write_external_FO should be false and no metadata will be written
! Also want obs_def%write_external_FO to somehow be true when this called from
! the obs_sequence_tool program
if ( obs_def%has_external_FO .and. obs_def%write_external_FO ) then 
   if ( .not. allocated(obs_def%external_FO)) then
      call error_handler(E_ERR, 'write_obs_def', &
         'obs_def%external_FO not allocated but writing was requested.', &
         source, revision, revdate, text2='observation type '//trim(get_name_for_type_of_obs(obs_def%kind)))
   endif
   if (is_ascii) then
      write(ifile, 12) obs_def%ens_size, obs_def%external_FO_key
      write(ifile, *) (obs_def%external_FO(ii), ii=1,obs_def%ens_size)
   else
      write(ifile)    obs_def%ens_size, external_prior_code
      write(ifile)    (obs_def%external_FO(ii), ii=1,obs_def%ens_size)
   endif
12  format('external_FO', 2i8)
endif

call write_time(ifile, obs_def%time, fform)

if (is_ascii) then
   write(ifile, *) obs_def%error_variance
else
   write(ifile)    obs_def%error_variance
endif

end subroutine write_obs_def


subroutine interactive_obs_def(obs_def, key)
!---------------------------------------------------------------------------
!
! Allows interactive creation of an observation

type(obs_def_type), intent(inout) :: obs_def
integer,               intent(in) :: key

if ( .not. module_initialized ) call initialize_module

! Get the observation kind WANT A STRING OPTION, TOO?
obs_def%kind = get_type_of_obs_from_menu()

! Input any special stuff for this kind
select case(obs_def%kind)
   ! More complicated kinds may require inputting additional information to 
   ! define an observation. Case code to do this is inserted here by the 
   ! DART preprocess program.

   ! DART PREPROCESS INTERACTIVE_OBS_DEF INSERTED HERE

   ! A negative value means identity observations, just move along
   case (:-1)
      continue
   case DEFAULT
      call error_handler(E_ERR, 'interactive_obs_def', &
         'Attempt to interactively create undefined obs_kind type.', &
         source, revision, revdate)
end select

! If the kind is an identity observation, don't need to call location
! Get location from state meta_data
if(obs_def%kind < 0) then
   ! Get the location of this from model
   call get_state_meta_data(-1_i8 * obs_def%kind, obs_def%location)
else! Get the location
   call interactive_location(obs_def%location)
endif

! Get the time
call interactive_time(obs_def%time)

write(*, *) 'Input the error variance for this observation definition '
read(*, *) obs_def%error_variance
do while (obs_def%error_variance < 0) 
   write(*, *) 'The error variance must be positive, please try again'
   read(*, *) obs_def%error_variance
enddo

end subroutine interactive_obs_def

!----------------------------------------------------------------

subroutine destroy_obs_def(obs_def)
! TECHNICALLY NEED TO CALL DESTRUCTORS FOR ALL SUBCOMPONENTS, 
! NO ALLOCATED STORAGE YET

type(obs_def_type), intent(inout) :: obs_def

if ( .not. module_initialized ) call initialize_module

! FIXME: not clear why we have to set all these to missing...
! we definitely have to do the deallocate but the others seem
! like unnecessary work.

call set_obs_def_location(obs_def, set_location_missing() )
obs_def%kind = missing_i
call set_obs_def_time(obs_def, set_time_missing() )
call set_obs_def_error_variance( obs_def, missing_r8) 
call set_obs_def_external_FO(obs_def, .false., .false., missing_i, 1, (/missing_r8/))
if ( allocated(obs_def%external_FO)) deallocate(obs_def%external_FO) ! CSS

end subroutine destroy_obs_def



!---------------------------------------------------------------------------
!---------------------------------------------------------------------------

end module obs_def_mod

! <next few lines under version control, do not edit>
! $URL$
! $Id$
! $Revision$
! $Date$
