      LOGICAL FUNCTION DIGIT(STR)

C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C
C SUBPROGRAM:    DIGIT
C   PRGMMR: WOOLLEN          ORG: NP20       DATE: 1994-01-06
C
C ABSTRACT: THIS LOGICAL FUNCTION TESTS THE CHARACTERS IN A STRING TO
C   DETERMINE IF THEY ARE ALL DIGITS ('0','1','2','3','4','5','6','7',
C   '8' or '9').
C
C PROGRAM HISTORY LOG:
C 1994-01-06  J. WOOLLEN -- ORIGINAL AUTHOR
C 2003-11-04  S. BENDER  -- ADDED REMARKS/BUFRLIB ROUTINE
C                           INTERDEPENDENCIES
C 2003-11-04  D. KEYSER  -- UNIFIED/PORTABLE FOR WRF; ADDED
C                           DOCUMENTATION (INCLUDING HISTORY)
C DART $Id$
C
C USAGE:    DIGIT (STR)
C   INPUT ARGUMENT LIST:
C     STR      - CHARACTER*(*): STRING
C
C   OUTPUT ARGUMENT LIST:
C     DIGIT    - LOGICAL: TRUE IF ALL CHARACTERS IN STR ARE DIGITS
C                ('0' - '9'), OTHERWISE FALSE
C
C REMARKS:
C    THIS ROUTINE CALLS:        None
C    THIS ROUTINE IS CALLED BY: CKTABA   NUMBCK   RDBFDX   RDUSDX
C                               Normally not called by any application
C                               programs but it could be.
C
C ATTRIBUTES:
C   LANGUAGE: FORTRAN 77
C   MACHINE:  PORTABLE TO ALL PLATFORMS
C
C$$$

      CHARACTER*(*) STR
      DIGIT = .FALSE.
      DO I=1,LEN(STR)
      IF(STR(I:I).NE.'0' .AND. STR(I:I).NE.'1' .AND.
     .   STR(I:I).NE.'2' .AND. STR(I:I).NE.'3' .AND.
     .   STR(I:I).NE.'4' .AND. STR(I:I).NE.'5' .AND.
     .   STR(I:I).NE.'6' .AND. STR(I:I).NE.'7' .AND.
     .   STR(I:I).NE.'8' .AND. STR(I:I).NE.'9') GOTO 100
      ENDDO
      DIGIT = .TRUE.

C  EXIT
C  ----

100   RETURN
      END
