      REAL*8 FUNCTION PKFTBV(NBITS,IBIT)

C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C
C SUBPROGRAM:    PKFTBV
C   PRGMMR: JATOR            ORG: NP12       DATE: 2005-11-29
C
C ABSTRACT:  THIS FUNCTION COMPUTES AND RETURNS THE VALUE EQUIVALENT
C   TO THE SETTING OF BIT# IBIT WITHIN A FLAG TABLE OF NBITS BITS.
C   IF THE COMPUTATION FAILS FOR ANY REASON, THEN THE VALUE BMISS
C   (10E10) IS RETURNED.  NOTE THAT THIS SUBROUTINE IS THE LOGICAL
C   INVERSE OF BUFRLIB SUBROUTINE UPFTBV.
C
C PROGRAM HISTORY LOG:
C 2005-11-29  J. ATOR    -- ORIGINAL VERSION
C DART $Id$
C
C USAGE:    PKFTBV (NBITS,IBIT)
C   INPUT ARGUMENT LIST:
C     NBITS    - INTEGER: NUMBER OF BITS IN FLAG TABLE
C     IBIT     - INTEGER: NUMBER OF BIT TO BE SET WITHIN FLAG TABLE
C
C   OUTPUT ARGUMENT LIST:
C     PKFTBV   - REAL*8: VALUE EQUIVALENT TO THE SETTING OF BIT# IBIT
C                WITHIN A FLAG TABLE OF NBITS BITS.
C
C REMARKS:
C    THIS ROUTINE CALLS:        None
C    THIS ROUTINE IS CALLED BY: None
C                               Normally called only by application
C                               programs.
C
C ATTRIBUTES:
C   LANGUAGE: FORTRAN 77
C   MACHINE:  PORTABLE TO ALL PLATFORMS
C
C$$$

      REAL*8  BMISS

      DATA BMISS /10E10/

C----------------------------------------------------------------------
C----------------------------------------------------------------------

      IF((NBITS.LE.0).OR.(IBIT.LE.0).OR.(IBIT.GT.NBITS)) THEN
          PKFTBV = BMISS
      ELSE
          PKFTBV = (2.)**(NBITS-IBIT)
      ENDIF

      RETURN
      END
