---
title: Dart Tutorial
layout: default
---

# DART Tutorial

The DART Tutorial is intended to aid in the understanding of ensemble
data assimilation theory and consists of step-by-step concepts and
companion exercises with DART. The diagnostics in the tutorial use
Matlab®. To configure your environment to use Matlab and the
DART diagnostics, see the 
[Configuring Matlab® for netCDF & DART](Getting_Starting.md#matlab))
section of the **Getting_Started** document.


|            |              |
| ---------- | ------------ |
| Section 1  | [Filtering For a One Variable System](../tutorial/section_01.pdf ) |
| Section 2  | [The DART Directory Tree](../tutorial/section_02.pdf) |
| Section 3  | [DART Runtime Control and Documentation](../tutorial/section_03.pdf) |
| Section 4  | [How should observations of a state variable impact an unobserved state variable? Multivariate assimilation.](../tutorial/section_04.pdf) |
| Section 5  | [Comprehensive Filtering Theory: Non-Identity Observations and the Joint Phase Space](../tutorial/section_05.pdf) |
| Section 6  | [Other Updates for An Observed Variable](../tutorial/section_06.pdf) |
| Section 7  | [Some Additional Low-Order Models](../tutorial/section_07.pdf) |
| Section 8  | [Dealing with Sampling Error](../tutorial/section_08.pdf) |
| Section 9  | [More on Dealing with Error; Inflation](../tutorial/section_09.pdf) |
| Section 10 | [Regression and Nonlinear Effects](../tutorial/section_10.pdf) |
| Section 11 | [Creating DART Executables](../tutorial/section_11.pdf) |
| Section 12 | [Adaptive Inflation](../tutorial/section_12.pdf) |
| Section 13 | [Hierarchical Group Filters and Localization](../tutorial/section_13.pdf) |
| Section 14 | [Observation Quality Control](../tutorial/section_14.pdf) |
| Section 15 | [DART Experiments: Control and Design](../tutorial/section_15.pdf) |
| Section 16 | [Diagnostic Output](../tutorial/section_16.pdf) |
| Section 17 | [Creating Observation Sequences](../tutorial/section_17.pdf) |
| Section 18 | [Lost in Phase Space: The Challenge of Not Knowing the Truth](../tutorial/section_18.pdf) |
| Section 19 | [DART-Compliant Models and Making Models Compliant: Coming Soon](../tutorial/section_19.pdf) |
| Section 20 | [Model Parameter Estimation](../tutorial/section_20.pdf) |
| Section 21 | [Observation Types and Observing System Design](../tutorial/section_21.pdf) |
| Section 22 | [Parallel Algorithm Implementation: Coming Soon](../tutorial/section_22.pdf) |
| Section 23 | [Location Module Design](../tutorial/section_23.pdf) |
| Section 24 | Fixed Lag Ensemble Kalman Smoother (not available yet) |
| Section 25 | [A Simple 1D Advection Model: Tracer Data Assimilation](../tutorial/section_25.pdf) |

-----
