function [ts, LonSatS, LatSatS, AltSatS, RhoSatS, RhoSatUS ...
    LonSatG, LatSatG, AltSatG, RhoSatG, RhoSatUG ] = ...
    dat2mat(y2, d1, tg, directory, dat_file)

% [ts, LonSatS, LatSatS, AltSatS, RhoSatS, RhoSatUS,  LonSatG, LatSatG, AltSatG, RhoSatG, RhoSatUG ] = dat2mat(y2, d1, tg, directory, dat_file)
% GITM-DAT-file-reader (do not confuse text .DAT files with binary .SAT files)
% This function assumes that what you are giving it is a dat file generated
% for GITM by herot.engin.umich.edu/bigdisk1/bin/makerun_wr.pl
%
% IE what it really assumes that there are a few first lines which are text
% ending with #START tag and the following lines are 10 columns with time,
% place, value in them [ yy mo dd hh mm ss ms lon(d) lat(d) alt(km)
% rho(kg/m3) rhounc(kg/m3) ]. Note, alt comes in in km, but I return it in
% meters, as per convention in plots_for_paper.m
%
% INPUTS:
%
% y2 - year modulo 2000 (ie for 2002 put y2=2)
%
% d1 - day the assimilation was began (ie for Dec 1 2002 put d1=335)
%
% tg - Time Gitm - time at which you have truth (or middle) data in minutes
%  since start of assimilation 
%
% directory - where can I find the champ.dat file generated by herot?
%
% dat_file - what file do you want to read (usually champ.dat or grace.dat)
%
%
% OUTPUTS:
%
% ts - Time Satellite (time instances at which satellite data is provided
%  by the satellite people). In minutes since start of assimilation
%  (negative if older data exists and spans (hopefully) beyond where you
%  stopped assimilating)
%
% LonSatS - longitude of satellite at times ts
%
% RhoSatS - Mass density at LonSatS, LatSatS, AltSatS locations and at times ts
%
% RhoSatUS - uncertainty in RhoSatS
%
% LonSatG - LonSatS interpolated in time from ts to tg
%
% RhoSatG - RhoSatS interpolated in time from ts to tg
%
% RhoSatUG - RhoSatUS interpolated in time from ts to tg
 %ASSUMES PROGRADE ORBIT!!!!! see line 72

% DART $Id$
% CREDIT: Alexey Morozov

p=pwd; %save current path
cd(directory) %go to where the pbs_file for this run is

[~,r]=unix(['grep -n ''\#START'' ' dat_file ' | awk -F: ''{print $1}'' ']); %number of text lines to skip

try
    ld=importdata(dat_file,' ',str2double(r)); %load the whole file
catch
    error(['Did you specify the correct directory for ' dat_file '? ' 10 'I cannot find ' dat_file ' in ' directory '.'])
end
ld=ld.data; %import data returns both the data and the text, but we want only the data

ts = (datenum(ld(:,1),ld(:,2),ld(:,3),ld(:,4),ld(:,5),ld(:,6))... %convert time in the file into number of days since year "0000"
    -datenum(2000+y2,0,d1))... %make the start of assimilation be the "00:00:00" time (the start of time keeping for this experiment)
    *24*60; %convert it into minutes (since start of experiment)

LonSatS=ld(:,8);
LatSatS=ld(:,9);
AltSatS=ld(:,10)*1000;
RhoSatS=ld(:,11);
RhoSatUS=ld(:,12);

LonSatG=interp1np(ts,LonSatS,tg); %ASSUMES PROGRADE ORBIT!!!!!
LatSatG=interp1(ts,LatSatS,tg);
AltSatG=interp1(ts,AltSatS,tg);
RhoSatG=interp1(ts,RhoSatS,tg);
RhoSatUG=interp1(ts,RhoSatUS,tg);

cd(p) %come back to where we were before calling this function

% <next few lines under version control, do not edit>
% $URL$
% $Revision$
% $Date$
