      FUNCTION LJUST(STR)

C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C
C SUBPROGRAM:    LJUST
C   PRGMMR: WOOLLEN          ORG: NP20       DATE: 1998-07-08
C
C ABSTRACT: THIS FUNCTION REMOVES ALL LEADING BLANKS FROM A CHARACTER
C   STRING (LEFT JUSTIFIES).  THE RESULTANT STRING MAY CONTAIN ANY
C   VALID ASCII CHARACTER.  IT IS SIMILAR TO BUFR ARCHIVE LIBRARY
C   SUBROUTINE JSTCHR, EXCEPT JSTCHR CALLS BUFR ARCHIVE LIBRARY
C   SUBROUTINE BORT IF THE INPUT CHARACTER STRING IS ALL BLANKS WHILE
C   LJUST RETURNS THE ORIGINAL BLANK STRING IN STR IN THIS CASE.
C
C PROGRAM HISTORY LOG:
C 1998-07-08  J. WOOLLEN -- ORIGINAL AUTHOR
C 2003-11-04  S. BENDER  -- ADDED REMARKS/BUFRLIB ROUTINE
C                           INTERDEPENDENCIES
C 2003-11-04  D. KEYSER  -- UNIFIED/PORTABLE FOR WRF; ADDED
C                           DOCUMENTATION (INCLUDING HISTORY)
C DART $Id$
C
C USAGE:    LJUST (STR)
C   INPUT ARGUMENT LIST:
C     STR      - CHARACTER*(*): STRING TO BE LEFT-JUSTIFED
C
C   OUTPUT ARGUMENT LIST:
C     STR      - CHARACTER*(*): LEFT-JUSTIFED STRING (UNLESS INPUT
C                VALUE CONTAINED ALL BLANKS - THEN INPUT VALUE IS
C                RETURNED WITH NO CHANGES)
C     LJUST    - INTEGER: ALWAYS RETURNED AS 0 (DUMMY)
C
C REMARKS:
C    THIS ROUTINE CALLS:        None
C    THIS ROUTINE IS CALLED BY: None at this time
C                               Normally not called by any application
C                               Programs but it could be.
C
C ATTRIBUTES:
C   LANGUAGE: FORTRAN 77
C   MACHINE:  PORTABLE TO ALL PLATFORMS
C
C$$$

      CHARACTER*(*) STR

      LJUST = 0

      IF(STR.EQ.' ') GOTO 100

      LSTR = LEN(STR)
      DO I=1,LSTR
      DO WHILE(STR(I:I).EQ.' ' .AND. STR(I+1:LSTR).NE.' ')
         STR(I:LSTR) = STR(I+1:LSTR)
      ENDDO
      ENDDO

C  EXIT
C  ----

100   RETURN
      END
