      SUBROUTINE OVRBS1(NVAL,MBAY,NBYT)

C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C
C SUBPROGRAM:    OVRBS1
C   PRGMMR: KEYSER           ORG: NP22       DATE: 2003-11-04
C
C ABSTRACT: THIS SUBROUTINE PACKS AND STORES THE VALUE OF THE BINARY
C   INTEGER WORD NVAL INTO BYTE NBYT OF SECTION 1 (OR INTO BYTE 8 OF
C   SECTION 0, IF NBYT = 0) OF A BUFR MESSAGE STORED IN ARRAY MBAY,
C   OVERWRITING THE VALUE PREVIOUSLY STORED THERE.  THE START OF THE
C   BUFR MESSAGE (I.E. THE STRING "BUFR") MUST BE ALIGNED ON THE FIRST
C   FOUR BYTES OF MBAY.  NOTE THAT THIS SUBROUTINE IS CONSIDERED
C   OBSOLETE AND MAY BE REMOVED FROM THE BUFR ARCHIVE LIBRARY IN A
C   FUTURE VERSION; USERS SHOULD INSTEAD MIGRATE TO THE USE OF BUFR
C   ARCHIVE LIBRARY SUBROUTINE PKBS1.
C
C PROGRAM HISTORY LOG:
C 2003-11-04  D. KEYSER  -- ORIGINAL AUTHOR
C 2004-08-18  J. ATOR    -- REMOVED IFIRST CHECK, SINCE WRDLEN NOW
C                           KEEPS TRACK OF WHETHER IT HAS BEEN CALLED;
C                           ADDED NBYT=0 OPTION; ADDED CHECK TO
C                           PREVENT OVERWRITE OF CERTAIN BYTES
C 2005-11-29  J. ATOR    -- MARKED AS OBSOLETE AND ADDED PRINT
C                           NOTIFICATION
C DART $Id$
C
C USAGE:    CALL OVRBS1 (NVAL, MBAY, NBYT)
C   INPUT ARGUMENT LIST:
C     NVAL     - INTEGER: INTEGER WORD TO BE PACKED
C     MBAY     - INTEGER: *-WORD PACKED BINARY ARRAY CONTAINING BUFR
C                MESSAGE PRIOR TO ANY OVERWRITING OF INFORMATION
C     NBYT     - INTEGER: BYTE WITHIN SECTION 1 OF BUFR TO OVERWRITE:
C                       0 = OVERWRITE BYTE 8 OF SECTION 0
C
C   OUTPUT ARGUMENT LIST:
C     MBAY     - INTEGER: *-WORD PACKED BINARY ARRAY CONTAINING BUFR
C                MESSAGE WITH NVAL NOW PACKED IN REQUESTED LOCATION
C
C REMARKS:
C    THIS ROUTINE CALLS:        BORT     PKB      WRDLEN
C    THIS ROUTINE IS CALLED BY: MSGWRT
C                               Also called by application programs.
C
C ATTRIBUTES:
C   LANGUAGE: FORTRAN 77
C   MACHINE:  PORTABLE TO ALL PLATFORMS
C
C$$$

      DIMENSION MBAY(*)

      CHARACTER*128 BORT_STR

      COMMON /QUIET / IPRT

      DATA IFIRST/0/

      SAVE IFIRST

C-----------------------------------------------------------------------
C-----------------------------------------------------------------------

      IF(IFIRST.EQ.0) THEN
         IF(IPRT.GE.0) THEN
      PRINT*
      PRINT*,'+++++++++++++++++BUFR ARCHIVE LIBRARY++++++++++++++++++++'
      PRINT 101
101   FORMAT(' BUFRLIB: OVRBS1 - THIS SUBROUTINE IS NOW OBSOLETE; ',
     . 'USE SUBROUTINE PKBS1 INSTEAD')
      PRINT*,'+++++++++++++++++BUFR ARCHIVE LIBRARY++++++++++++++++++++'
      PRINT*
         ENDIF
         IFIRST = 1
      ENDIF

C     CALL SUBROUTINE WRDLEN TO INITIALIZE SOME IMPORTANT INFORMATION
C     ABOUT THE LOCAL MACHINE, JUST IN CASE SUBROUTINE OPENBF HASN'T
C     BEEN CALLED YET.

      CALL WRDLEN

C     PREVENT CERTAIN BYTES FROM BEING OVERWRITTEN.
 
      IF( NBYT.LT.0 .OR. NBYT.EQ.8 .OR. NBYT.GT.18 .OR.
     .     ( NBYT.GE.1 .AND. NBYT.LE.3 ) ) GOTO 900

C     NOTE THAT THERE ARE ALWAYS 8 BYTES WITHIN SECTION 0.

      NBIT=8*(8+(NBYT-1))
      CALL PKB(NVAL,8,MBAY,NBIT)

      RETURN
900   WRITE(BORT_STR,'("BUFRLIB: OVRBS1 - CANNOT OVERWRITE BYTE '//
     . 'NUMBER (",I3,")")') NBYT
      CALL BORT(BORT_STR)
      END
