      SUBROUTINE TRYBUMP(LUNIT,LUN,USR,I1,I2,IO,IRET)

C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C
C SUBPROGRAM:    TRYBUMP (docblock incomplete)
C   PRGMMR: WOOLLEN          ORG: NP20       DATE: 1994-01-06
C
C ABSTRACT: THIS SUBROUTINE CHECKS THE FIRST NODE ASSOCIATED WITH A
C   CHARACTER STRING (PARSED INTO ARRAYS IN COMMON BLOCK /USRSTR/) IN
C   ORDER TO DETERMINE IF IT REPRESENTS A DELAYED REPLICATION SEQUENCE.
C   IF SO, THEN THE DELAYED REPLICATION SEQUENCE IS INITIALIZED, IT IS
C   "BUMPED" TO THE VALUE OF INPUT ARGUMENT I2, AND AN ATTEMPT IS MADE
C   TO READ OR WRITE SPECIFIED VALUES TO THE CURRENT BUFR DATA SET IN
C   UNIT LUNIT.
C
C PROGRAM HISTORY LOG:
C 1994-01-06  J. WOOLLEN -- ORIGINAL AUTHOR
C 1998-07-08  J. WOOLLEN -- IMPROVED MACHINE PORTABILITY
C 1999-11-18  J. WOOLLEN -- THE NUMBER OF BUFR FILES WHICH CAN BE
C                           OPENED AT ONE TIME INCREASED FROM 10 TO 32
C                           (NECESSARY IN ORDER TO PROCESS MULTIPLE
C                           BUFR FILES UNDER THE MPI)
C 2003-11-04  S. BENDER  -- ADDED REMARKS/BUFRLIB ROUTINE
C                           INTERDEPENDENCIES
C 2003-11-04  D. KEYSER  -- MAXJL (MAXIMUM NUMBER OF JUMP/LINK ENTRIES)
C                           INCREASED FROM 15000 TO 16000 (WAS IN
C                           VERIFICATION VERSION); UNIFIED/PORTABLE FOR
C                           WRF; ADDED DOCUMENTATION (INCLUDING
C                           HISTORY) (INCOMPLETE); OUTPUTS MORE
C                           COMPLETE DIAGNOSTIC INFO WHEN ROUTINE
C                           TERMINATES ABNORMALLY
C DART $Id$
C
C USAGE:    CALL TRYBUMP (LUNIT, LUN, USR, I1, I2, IO, IRET)
C   INPUT ARGUMENT LIST:
C     LUNIT    - INTEGER: FORTRAN LOGICAL UNIT NUMBER FOR BUFR FILE
C                (SEE REMARKS)
C     LUN      - INTEGER: I/O STREAM INDEX INTO INTERNAL MEMORY ARRAYS
C                (ASSOCIATED WITH FILE CONNECTED TO LOGICAL UNIT LUNIT)
C     USR      - REAL*8: (I1,I2) STARTING ADDRESS OF DATA VALUES READ
C                FROM OR WRITTEN TO DATA SUBSET
C     I1       - INTEGER: LENGTH OF FIRST DIMENSION OF USR
C     I2       - INTEGER: IF READING, LENGTH OF SECOND DIMENSION OF
C                USR; IF WRITING, NUMBER OF "LEVELS" OF DATA VALUES TO
C                BE WRITTEN TO DATA SUBSET
C     IO       - INTEGER: STATUS INDICATOR FOR BUFR FILE ASSOCIATED
C                WITH LUNIT:
C                       0 = input file
C                       1 = output file
C
C   OUTPUT ARGUMENT LIST:
C     IRET     - INTEGER: NUMBER OF "LEVELS" OF DATA VALUES READ FROM
C                OR WRITTEN TO DATA SUBSET (IF READING SHOULD BE NO
C                LARGER THAN I2, IF WRITING SHOULD BE SAME AS I2)
C                      -1 = ....
C
C REMARKS:
C    ARGUMENT LUNIT IS NOT REFERENCED IN THIS SUBROUTINE.  IT IS LEFT
C    HERE IN CASE AN APPLICATION PROGRAM CALLS THIS SUBROUTINE.
C
C    THIS ROUTINE CALLS:        BORT     INVWIN   LSTJPB   UFBRW
C                               USRTPL
C    THIS ROUTINE IS CALLED BY: UFBINT   UFBOVR
C                               Normally not called by any application
C                               programs.
C
C ATTRIBUTES:
C   LANGUAGE: FORTRAN 77
C   MACHINE:  PORTABLE TO ALL PLATFORMS
C
C$$$

      INCLUDE 'bufrlib.prm'

      COMMON /USRINT/ NVAL(NFILES),INV(MAXJL,NFILES),VAL(MAXJL,NFILES)
      COMMON /USRSTR/ NNOD,NCON,NODS(20),NODC(10),IVLS(10),KONS(10)

      REAL*8 USR(I1,I2),VAL

C-----------------------------------------------------------------------
C-----------------------------------------------------------------------

C  SEE IF THERE IS A DELAYED REPLICATION GROUP INVOLVED
C  ----------------------------------------------------

      NDRP = LSTJPB(NODS(1),LUN,'DRP')
      IF(NDRP.LE.0) GOTO 100

C  IF SO, CLEAN IT OUT AND BUMP IT TO I2
C  -------------------------------------

      INVN = INVWIN(NDRP,LUN,1,NVAL(LUN))
      VAL(INVN,LUN) = 0
      JNVN = INVN+1
      DO WHILE(NINT(VAL(JNVN,LUN)).GT.0)
         JNVN = JNVN+NINT(VAL(JNVN,LUN))
      ENDDO
      DO KNVN=1,NVAL(LUN)-JNVN+1
      INV(INVN+KNVN,LUN) = INV(JNVN+KNVN-1,LUN)
      VAL(INVN+KNVN,LUN) = VAL(JNVN+KNVN-1,LUN)
      ENDDO
      NVAL(LUN) = NVAL(LUN)-(JNVN-INVN-1)
      CALL USRTPL(LUN,INVN,I2)

C  FINALLY, CALL THE MNEMONIC READER/WRITER
C  ----------------------------------------

      CALL UFBRW(LUN,USR,I1,I2,IO,IRET)

C  EXIT
C  ----

100   RETURN
      END
