% DART : summary plots of global error and spread
% Example 1
% truth_file = 'True_State.nc';
% diagn_file = 'Posterior_Diag.nc';
% plot_total_err

% Data Assimilation Research Testbed -- DART
% Copyright 2004-2007, Data Assimilation Research Section
% University Corporation for Atmospheric Research
% Licensed under the GPL -- www.gpl.org/licenses/gpl.html
%
% <next few lines under version control, do not edit>
% $URL: http://subversion.ucar.edu/DAReS/DART/trunk/matlab/plot_total_err.m $
% $Id: plot_total_err.m 3075 2007-08-22 23:00:32Z thoar $
% $Revision: 3075 $
% $Date: 2007-08-22 17:00:32 -0600 (Wed, 22 Aug 2007) $

if (exist('truth_file') ~= 1)
   truth_file = input('Input name of True State file; <cr> for True_State.nc\n','s');
   if isempty(truth_file)
      truth_file = 'True_State.nc';
   end
end

if (exist('diagn_file') ~=1)
   disp('Input name of prior or posterior diagnostics file;')
   diagn_file = input('<cr> for Prior_Diag.nc\n','s');
   if isempty(diagn_file)
      diagn_file = 'Prior_Diag.nc';
   end
end

disp(sprintf('Comparing %s and \n          %s', truth_file, diagn_file))

pinfo = CheckModel(diagn_file);
pinfo.truth_file = truth_file;
pinfo.diagn_file = diagn_file;
pinfo.truth_time = [-1,-1];
pinfo.diagn_time = [-1,-1];

PlotTotalErr( pinfo );
clear pinfo
