function corr = ens_correl(base_var, base_time, state_var)
% ens_correl  Computes correlation of a variable at a time to a time series of
% another variable (could be the same one)

% Data Assimilation Research Testbed -- DART
% Copyright 2004-2007, Data Assimilation Research Section
% University Corporation for Atmospheric Research
% Licensed under the GPL -- www.gpl.org/licenses/gpl.html
%
% <next few lines under version control, do not edit>
% $URL: http://subversion.ucar.edu/DAReS/DART/trunk/matlab/jeff_correl.m $
% $Id: jeff_correl.m 2691 2007-03-11 18:18:09Z thoar $
% $Revision: 2691 $
% $Date: 2007-03-11 12:18:09 -0600 (Sun, 11 Mar 2007) $

%Extract sample of base at base time
%base_ens = base_var(base_time, :);

% size(base_var)
% size(base_time)
% size(state_var)
% size(base_ens)

% Loop through time to correlate with the other ensemble series
figure(9);
hold on;
num_times = size(state_var, 1);
for i = 1:num_times
   x = corrcoef(base_var(i, :), state_var(i, :));
   corr(i) = x(1, 2);
%   plot(base_var(i, 1), state_var(i, 1), 'x');
%   plot(base_var(i, :), state_var(i, :), 'x');
%   plot(2, corr(i), 'x');
end 

plot(base_var(:, 1), state_var(:, 1));

figure(1);
