! Data Assimilation Research Testbed -- DART
! Copyright 2004-2007, Data Assimilation Research Section
! University Corporation for Atmospheric Research
! Licensed under the GPL -- www.gpl.org/licenses/gpl.html
 
program main

! <next few lines under version control, do not edit>
! $URL: http://subversion.ucar.edu/DAReS/DART/trunk/models/bgrid_solo/ps_id_stdin.f90 $
! $Id: ps_id_stdin.f90 2713 2007-03-26 04:09:04Z thoar $
! $Revision: 2713 $
! $Date: 2007-03-25 22:09:04 -0600 (Sun, 25 Mar 2007) $

implicit none

! version controlled file description for error handling, do not edit
character(len=128), parameter :: &
   source   = "$URL: http://subversion.ucar.edu/DAReS/DART/trunk/models/bgrid_solo/ps_id_stdin.f90 $", &
   revision = "$Revision: 2713 $", &
   revdate  = "$Date: 2007-03-25 22:09:04 -0600 (Sun, 25 Mar 2007) $"

integer :: i
integer, parameter :: interval = 7

! Number of observations assumes standard 1800 points
write(*, *) 1800
! No data copies of qc
write(*, *) 0
write(*, *) 0

do i = 1, 1800
! There are more obs
   write(*, *) 0

! Input the index for the next ps variable
   write(*, *) (1 + (i - 1) * 6) * (-1)

! Time set to 0 days 0 seconds for initial sequence creation
   write(*, *) 0, 0

! Error variance is
   write(*, *) 100.0

end do

! Output the file name at the end
write(*, *) 'set_def.out'

end program main
