function [state_incs] = get_state_increments(state_ens, obs_ens, obs_incs)
%% get_state_increments Computes state increments given observation increments and
% the state and obs prior ensembles

%% DART software - Copyright 2004 - 2013 UCAR. This open source software is
% provided by UCAR, "as is", without charge, subject to all terms of use at
% http://www.image.ucar.edu/DAReS/DART/DART_download
%
% DART $Id: get_state_increments.m 8125 2015-06-24 21:20:35Z thoar $

% Compute state variance and covariance
covar = cov(state_ens, obs_ens);


state_incs = obs_incs * covar(1, 2) / covar(2, 2);

% <next few lines under version control, do not edit>
% $URL: https://proxy.subversion.ucar.edu/DAReS/DART/trunk/DART_LAB/matlab/private/get_state_increments.m $
% $Revision: 8125 $
% $Date: 2015-06-24 15:20:35 -0600 (Wed, 24 Jun 2015) $

