! Data Assimilation Research Testbed -- DART
! Copyright 2004, 2005, Data Assimilation Initiative, University Corporation for Atmospheric Research
! Licensed under the GPL -- www.gpl.org/licenses/gpl.html

program assim_region

! Main program to do assimilation of a region with filters for
! parallel multiple executables
!
! <next five lines automatically updated by CVS, do not edit>
! $Source: /home/thoar/CVS.REPOS/DART/assim_tools/assim_region.f90,v $ 
! $Revision: 1.4 $ 
! $Date: 2005/02/28 16:11:30 $ 
! $Author: jla $ 
! $Name: hawaii $ 

use  assim_tools_mod, only : async_assim_region, assim_tools_init
use    utilities_mod, only : initialize_utilities, register_module
use  assim_model_mod, only : static_init_assim_model
use obs_sequence_mod, only : static_init_obs_sequence

implicit none

! CVS Generated file description for error handling, do not edit
character(len=128) :: &
source   = "$Source: /home/thoar/CVS.REPOS/DART/assim_tools/assim_region.f90,v $", &
revision = "$Revision: 1.4 $", &
revdate  = "$Date: 2005/02/28 16:11:30 $"

! Need to initialize modules used as appropriate
call initialize_utilities
call register_module(source, revision, revdate)
call assim_tools_init(.true.)
call static_init_obs_sequence()
call static_init_assim_model()

write(*, *) 'program assim region calling async_assim_region'
call async_assim_region('filter_assim_region_in', 'filter_assim_region_out')
write(*, *) 'program assim region back from async_assim_region'

end program assim_region
