! Data Assimilation Research Testbed -- DART
! Copyright 2004, 2005, Data Assimilation Initiative, University Corporation for Atmospheric Research
! Licensed under the GPL -- www.gpl.org/licenses/gpl.html
 
program advance_cymdh

! <next five lines automatically updated by CVS, do not edit>
! $Source: /home/thoar/CVS.REPOS/DART/models/wrf/WRF_DART_utilities/advance_cymdh.f90,v $
! $Revision: 1.2 $
! $Date: 2005/02/26 06:14:25 $
! $Author: thoar $
! $Name: hawaii $

  implicit none

  interface
     integer function iargc()
     end function iargc
  end interface

  integer :: ccyy, mm, dd, hh, dh

  integer :: nargum, i, n, sign

  character(len=80), dimension(2) :: argum

  character(len=10) :: ccyymmddhh

  nargum=iargc()

  if(nargum /= 2) then
     write(unit=*, fmt='(a)') &
          'Usage: advance_cymdh ccyymmddhh dh'
     stop 'try again.'
  endif

  do i=1,nargum
     do n=1,80
        argum(i)(n:n)=' '
     enddo
     call getarg(i,argum(i))
  enddo

  ccyymmddhh = trim(argum(1))

  read(ccyymmddhh(1:10), fmt='(i4, 3i2)')  ccyy, mm, dd, hh

  sign = 1

  dh = 0

  do n=1,len_trim(argum(2))
     if(argum(2)(n:n) == '-') then
        sign = -1
        cycle
     else
        read(argum(2)(n:n), fmt='(i1)') i
        dh=10*dh + i
     end if
  enddo

  dh = sign * dh

  hh = hh + dh

  do while (hh < 0) 
     hh = hh + 24
     call change_date ( ccyy, mm, dd, -1 )
  end do

  do while (hh > 23) 
     hh = hh - 24
     call change_date ( ccyy, mm, dd, 1 )
  end do

  write(ccyymmddhh(1:10), fmt='(i4, 3i2.2)')  ccyy, mm, dd, hh
  write(unit=*, fmt='(a)') ccyymmddhh

contains

  subroutine change_date( ccyy, mm, dd, delta )

    implicit none

    integer, intent(inout) :: ccyy, mm, dd
    integer, intent(in)    :: delta

    integer, dimension(12) :: mmday

    mmday = (/31,28,31,30,31,30,31,31,30,31,30,31/)

    if (mod(ccyy,4) == 0) then
       mmday(2) = 29

       if ( mod(ccyy,100) == 0) then
          mmday(2) = 28
       endif

       if(mod(ccyy,400) == 0) then
          mmday(2) = 29
       end if
    endif

    dd = dd + delta

    if(dd == 0) then
       mm = mm - 1

       if(mm == 0) then
          mm = 12
          ccyy = ccyy - 1
       endif

       dd = mmday(mm)
    elseif ( dd .gt. mmday(mm) ) then
       dd = 1
       mm = mm + 1
       if(mm > 12 ) then
          mm = 1
          ccyy = ccyy + 1
       end if
    end if

  end subroutine change_date

end program advance_cymdh
