function err = total_err(pred, verif, w)
%TOTAL_ERR: Computes Total error for time series of set of state variables

% Data Assimilation Research Testbed -- DART
% Copyright 2004, 2005, Data Assimilation Initiative, University Corporation for Atmospheric Research
% Licensed under the GPL -- www.gpl.org/licenses/gpl.html
 
% <next three lines automatically updated by CVS, do not edit>
% $Id: total_err.m,v 1.5 2005/02/26 06:14:19 thoar Exp $
% $Source: /home/thoar/CVS.REPOS/DART/matlab/total_err.m,v $
% $Name: HEAD $

% Pred and verif are time_series_length x number of variables
num_times = size(pred, 1);
num_vars  = size(pred, 2);

if ( nargin == 2 )
   %--------------------------------------------------
   % unweighted error
   %--------------------------------------------------

   err = sqrt( sum( (pred - verif).^2       , 2) );

elseif ( nargin == 3 )
   %--------------------------------------------------
   % weighted error
   %--------------------------------------------------

   if (length(w) ~= num_vars)
      error(sprintf('wrong sizes %d and %d',length(w),num_vars))
   end

   err = zeros(num_times,1);

   for i = 1:num_times,

      d  = (pred(i,:) - verif(i,:)).^2;

      err(i) = sqrt( sum( d(:) .* w ) );
   end

else
   error('Wrong number of arguments.')
end
