#^CFG COPYRIGHT UM
##################################################################
#          Add variable name replacement rules as                #
#                                                                #
#             oldname => newname,                                #
#                                                                #
#          One rule per line!                                    #
#                                                                #
#  This file should be named RenameList.pl and be in the same    #
#  directory as Rename.pl, or it should be explicitly given      #
#  with the -i=FileName switch of Rename.pl                      #
#                                                                #
#                                                                #
##################################################################

%newname=(
	  #ModMain

	  nMultiBlkLevels             => nBlock,
	  total_number_of_blocks_used => nBlockALL,
	  globalBLK                   => iBlockGlobal,

	  problem_uniform             => ProblemUniform_,
	  problem_shocktube           => ProblemShocktube_,
	  problem_comet               => ProblemComet_,
	  problem_earth               => ProblemEarth_,
	  problem_jupiter             => ProblemJupiter_,
	  problem_saturn              => ProblemSaturn_,
	  problem_venus               => ProblemVenus_,
	  problem_cylinder            => ProblemCylinder_,
	  problem_sphere              => ProblemSphere_,
	  problem_arcade              => ProblemArcade_,
	  problem_cme                 => ProblemCME_,

	  Rconservative               => rConservative,

	  x1                          => xMinALL,
	  x2                          => xMaxALL,
	  y1                          => yMinALL,
	  y2                          => yMaxALL,
	  z1                          => zMinALL,
	  z2                          => zMaxALL,

	  unused                      => UnusedProc,
	  dxyz                        => Dxyz_D,
	  xyzend                      => XyzLimits_ID,
	  n_step                      => nStep,
	  nITER                       => MaxIter,
	  nORDER                      => nOrder,
	  nSTAGE                      => nStage,
	  iteration_number            => nIter,
	  t_max                       => TimeMaxALL,
	  dt                          => DtALL,
	  dt_BLK                      => DtBLK_B,
	  cputime_max                 => CpuTimeMax,
	  time_accurate               => UseTimeAccurate,
	  boris_correction            => UseBoris,
	  time_loop                   => DoingAdvance,
	  check_stopfile              => CheckStopFile,
	  MHDtoUAM                    => DoMHDtoUAM,
	  dn_couple_ionosphere        => DnCoupleIonosphere,
	  dt_couple_ionosphere        => DtCoupleIonosphere,

	  iono_init                   => IonoInit_,
	  iono_fac                    => IonoFac_,
	  iono_read                   => IonoRead_,
	  iono_save                   => IonoWrite_,
	  iono_save_restart           => IonoWriteRestart_,
	  iono_solve                  => IonoSolve_,

	  dn_raytrace                 => DnRayTrace,
	  check_rayloop               => CheckRayLoop,
	  dt_UpdateB0                 => DtUpdateB0,

	  initial_refine_levels       => nLevelInit,
	  nRefineLevelIC              => nLevelIc,
	  dn_refine                   => DnAmr,
	  min_block_level             => MinLevelBLK,
	  max_block_level             => MaxLevelBLK,
	  min_cell_dx                 => DxMinBLK,
	  max_cell_dx                 => DxMaxBLK,
	  automatic_refinement        => DoPhysicsAmr,
	  fix_body_level              => FixLevelBody,

	  x_BLK                       => x_GB,
	  y_BLK                       => y_GB,
	  z_BLK                       => z_GB,
	  R_BLK                       => r_GB,
	  R2_BLK                      => r2_GB,
	  rho_BLK                     => Rho_GB,
	  rhoUx_BLK                   => RhoUx_GB,
	  rhoUy_BLK                   => RhoUy_GB,
	  rhoUz_BLK                   => RhoUz_GB,
	  Bx_BLK                      => Bx_GB,
	  By_BLK                      => By_GB,
	  Bz_BLK                      => Bz_GB,
	  p_BLK                       => p_GB,
	  E_BLK                       => e_GB,
	  B0xCell_BLK                 => B0x_GB,
	  B0yCell_BLK                 => B0y_GB,
	  B0zCell_BLK                 => B0z_GB,
	  time_BLK                    => Dt_GB,

	  tmp1_BLK                    => Tmp1_GB,
	  tmp2_BLK                    => Tmp2_GB,

	  rho_o_BLK                   => RhoOld_CB,
	  rhoUx_o_BLK                 => RhoUxOld_CB,
	  rhoUy_o_BLK                 => RhoUyOld_CB,
	  rhoUz_o_BLK                 => RhoUzOld_CB,
	  Bx_o_BLK                    => BxOld_CB,
	  By_o_BLK                    => ByOld_CB,
	  Bz_o_BLK                    => BzOld_CB,
	  E_o_BLK                     => eOld_CB,
	  p_o_BLK                     => pOld_CB,

	  fbody_x_BLK                 => ForceXBody_CB,
	  fbody_y_BLK                 => ForceYBody_CB,
	  fbody_z_BLK                 => ForceZBody_CB,
	  qheat_BLK                   => Heat_CB,

	  shock_L_state               => StateLeftShock_V,
	  shock_R_state               => StateRightShock_V,
	  shock_rotated               => RotateShock,

	  Srho                        => SourceRho_C,
	  SrhoUx                      => SourceRhoUx_C,
	  SrhoUy                      => SourceRhoUy_C,
	  SrhoUz                      => SourceRhoUz_C,
	  SBx                         => SourceBx_C,
	  SBy                         => SourceBy_C,
	  SBz                         => SourceBz_C,
	  SE                          => SourceE_C,
	  SP                          => SourceP_C,
	  Sdivb                       => SourceDivB_G,
	  Theat0                      => Heat0_C,

	  gradX_rho                   => GradXRho_G,
	  gradY_rho                   => GradYRho_G,
	  gradZ_rho                   => GradZRho_G,
	  gradX_Ux                    => GradXUx_G,
	  gradY_Ux                    => GradYUx_G,
	  gradZ_Ux                    => GradZUx_G,
	  gradX_Uy                    => GradXUy_G,
	  gradY_Uy                    => GradYUy_G,
	  gradZ_Uy                    => GradZUy_G,
	  gradX_Uz                    => GradXUz_G,
	  gradY_Uz                    => GradYUz_G,
	  gradZ_Uz                    => GradZUz_G,
	  gradX_Bx                    => GradXBx_G,
	  gradY_Bx                    => GradYBx_G,
	  gradZ_Bx                    => GradZBx_G,
	  gradX_By                    => GradXBy_G,
	  gradY_By                    => GradYBy_G,
	  gradZ_By                    => GradZBy_G,
	  gradX_Bz                    => GradXBz_G,
	  gradY_Bz                    => GradYBz_G,
	  gradZ_Bz                    => GradZBz_G,
	  gradX_P                     => GradXP_G,
	  gradY_P                     => GradYP_G,
	  gradZ_P                     => GradZP_G,
	  gradX_VAR                   => GradXVar_G,
	  gradY_VAR                   => GradYVar_G,
	  gradZ_VAR                   => GradZVar_G,

	  B0xFace_x_BLK               => B0x_XB,
	  B0yFace_x_BLK               => B0y_XB,
	  B0zFace_x_BLK               => B0z_XB,
	  B0xFace_y_BLK               => B0x_YB,
	  B0yFace_y_BLK               => B0y_YB,
	  B0zFace_y_BLK               => B0z_YB,
	  B0xFace_z_BLK               => B0x_ZB,
	  B0yFace_z_BLK               => B0y_ZB,
	  B0zFace_z_BLK               => B0z_ZB,

	  minDXvalue                  => DxMinALL,
	  maxDXvalue                  => DxMaxALL,
	  dx_BLK                      => Dx_B,
	  dy_BLK                      => Dy_B,
	  dz_BLK                      => Dz_B,
	  Rmin_BLK                    => rMin_B,
	  Rmin2_BLK                   => r2Min_B,
	  fAx_BLK                     => SurfaceX_B,
	  fAy_BLK                     => SurfaceY_B,
	  fAz_BLK                     => SurfaceZ_B,
	  cV_BLK                      => Volume_B,
	  cVinv_BLK                   => VolumeInverse_B,
	  unusedBLK                   => UnusedBLK_B,
	  global_block_number         => iBlockALL_B,

	  rhoFaceL_x                  => RhoLeft_X,
	  UxFaceL_x                   => UxLeft_X,
	  UyFaceL_x                   => UyLeft_X,
	  UzFaceL_x                   => UzLeft_X,
	  BxFaceL_x                   => BxLeft_X,
	  ByFaceL_x                   => ByLeft_X,
	  BzFaceL_x                   => BzLeft_X,
	  EFaceL_x                    => eLeft_X,
	  PFaceL_x                    => pLeft_X,
	  rhoFaceR_x                  => RhoRight_X,
	  UxFaceR_x                   => UxRight_X,
	  UyFaceR_x                   => UyRight_X,
	  UzFaceR_x                   => UzRight_X,
	  BxFaceR_x                   => BxRight_X,
	  ByFaceR_x                   => ByRight_X,
	  BzFaceR_x                   => BzRight_X,
	  EFaceR_x                    => eRight_X,
	  PFaceR_x                    => pRight_X,
	  rhoFaceF_x                  => FluxRho_X,
	  rhoUxFaceF_x                => FluxRhoUx_X,
	  rhoUyFaceF_x                => FluxRhoUy_X,
	  rhoUzFaceF_x                => FluxRhoUz_X,
	  BxFaceF_x                   => FluxBx_X,
	  ByFaceF_x                   => FluxBy_X,
	  BzFaceF_x                   => FluxBz_X,
	  EFaceF_x                    => FluxE_X,
	  PFaceF_x                    => FluxP_X,
	  VdtFace_x                   => VolumeDt_X,

	  rhoFaceL_y                  => RhoLeft_Y,
	  UxFaceL_y                   => UxLeft_Y,
	  UyFaceL_y                   => UyLeft_Y,
	  UzFaceL_y                   => UzLeft_Y,
	  BxFaceL_y                   => BxLeft_Y,
	  ByFaceL_y                   => ByLeft_Y,
	  BzFaceL_y                   => BzLeft_Y,
	  EFaceL_y                    => eLeft_Y,
	  PFaceL_y                    => pLeft_Y,
	  rhoFaceR_y                  => rhoRight_Y,
	  UxFaceR_y                   => UxRight_Y,
	  UyFaceR_y                   => UyRight_Y,
	  UzFaceR_y                   => UzRight_Y,
	  BxFaceR_y                   => BxRight_Y,
	  ByFaceR_y                   => ByRight_Y,
	  BzFaceR_y                   => BzRight_Y,
	  EFaceR_y                    => eRight_Y,
	  PFaceR_y                    => pRight_Y,
	  rhoFaceF_y                  => FluxRho_Y,
	  rhoUxFaceF_y                => FluxRhoUx_Y,
	  rhoUyFaceF_y                => FluxRhoUy_Y,
	  rhoUzFaceF_y                => FluxRhoUz_Y,
	  BxFaceF_y                   => FluxBx_Y,
	  ByFaceF_y                   => FluxBy_Y,
	  BzFaceF_y                   => FluxBz_Y,
	  EFaceF_y                    => FluxE_Y,
	  PFaceF_y                    => FluxP_Y,
	  VdtFace_y                   => VolumeDt_Y,

	  rhoFaceL_z                  => rhoLeft_Z,
	  UxFaceL_z                   => UxLeft_Z,
	  UyFaceL_z                   => UyLeft_Z,
	  UzFaceL_z                   => UzLeft_Z,
	  BxFaceL_z                   => BxLeft_Z,
	  ByFaceL_z                   => ByLeft_Z,
	  BzFaceL_z                   => BzLeft_Z,
	  EFaceL_z                    => eLeft_Z,
	  PFaceL_z                    => pLeft_Z,
	  rhoFaceR_z                  => rhoRight_Z,
	  UxFaceR_z                   => UxRight_Z,
	  UyFaceR_z                   => UyRight_Z,
	  UzFaceR_z                   => UzRight_Z,
	  BxFaceR_z                   => BxRight_Z,
	  ByFaceR_z                   => ByRight_Z,
	  BzFaceR_z                   => BzRight_Z,
	  EFaceR_z                    => eRight_Z,
	  PFaceR_z                    => pRight_Z,
	  rhoFaceF_z                  => FluxRho_Z,
	  rhoUxFaceF_z                => FluxRhoUx_Z,
	  rhoUyFaceF_z                => FluxRhoUy_Z,
	  rhoUzFaceF_z                => FluxRhoUz_Z,
	  BxFaceF_z                   => FluxBx_Z,
	  ByFaceF_z                   => FluxBy_Z,
	  BzFaceF_z                   => FluxBz_Z,
	  EFaceF_z                    => FluxE_Z,
	  PFaceF_z                    => FluxP_Z,
	  VdtFace_z                   => VolumeDt_Z,

	  rhoFaceFC_x_BLK             => FluxRhoCons_XB,
	  rhoUxFaceFC_x_BLK           => FluxRhoUxCons_XB,
	  rhoUyFaceFC_x_BLK           => FluxRhoUyCons_XB,
	  rhoUzFaceFC_x_BLK           => FluxRhoUzCons_XB,
	  BxFaceFC_x_BLK              => FluxBxCons_XB,
	  ByFaceFC_x_BLK              => FluxByCons_XB,
	  BzFaceFC_x_BLK              => FluxBzCons_XB,
	  EFaceFC_x_BLK               => FluxECons_XB,
	  BxFaceAC_x_BLK              => BxCons_XB,

	  rhoFaceFC_x_BLK             => FluxRhoCons_XB,
	  rhoUxFaceFC_x_BLK           => FluxRhoUxCons_XB,
	  rhoUyFaceFC_x_BLK           => FluxRhoUyCons_XB,
	  rhoUzFaceFC_x_BLK           => FluxRhoUzCons_XB,
	  BxFaceFC_x_BLK              => FluxBxCons_XB,
	  ByFaceFC_x_BLK              => FluxByCons_XB,
	  BzFaceFC_x_BLK              => FluxBzCons_XB,
	  EFaceFC_x_BLK               => FluxECons_XB,

	  rhoFaceFC_y_BLK             => FluxRhoCons_YB,
	  rhoUxFaceFC_y_BLK           => FluxRhoUxCons_YB,
	  rhoUyFaceFC_y_BLK           => FluxRhoUyCons_YB,
	  rhoUzFaceFC_y_BLK           => FluxRhoUzCons_YB,
	  BxFaceFC_y_BLK              => FluxBxCons_YB,
	  ByFaceFC_y_BLK              => FluxByCons_YB,
	  BzFaceFC_y_BLK              => FluxBzCons_YB,
	  EFaceFC_y_BLK               => FluxECons_YB,

	  rhoFaceFC_z_BLK             => FluxRhoCons_ZB,
	  rhoUxFaceFC_z_BLK           => FluxRhoUxCons_ZB,
	  rhoUyFaceFC_z_BLK           => FluxRhoUyCons_ZB,
	  rhoUzFaceFC_z_BLK           => FluxRhoUzCons_ZB,
	  BxFaceFC_z_BLK              => FluxBxCons_ZB,
	  ByFaceFC_z_BLK              => FluxByCons_ZB,
	  BzFaceFC_z_BLK              => FluxBzCons_ZB,
	  EFaceFC_z_BLK               => FluxECons_ZB,

	  NOBLK                       => NoBlock_,

	  neiLeast                    => dLevelEast_B,
	  neiLwest                    => dLevelWest_B,
	  neiLsouth                   => dLevelSouth_B,
	  neiLnorth                   => dLevelNorth_B,
	  neiLtop                     => dLevelTop_B,
	  neiLbot                     => dLevelBot_B,
	  neiLEV                      => dLevel_EB,

	  neiBeast                    => iBlockEast_QB,
	  neiBwest                    => iBlockWest_QB,
	  neiBsouth                   => iBlockSouth_QB,
	  neiBnorth                   => iBlockNorth_QB,
	  neiBtop                     => iBlockTop_QB,
	  neiBbot                     => iBlockBot_QB,
	  neiBLK                      => iBlock_QEB,

	  neiPeast                    => iProcEast_QB,
	  neiPwest                    => iProcWest_QB,
	  neiPsouth                   => iProcSouth_QB,
	  neiPnorth                   => iProcNorth_QB,
	  neiPtop                     => iProcTop_QB,
	  neiPbot                     => iProcBot_QB,
	  neiPE                       => iProc_QEB,

	  BLKneighborPE               => iProc_NQB,
	  BLKneighborBLK              => iBlock_NQB,
	  BLKneighborCHILD            => iChild_NQB,
	  BLKneighborLEV              => dLevel_NB,

	  NO_BLK                      => NoBlock2_,
	  NUM_NB_BUFFS                => nNonblockBuff,
          LOC_TSE                     => LocTSE_,
          LOC_TSW                     => LocTSW_,
          LOC_BSW                     => LocBSW_,
          LOC_BSE                     => LocBSE_,
          LOC_BNE                     => LocBNE_,
          LOC_BNW                     => LocBNW_,
          LOC_TNW                     => LocTNW_,
          LOC_TNE                     => LocTNE_,

	  percent_max_rho             => PercentMaxRho_I,
	  percent_max_p               => PercentMaxP_I,

          divb_diffcoeff              => DivbDiffCoeff,

          limiter_type                => TypeLimiter,
          prolong_type                => TypeProlong,

          body_BLK                    => InnerBcBlock_B,
          true_BLK                    => FullBlock_B,
          true_cell                   => UsedCell_GB,
          far_field_BCs_BLK           => OuterBcBlock_B,

          body1                       => UseBody,
          body2                       => UseBody2,
          
	  Magnetic_Pole_Colat         => MagneticPoleColat,
	  Magnetic_Pole_East_Lon      => MagneticPoleEastLon,
          Max_DoY_Tilt                => DoYTiltMax,

          CoordinateSystem            => iCoordSystem,

	  test_string                 => TestString,
	  Itest                       => iTest,
	  Jtest                       => jTest,
	  Ktest                       => kTest,
	  BLKtest                     => iBlockTest,
	  PROCtest                    => iProcTest,

	  ITERtest                    => IterTest,
	  VARtest                     => iVarTest,
          DIMtest                     => iDimTest,
          Xtest                       => xTest,
          Ytest                       => yTest,
          Ztest                       => zTest,
          Xtest_mod                   => xTestMod,
          Ytest_mod                   => yTestMod,
          Ztest_mod                   => zTestMod,
          Ttest                       => TimeTest,
          coord_test                  => UseXyzTest,

	  okdebug                     => DoDebug,
	  me_world                    => iProcMe,
	  numprocs                    => nProc,
          ira,                        => iErr,
          erno,                       => jErr,

	  Time_Simulation             => TimeALL,
	  Start_Time_Array            => DateInit_I,
          Time_Array                  => Date_I,
          Real_Time_of_Year           => TimeOfYear,

	  optimize_message_pass       => TypeMessagePass,
          
          Max_Upstream_Npts           => MaxPointUpstream,
          Upstream_Npts               => nPointUpstream,
          Upstream_Data               => VarUpstream_IV,
          Upstream_Time               => TimeUpstream_I,

	  GSM                         => GSM_,
	  GSE                         => GSE_,
	  GSO                         => GSO_,

	  Input_Coor_System           => iCoordSystemInput,
          Propagation_Plane_XY,       => AngleXYUpstreamPlane,
          Propagation_Plane_XZ,       => AngleXZUpstreamPlane,
	  Satellite_Y_Pos             => ySatelliteUpstream,
	  Satellite_Z_Pos             => zSatelliteUpstream,

	  dn_timing                   => DnTiming,

	  #ModSize
	  nBLK                        => MaxBlock,
	  nCellsI                     => nI,
	  nCellsJ                     => nJ,
	  nCellsK                     => nK,
	  nCells                      => nIjk_D,
	  gcn                         => nGc,

	  );
