module ModEUV

  use ModGITM, only: nLats, nLons, nAlts,nBlocksMax,nBlocks
  use ModPlanet

  implicit none

  real, dimension(nLons, nLats, nAlts) :: &
       xSolar, ySolar

  real, dimension(nLons, nLats, nAlts, nBlocksMax) :: &
       HeatingEfficiency_CB, eHeatingEfficiency_CB, EuvIonRate,EuvTotal

  real, dimension(nLons, nLats, nAlts, nIons,nBlocksMax) :: &
       EuvIonRateS

  real, dimension(nLons, nLats, nAlts, nSpeciesTotal,nBlocksMax) :: &
       EuvDissRateS

  real, dimension(nLons, nLats, nAlts, nSpecies,nBlocksMax) :: &
       Chapman

  real, dimension(nLons, nLats,nBlocksMax) :: &
       Sza, cosSza, sinSza, AveCosSza

  real :: SunOrbitEccentricity

  !-------------------------------------------------------------------
  ! The following section is devoted to setting up all of
  ! the wavelengths used with in the model.  This includes
  ! Photoionization, Photoabsorption, Branching ratios,
  ! the Solar EUV model, etc.
  !-------------------------------------------------------------------

  integer, parameter :: Num_waveLengths_Low = 37
  integer, parameter :: Num_WaveLengths_High = 59

  integer, parameter :: nS2WaveLengths = 80
integer, parameter :: nFlaresMax = 20
  integer, parameter :: nSeeLinesMax = 10000
  integer, parameter :: FlareLength = 5
  integer :: iFlare = 1
  logical :: DuringFlare = .False.
  integer :: nFlares = 0
  integer :: nSeeTimes, FlareStartIndex,FlareEndIndex
  real    :: FlareEndTime
  
  real, dimension(Num_WaveLengths_High,nSeeLinesMax) :: SeeFlux
  real, dimension(nSeeLinesMax) :: TimeSee
  real, dimension(nFlaresMax) :: FlareTimes
  logical :: ReReadEUVFile = .false.

  real, dimension(nS2WaveLengths) :: &
       S2WaveLengths, S2PhotonEnergy, S2SolarFlux, &
       S2PhotoAbsCO, S2PhotoAbsCO2, S2PhotoAbsN2, S2PhotoAbsO2, S2PhotoAbsO, &
       S2PhotoIonN2, S2PhotoIonCO, S2PhotoIonCO2, S2PhotoIonO2, &
       S2BranchingRatioOP

  real, dimension(1:Num_WaveLengths_Low) ::                         &
       EUV_WaveLength_1, EUV_WaveLength_2,                          &
       Photoabsorption_O, Photoabsorption_O2, Photoabsorption_N2,   &
       Photoionization_O, Photoionization_O2, Photoionization_N2,   &
       Photoionization_N, Photoionization_CO2, Photoionization_CO,        &
       BranchingRatio_OPlus4S, BranchingRatio_OPlus2d,              &
       BranchingRatio_OPlus2P, BranchingRatio_N2_to_NPlus,          &
       BranchingRatio_O2_to_OPlus,  PhotoAbsorption_CO2,   &
       PhotoAbsorption_CO, &
       F74113, AFAC,                                                &
       EUV_Flux

  real, dimension(1:Num_WaveLengths_High) :: RLMEUV, Flux_of_EUV,   &
       BranchingRatio_N2, BranchingRatio_O2,                        &
       PhotoAbs_O2, PhotoAbs_O, PhotoAbs_N2,                        &
       PhotoIon_O2, PhotoIon_OPLus4S, PhotoIon_N2, PhotoIon_N,      &
       PhotoIon_OPlus2D, PhotoIon_OPLus2P,                          &
       WAVEL, WAVES, RFLUX, XFLUX, SCALE1, SCALE2,                  &
       TCHR0, TCHR1, TCHR2, TCOR0, TCOR1, TCOR2, WAR1, WAR2,        &
       Solar_Flux, PhotonEnergy, &
       PhotoAbs_CO2, PhotoAbs_CO2_295, PhotoAbs_CO2_195, &
       PhotoAbs_CO, PhotoIon_CO2, PhotoIon_CO,        &
       PhotoAbs_CH4, PhotoAbs_H2, PhotoAbs_HCN,                     &
       PhotoIon_CH4, PhotoIon_H2, PhotoIon_HCN,                     &
       BranchingRatio_CO2_to_CO2Plus,BranchingRatio_CO2_to_OPlus,&
       BranchingRatio_CO2_to_COPlus,BranchingRatio_N2_to_N2Plus,&
!!
!! NOTA BENE NOTA BENE:  JMB
!! Please Note that these QuantunYields
!! Are Relative to the TOTAL ABSORPTION COEFFICIENT
!! They are NOT Relative to the Dissociation or Ioniziaton Coeficients!!!
!!
       QuantumYield_N2_N4S,                                       &
       QuantumYield_N2_N2Plus,                                    &
       QuantumYield_N2_NPlus,                                     &
       QuantumYield_CH4_CH3,                                      &
       QuantumYield_CH4_1CH2,                                     &
       QuantumYield_CH4_3CH2,                                     &
       QuantumYield_CH4_CH,                                       &
       QuantumYield_CH4_CH3Plus

       real, dimension(nLons,nLats,nAlts,Num_Wavelengths_High,nBlocksMax) :: CO2_Abs_Fac

  real :: EUVEFF

  real, dimension(1:4) :: Quench

  real, dimension(1:15) :: RLMSRC

  data Quench / 7.E-11, 5.E-11, 3.1401E-12, 9.1E-3/

! brn2
  data BranchingRatio_N2/                                               &
       36 * 0.00, 0.01, 0.04, 0.04, 0.03, 0.05, 0.05,                   &
       0.15, 0.20, 0.20, 0.25, 0.32, 0.34, 11 * 0.36/

! brn2->N2+
  data BranchingRatio_N2_to_N2plus/                                               &
       0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,&
       0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,&
       1.,1.,1.,1.,1.,1.,1.,1.,1.,1.,1.,1.,&
       1.,0.990,0.970,0.954,0.955,0.895,&
       0.908,0.837,0.786,0.787,0.700,0.743,&
       0.664,0.623,0.636,0.654,0.615,0.600, &
       0.600,0.600,0.600,0.600,0.600,0.600/

!brCO2->O+
  data BranchingRatio_CO2_to_OPlus/ &
       0.00, 0.00, 0.00, 0.00, 0.00, 0.00,      &
       0.00, 0.00, 0.00, 0.00, 0.00, 0.00,      &
       0.00, 0.00, 0.00, 0.00, 0.00, 0.00,      &
       0.00, 0.00, 0.00, 0.00, 0.00, 0.00,      &
       0.00, 0.00, 0.00, 0.00, 0.00, 0.00,      &
       0.015,0.014,0.024,0.033,0.035,0.041, &
       0.050,0.062,0.074,0.096,0.126,0.122, &
       0.145,0.153,0.153,0.139,0.138,0.140, &
       0.183,0.212,0.286,0.404,0.400,0.400, &
       0.400,0.400,0.400,0.400,0.400/   

!brCO2->CO+

  data BranchingRatio_CO2_to_COPlus/  &
       0.00, 0.00, 0.00, 0.00, 0.00, 0.00,      &
       0.00, 0.00, 0.00, 0.00, 0.00, 0.00,      &
       0.00, 0.00, 0.00, 0.00, 0.00, 0.00,      &
       0.00, 0.00, 0.00, 0.00, 0.00, 0.00,      &
       0.00, 0.00, 0.00, 0.00, 0.00, 0.00,      &
       0.001,0.001,0.004,0.009,0.009,0.012, &
       0.025,0.049,0.078,0.124,0.117,0.119, &
       0.103,0.092,0.092,0.090,0.088,0.091, &
       0.113,0.116,0.110,0.105,0.100,0.100, &
       0.100,0.100,0.100,0.100,0.100/

  !brCO2 -> CO2+
   data BranchingRatio_CO2_to_CO2Plus /      &
                  0.00, 0.00, 0.00, 0.00, 0.00, 0.00,&
                  0.00, 0.00, 0.00, 0.00, 0.00, 0.00,&
                  0.00, 0.00, 0.00, 0.00, 0.00, 0.00,&
                  0.00, 0.00, 0.00, 1.00, 1.00, 1.00,&
                  1.00, 1.00, 1.00, 1.00, 1.00, 1.00,&
                  0.984,0.985,0.972,0.958,0.956,0.947,&
                  0.925,0.888,0.848,0.776,0.705,0.715,&
                  0.675,0.672,0.673,0.695,0.699,0.690,&
                  0.595,0.546,0.451,0.288,0.200,0.200,&
                  0.200,0.200,0.200,0.200,0.200/


! bro2
  data BranchingRatio_O2/                                               &
       30 * 0.00, .025, .036, .045, .120, .155, .189,                   &
       .230, 0.20, 0.20, 0.20, 0.23, 0.25, 0.29, 16 * 0.33/

  data RLMEUV/                                                          &
       0.17250E-04, 0.16750E-04, 0.16250E-04, 0.15750E-04,              &
       0.15250E-04, 0.14750E-04, 0.14250E-04, 0.13750E-04,              &
       0.13250E-04, 0.12750E-04, 0.12250E-04, 0.12157E-04,              &
       0.11750E-04, 0.11250E-04, 0.10750E-04, 0.10250E-04,              &
       0.10319E-04, 0.10257E-04, 0.97500E-05, 0.97702E-05,              &
       0.92500E-05, 0.87500E-05, 0.82500E-05, 0.77500E-05,              &
       0.78936E-05, 0.77041E-05, 0.76515E-05, 0.72500E-05,              &
       0.70331E-05, 0.67500E-05, 0.62500E-05, 0.62973E-05,              &
       0.60976E-05, 0.57500E-05, 0.58433E-05, 0.55437E-05,              &
       0.52500E-05, 0.47500E-05, 0.46522E-05, 0.42500E-05,              &
       0.37500E-05, 0.36807E-05, 0.32500E-05, 0.30378E-05,              &
       0.30331E-05, 0.27500E-05, 0.28415E-05, 0.25630E-05,              &
       0.22500E-05, 0.17500E-05, 0.12500E-05, 0.75000E-06,              &
       0.41000E-06, 0.27500E-06, 0.19500E-06, 0.12000E-06,              &
       0.60000E-07, 0.30000E-07, 0.15000E-07/

!sigmas(1,*):
  data PhotoIon_O2/                                                       &
       0.00, 0.00, 0.00, 0.00, 0.00, 0.00,                              &
       0.00, 0.00, 0.00, 0.00, 0.00, 0.00,                              &
       0.00, 0.00, 0.00, 0.27e-18, 0.00, 1.00e-18,                      &
       12.22e-18, 2.50e-18, 9.34e-18, 4.69e-18, 6.12e-18, 9.39e-18,     &
       11.05e-18, 9.69e-18, 8.59e-18,23.81e-18,23.00e-18,22.05e-18,     &
       25.94e-18,25.80e-18,26.10e-18,25.04e-18,22.00e-18,25.59e-18,     &
       24.06e-18,21.59e-18,20.40e-18,19.39e-18,18.17e-18,18.40e-18,     &
       17.19e-18,16.80e-18,16.80e-18,15.10e-18,15.70e-18,13.20e-18,     &
       10.60e-18, 7.10e-18, 4.00e-18, 1.18e-18, 0.32e-18, 0.10e-18,     &
        1.02e-18, 0.14e-18, .024e-18, .004e-18, .0004e-18/

! sigico2 total; estimate by S. W. BOUGHER (11-09-21)
  data PhotoIon_CO2 /                                                   &
       15 * 0.00,                                                       &
       0.0e-18, 0.0e-18, 0.0e-18, 0.0e-18, 0.0e-18, 0.0e-18, 7.14e-18,&
       10.93e-18, 34.09e-18, 21.68e-18, 51.77e-18, 86.32e-18, &
       27.49e-18, 20.86e-18, 32.29e-18, 34.57e-18, 34.3e-18, &
       35.30e-18, 34.96e-18, 33.86e-18, 33.21e-18, 32.602e-18, 30.68e-18, &
       28.76e-18, 27.17e-18, 25.52e-18, 25.56e-18, 23.63e-18, 21.44e-18, &
       21.39e-18, 17.14e-18, 18.60e-18, 16.11e-18, 14.32e-18, 9.09e-18, &
       4.62e-18, 1.55e-18, 7 * 1.55e-18 /

!sigmas(2,*):
  data PhotoIon_OPLus4S/                                                  &
       20 * 0.00, 2.12e-18, 4.18e-18, 4.38e-18, 4.23e-18,               &
       4.28e-18, 4.18e-18, 4.18e-18, 4.20e-18, 4.91e-18, 4.01e-18,      &
       3.78e-18, 3.79e-18, 3.67e-18, 3.45e-18, 3.53e-18, 3.52e-18,      &
       3.45e-18, 3.26e-18, 3.15e-18, 3.03e-18, 2.51e-18, 2.59e-18,      &
       2.25e-18, 1.93e-18, 1.92e-18, 1.65e-18, 1.78e-18, 1.51e-18,      &
       1.38e-18, 0.78e-18, 0.46e-18, 0.18e-18, 0.05e-18, 0.015e-18,     &
       0.015e-18, 0.02e-18, 0.004e-18, 0.0006e-18, 0.00006e-18/

!sigmas(3,*):
  data PhotoIon_N2/                                                       &
       18 * 0.00,                                                       &
       0.00, 0.00, 0.00, 0.00, 0.00,16.75e-18,                          &
       10.18e-18,18.39e-18,23.77e-18,23.20e-18,23.00e-18,25.06e-18,     &
       23.22e-18,23.20e-18,23.10e-18,22.38e-18,23.20e-18,24.69e-18,     &
       24.53e-18,21.85e-18,21.80e-18,21.07e-18,17.51e-18,18.00e-18,     &
       13.00e-18,11.60e-18,11.60e-18,10.30e-18,10.60e-18, 9.70e-18,     &
       8.00e-18, 4.40e-18, 1.90e-18, 0.60e-18, 0.24e-18, 1.16e-18,      &
       0.48e-18, 0.09e-18, .015e-18, .003e-18, .0003e-18/

!
! For some reason, this one is 10 times larger than the rest...
!

!sigmas(4,*):
  data PhotoIon_N/                                                        &
       22 * 0.00,                                                       &
       1.00e-17, 1.00e-17, 1.00e-17, 1.00e-17, 1.10e-17, 1.10e-17,      &
       1.10e-17, 1.20e-17, 1.20e-17, 1.20e-17, 1.20e-17, 1.20e-17,      &
       1.10e-17, 1.20e-17, 1.15e-17, 1.10e-17, 1.00e-17, 1.00e-17,      &
       1.00e-17, 0.70e-17, 0.80e-17, 0.65e-17, 0.60e-17, 0.60e-17,      &
       0.50e-17, 0.50e-17, 0.40e-17, 0.35e-17, 0.25e-17, 0.20e-17,      &
       0.10e-17, 0.10e-17, 0.10e-17, 0.05e-17, 0.01e-17,                &
       2*0.0/

!sigmas(5,*):
  data PhotoIon_OPlus2D/                                                  &
       27 * 0.00, 3.80e-18, 6.44e-18, 5.52e-18, 5.49e-18,               &
       5.50e-18, 5.50e-18, 5.36e-18, 5.48e-18, 5.46e-18, 5.36e-18,      &
       5.24e-18, 5.06e-18, 4.71e-18, 3.86e-18, 3.98e-18, 3.47e-18,      &
       2.85e-18, 2.84e-18, 2.38e-18, 2.64e-18, 2.12e-18, 1.86e-18,      &
       0.99e-18, 0.51e-18, 0.19e-18, 0.05e-18, 0.015e-18, 0.015e-18,    &
       0.02e-18, 0.004e-18, 0.0006e-18, 0.00006e-18/

!sigmas(6,*):
  data PhotoIon_OPlus2P/                                                  &
       29 * 0.00, 0.50e-18, 2.93e-18, 2.93e-18, 3.06e-18,               &
       3.09e-18, 3.16e-18, 3.15e-18, 3.10e-18, 3.14e-18, 3.04e-18,      &
       3.48e-18, 3.28e-18, 3.38e-18, 2.95e-18, 2.93e-18, 2.92e-18,      &
       2.58e-18, 2.71e-18, 2.42e-18, 2.07e-18, 1.13e-18, 0.62e-18,      &
       0.22e-18, 0.06e-18, 0.02e-18, 0.02e-18, 0.03e-18, 0.004e-18,     &
       0.0007e-18, 0.00007e-18/


! lambdas:

! wleuv1
  data EUV_WaveLength_1 /                                               &
       1000.00, 1031.91, 1025.72,  950.00,  977.02,  900.00,            &
       850.00 ,  800.00,  750.00,  789.36,  770.41,  765.15,            &
       700.00 ,  703.36,  650.00,  600.00,  629.73,  609.76,            &
       550.00 ,  584.33,  554.31,  500.00,  450.00,  465.22,            &
       400.00 ,  350.00,  368.07,  300.00,  303.78,  303.31,            &
       250.00 ,  284.15,  256.30,  200.00,  150.00,  100.00,            &
       50.00  /


! wleuv2
  data  EUV_WaveLength_2/                                               &
       1050.00, 1031.91, 1025.72, 1000.00,  977.02,  950.00,            &
       900.00 ,  850.00,  800.00,  789.36,  770.41,  765.15,            &
       750.00 ,  703.36,  700.00,  650.00,  629.73,  609.76,            &
       600.00 ,  584.33,  554.31,  550.00,  500.00,  465.22,            &
       450.00 ,  400.00,  368.07,  350.00,  303.78,  303.31,            &
       300.00 ,  284.15,  256.30,  250.00,  200.00,  150.00,            &
       100.00 /

! sigao
  data Photoabsorption_O /                                          &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 1.32e-18,  &
       4.55e-18, 3.50e-18, 5.09e-18, 3.75e-18, 3.89e-18, 4.00e-18,  &
       1.07e-17, 1.15e-17, 1.72e-17, 1.34e-17, 1.34e-17, 1.34e-17,  &
       1.30e-17, 1.31e-17, 1.26e-17, 1.21e-17, 1.21e-17, 1.19e-17,  &
       1.15e-17, 9.69e-18, 9.84e-18, 8.69e-18, 7.70e-18, 7.68e-18,  &
       6.46e-18, 7.08e-18, 6.05e-18, 5.20e-18, 3.73e-18, 1.84e-18,  &
       7.30e-19/

! sigao2
  data Photoabsorption_O2 /                                         &
       1.35e-18, 1.00e-18, 1.63e-18, 2.11e-17, 1.87e-17, 1.28e-17,  &
       8.56e-18, 1.66e-17, 2.21e-17, 2.67e-17, 1.89e-17, 2.08e-17,  &
       2.85e-17, 2.74e-17, 2.19e-17, 2.60e-17, 3.21e-17, 2.81e-17,  &
       2.66e-17, 2.28e-17, 2.60e-17, 2.46e-17, 2.31e-17, 2.19e-17,  &
       2.03e-17, 1.81e-17, 1.83e-17, 1.74e-17, 1.68e-17, 1.68e-17,  &
       1.44e-17, 1.58e-17, 1.34e-17, 1.09e-17, 7.51e-18, 3.81e-18,  &
       1.32e-18/

! sigan2
  data Photoabsorption_N2 /                                         &
       0.00e+00, 0.00e+00, 0.00e+00, 5.10e-17, 2.24e-18, 9.68e-18,  &
       2.02e-17, 1.70e-17, 3.36e-17, 1.65e-17, 1.42e-17, 1.20e-16,  &
       2.47e-17, 2.65e-17, 3.18e-17, 2.33e-17, 2.34e-17, 2.28e-17,  &
       2.28e-17, 2.24e-17, 2.41e-17, 2.45e-17, 2.35e-17, 2.32e-17,  &
       2.17e-17, 1.64e-17, 1.69e-17, 1.39e-17, 1.17e-17, 1.17e-17,  &
       1.05e-17, 1.09e-17, 1.02e-17, 8.39e-18, 4.96e-18, 2.26e-18,  &
       7.20e-19/

! sigeuv(1,*):
  data PhotoAbs_O2 /                                                  &
        0.50e-18, 1.50e-18, 3.40e-18, 6.00e-18,10.00e-18,13.00e-18, &
       15.00e-18,12.00e-18, 2.20e-18, 0.30e-18, 3.00e-18, 0.01e-18, &
        0.30e-18, 0.10e-18, 1.00e-18, 1.10e-18, 1.00e-18, 1.60e-18, &
       16.53e-18, 4.00e-18,15.54e-18, 9.85e-18,20.87e-18,27.09e-18, &
       26.66e-18,25.18e-18,21.96e-18,29.05e-18,25.00e-18,26.27e-18, &
       26.02e-18,25.80e-18,26.10e-18,25.04e-18,22.00e-18,25.59e-18, &
       24.06e-18,21.59e-18,20.40e-18,19.39e-18,18.17e-18,18.40e-18, &
       17.19e-18,16.80e-18,16.80e-18,15.10e-18,15.70e-18,13.20e-18, &
       10.60e-18, 7.10e-18, 4.00e-18, 1.18e-18, 0.32e-18, 0.10e-18, &
        1.02e-18, 0.14e-18, .024e-18, .004e-18, .0004e-18/

! sigaco2:
  data PhotoAbsorption_CO2 /                                                  &
       18.24e-18, 14.2e-18, 15.1e-18, 50.31e-18, 42.87e-18, 52.08e-18, 44.67e-18, &
       13.98e-18, 39.83e-18, 26.49e-18, 61.94e-18, 93.84e-18, 32.83e-18, 23.52e-18, &
       33.70e-18, 34.45e-18, 34.3e-18, 35.30e-18, 34.91e-18, 34.2e-18, 33.20e-18, 31.49e-18, &
       30.25e-18, 292.52e-18, 28.27e-18, 24.87e-18, 25.27e-18, 23.57e-18, 21.59e-18, 21.49e-18, &
       17.52e-18, 19.02e-18, 16.50e-18, 14.36e-18, 9.09e-18, 4.61e-18, 1.55e-18/
!

! sigaco2 (t>=295K)
!data PhotoAbs_CO2_295 /                                  &
!     0.016e-18, 0.048e-18, 0.126e-18, 0.258e-18, 0.431e-18, 0.544e-18,   &
!     0.524e-18, 0.607e-18, 0.739e-18, 0.373e-18, 0.081e-18, 0.0496e-18,  &
!     0.882e-18, 40.80e-18, 17.40e-18, 18.24e-18, 14.20e-18, 15.10e-18,   &
!     50.31e-18, 42.87e-18, 52.08e-18, 44.67e-18, 13.98e-18, 39.83e-18,   &
!     26.49e-18, 61.94e-18, 93.84e-18, 32.83e-18, 23.52e-18, 33.70e-18,   &
!     34.45e-18, 34.30e-18, 35.30e-18, 34.91e-18, 34.20e-18, 33.20e-18,   &
!     31.49e-18, 30.25e-18, 29.53e-18, 28.27e-18, 24.87e-18, 25.27e-18,   &
!     23.57e-18, 21.59e-18, 21.49e-18, 17.52e-18, 19.02e-18, 16.51e-18,   &
!     14.36e-18,  9.09e-18,  4.62e-18,  1.55e-18, 0.358e-18, 0.358e-18,   &
!     0.358e-18, 0.358e-18, 0.358e-18, 0.358e-18, 0.358e-18 /
data PhotoAbs_CO2 /                                  &
      0.016e-18, 0.048e-18, 0.126e-18, 0.258e-18, 0.431e-18, 0.544e-18,   &
      0.524e-18, 0.607e-18, 0.739e-18, 0.373e-18, 0.081e-18, 0.0496e-18,  &
      0.882e-18, 40.80e-18, 17.40e-18, 18.24e-18, 14.20e-18, 15.10e-18,   &
      50.31e-18, 42.87e-18, 52.08e-18, 44.67e-18, 13.98e-18, 39.83e-18,   &
      26.49e-18, 61.94e-18, 93.84e-18, 32.83e-18, 23.52e-18, 33.70e-18,   &
      34.45e-18, 34.30e-18, 35.30e-18, 34.91e-18, 34.20e-18, 33.20e-18,   &
      31.49e-18, 30.25e-18, 29.53e-18, 28.27e-18, 24.87e-18, 25.27e-18,   &
      23.57e-18, 21.59e-18, 21.49e-18, 17.52e-18, 19.02e-18, 16.51e-18,   &
      14.36e-18,  9.09e-18,  4.62e-18,  1.55e-18, 0.358e-18, 0.358e-18,   &
     0.358e-18, 0.358e-18, 0.358e-18, 0.0, 0.358e-18 /  ! speed issues w/ #58!!!!

!! sigaco2 (t<=195K)
!  data PhotoAbs_CO2_195 /                                  &
!       0.010e-18, 0.035e-18, 0.100e-18, 0.222e-18, 0.392e-18, 0.518e-18,   &
!       0.515e-18, 0.578e-18, 0.664e-18, 0.336e-18, 0.071e-18, 0.0433e-18,  &
!       0.882e-18, 40.80e-18, 17.40e-18, 18.24e-18, 14.20e-18, 15.10e-18,   &
!       50.31e-18, 42.87e-18, 52.08e-18, 44.67e-18, 13.98e-18, 39.83e-18,   &
!       26.49e-18, 61.94e-18, 93.84e-18, 32.83e-18, 23.52e-18, 33.70e-18,   &
!       34.45e-18, 34.30e-18, 35.30e-18, 34.91e-18, 34.20e-18, 33.20e-18,   &
!       31.49e-18, 30.25e-18, 29.53e-18, 28.27e-18, 24.87e-18, 25.27e-18,   &
!       23.57e-18, 21.59e-18, 21.49e-18, 17.52e-18, 19.02e-18, 16.51e-18,   &
!       14.36e-18,  9.09e-18,  4.62e-18,  1.55e-18, 0.358e-18, 0.358e-18,   &
!       0.358e-18, 0.358e-18, 0.358e-18, 0.358e-18, 0.358e-18/

 ! sigaco:
   data PhotoAbsorption_CO /                                                  &
        8.57e-18, 1.39e-18, 1.39e-18, 52.83e-18, 28.50e-18, 50.32e-18, 36.98e-18, 22.61e-18, &
        20.54e-18, 33.13e-18, 15.26e-18, 26.28e-18, 25.20e-18, 23.85e-18, 21.04e-18, &
        21.92e-18, 22.03e-18, 22.1e-18, 21.91e-18, 22.0e-18, 21.62e-18, 21.09e-18, 20.57e-18, &
        20.17e-18, 17.96e-18, 14.96e-18, 15.26e-18, 13.44e-18, 11.90e-18, 11.87e-18, 9.42e-18, &
        10.54e-18, 8.61e-18, 7.01e-18, 4.67e-18, 2.39e-18, 0.87e-18 /

 ! sigaco: estimates by S. W. Bougher (11-09-21)
   data PhotoAbs_CO /                                                  &
        15 * 0.00,                                                     &
        8.57e-18, 1.39e-18, 1.39e-18, 52.83e-18, 28.50e-18, 50.32e-18, 36.98e-18, 22.61e-18, &
        20.54e-18, 33.13e-18, 15.26e-18, 26.28e-18, 25.20e-18, 23.85e-18, 21.04e-18, &
        21.92e-18, 22.03e-18, 22.1e-18, 21.91e-18, 22.0e-18, 21.62e-18, 21.09e-18, 20.57e-18, &
        20.17e-18, 17.96e-18, 14.96e-18, 15.26e-18, 13.44e-18, 11.90e-18, 11.87e-18, 9.42e-18, &
        10.54e-18, 8.61e-18, 7.01e-18, 4.67e-18, 2.39e-18, 0.87e-18,   &
        5 * 0.417e-18,0.417e-20, 0.417e-18 /

! sigeuv(2,*):
  data PhotoAbs_O /                                                   &
       18 * 0.00,                                                   &
       0.00, 0.00, 2.12e-18, 4.18e-18, 4.38e-18, 4.23e-18,          &
        4.28e-18, 4.18e-18, 4.18e-18, 8.00e-18,11.35e-18,10.04e-18, &
       12.21e-18,12.22e-18,12.23e-18,11.90e-18,12.17e-18,12.13e-18, &
       11.91e-18,11.64e-18,11.25e-18,11.21e-18, 9.64e-18, 9.95e-18, &
        8.67e-18, 7.70e-18, 7.68e-18, 6.61e-18, 7.13e-18, 6.05e-18, &
        5.30e-18, 2.90e-18, 1.60e-18, 0.59e-18, 0.16e-18, 0.05e-18, &
        0.51e-18, 0.07e-18, .012e-18, .002e-18, .0002e-18/

! sigeuv(3,*):
  data PhotoAbs_N2 /                                                  &
       18 * 0.00,                                                   &
       36.16e-18, 0.70e-18,16.99e-18,46.63e-18,15.05e-18,30.71e-18, &
       19.26e-18,26.88e-18,35.46e-18,30.94e-18,26.30e-18,29.75e-18, &
       23.22e-18,23.20e-18,23.10e-18,22.38e-18,23.20e-18,24.69e-18, &
       24.53e-18,21.85e-18,21.80e-18,21.07e-18,17.51e-18,18.00e-18, &
       13.00e-18,11.60e-18,11.60e-18,10.30e-18,10.60e-18, 9.70e-18, &
        8.00e-18, 4.40e-18, 1.90e-18, 0.60e-18, 0.24e-18, 1.16e-18, &
        0.48e-18, 0.09e-18, .015e-18, .003e-18, .0003e-18/

!! CH4 Cross-Secitons Jared Bell 01-23-2009
  data PhotoAbs_CH4 /                                          &
       0.000e-18, 0.000e-18, 0.000e-18, 7.000e-24, 1.400e-23, 7.990e-22,    &
       1.26e-19, 3.2898e-18,12.826e-18,19.068e-18,18.318e-18,17.860e-18,    & 
      19.200e-18,18.000e-18,28.400e-18,29.108e-18,30.121e-18,32.700e-18,    &
      38.192e-18,41.154e-18,48.001e-18,48.968e-18,48.327e-18,45.921e-18,    &
      46.472e-18,45.716e-18,45.458e-18,42.927e-18,41.069e-18,39.280e-18,    &
      34.990e-18,35.276e-18,33.178e-18,30.697e-18,31.052e-18,27.924e-18,    &
      24.644e-18,21.449e-18,18.770e-18,14.701e-18, 9.776e-18,10.165e-18,    &
       7.829e-18, 6.059e-18, 6.033e-18, 4.360e-18, 5.053e-18, 3.857e-18,    &
       2.794e-18, 1.496e-18, 5.930e-19, 2.040e-19, 4.535e-19, 4.210e-19,    &
       1.643e-19, 0.000e-18, 0.000e-18, 0.000e-18, 0.000e-18/            

!! H2 Cross-Secitons Jared Bell 01-23-2009
  data PhotoAbs_H2 /                                           &
       0.e-18,0.e-18,0.e-18,0.e-18,0.e-18,0.e-18,                     &
       0.e-18,0.e-18,0.e-18,0.e-18,0.e-18,0.e-18,                     &
       0.e-18,0.e-18,0.e-18,0.e-18,0.e-18,0.e-18,                     &
       0.05e-18, 0.00e-18, 0.19e-18, 0.48e-18, 8.25e-18, 8.75e-18,    &
       7.34e-18, 8.64e-18,10.76e-18,11.37e-18,10.73e-18, 9.90e-18,    &
       8.45e-18, 8.46e-18, 7.81e-18, 6.86e-18, 7.02e-18, 6.17e-18,    &
       5.36e-18, 4.50e-18, 3.87e-18, 3.03e-18, 1.90e-18, 1.94e-18,    &
       1.42e-18, 1.02e-18, 1.02e-18, 0.73e-18, 0.84e-18, 0.60e-18,    &
       0.43e-18, 0.21e-18, 0.08e-18, 0.01e-18, 0.00e-18, 0.00e-18,    &
       0.00e-18, 0.00e-18, 0.00e-18, 0.00e-18, 0.00e-18/
!
  data PhotoIon_CH4 /                                          &
       0.00e-18, 0.00e-18, 0.00e-18, 0.00e-18, 0.00e-18, 0.00e-18,    &
       0.00e-18, 0.00e-18, 0.00e-18, 0.00e-18, 0.00e-18, 0.00e-18,    &
       0.00e-18, 0.00e-18, 0.00e-18, 0.00e-18, 0.00e-18, 0.00e-18,    &
       0.48e-18, 0.14e-18,13.86e-18,25.53e-18,40.28e-18,44.69e-18,    &
      44.61e-18,44.80e-18,44.80e-18,42.93e-18,41.07e-18,39.28e-18,    &
      34.99e-18,35.28e-18,33.18e-18,30.70e-18,31.05e-18,27.92e-18,    &
      24.64e-18,21.45e-18,18.77e-18,14.70e-18, 9.78e-18,10.17e-18,    &
       7.83e-18, 6.06e-18, 6.03e-18, 4.36e-18, 5.05e-18, 3.86e-18,    &
       2.79e-18, 1.50e-18, 0.59e-18, 0.20e-18, 0.00e-18, 0.00e-18,    &
       0.00e-18, 0.00e-18, 0.00e-18, 0.00e-18, 0.00e-18/     
!
!
  data PhotoIon_H2 /                                          &
       0.e-18,0.e-18,0.e-18,0.e-18,0.e-18,0.e-18,                    &
       0.e-18,0.e-18,0.e-18,0.e-18,0.e-18,0.e-18,                    &
       0.e-18,0.e-18,0.e-18,0.e-18,0.e-18,0.e-18,                    &
       0.00e-18, 0.00e-18, 0.00e-18, 0.00e-18, 0.09e-18, 6.63e-18,   &
       5.07e-18, 7.07e-18, 8.62e-18, 9.76e-18,10.73e-18, 9.70e-18,   &
       8.29e-18, 8.30e-18, 7.67e-18, 6.74e-18, 6.90e-18, 6.05e-18,   &
       5.25e-18, 4.05e-18, 3.78e-18, 2.89e-18, 1.74e-18, 1.78e-18,   &
       1.30e-18, 0.90e-18, 0.90e-18, 0.65e-18, 0.75e-18, 0.55e-18,   &
       0.40e-18, 0.20e-18, 0.08e-18, 0.01e-18, 0.00e-18, 0.00e-18,   &
       0.00e-18, 0.00e-18, 0.00e-18, 0.00e-18, 0.00e-18/


! sigio
  data Photoionization_O /                                          &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 1.32e-18,  &
       4.55e-18, 3.50e-18, 5.09e-18, 3.75e-18, 3.89e-18, 4.00e-18,  &
       1.07e-17, 1.15e-17, 1.72e-17, 1.34e-17, 1.34e-17, 1.34e-17,  &
       1.30e-17, 1.31e-17, 1.26e-17, 1.21e-17, 1.21e-17, 1.19e-17,  &
       1.15e-17, 9.69e-18, 9.84e-18, 8.69e-18, 7.70e-18, 7.68e-18,  &
       6.46e-18, 7.08e-18, 6.05e-18, 5.20e-18, 3.73e-18, 1.84e-18,  &
       7.30e-19/

! sigio2
  data Photoionization_O2 /                                         &
       2.59e-19, 0.00e+00, 1.05e-18, 1.39e-17, 1.55e-17, 9.37e-18,  &
       5.49e-18, 6.41e-18, 1.06e-17, 1.02e-17, 8.47e-18, 1.17e-17,  &
       2.38e-17, 2.38e-17, 2.13e-17, 2.49e-17, 3.11e-17, 2.64e-17,  &
       2.66e-17, 2.28e-17, 2.60e-17, 2.46e-17, 2.31e-17, 2.19e-17,  &
       2.03e-17, 1.81e-17, 1.83e-17, 1.74e-17, 1.68e-17, 1.68e-17,  &
       1.44e-17, 1.58e-17, 1.34e-17, 1.09e-17, 7.51e-18, 3.81e-18,  &
       1.32e-18/


! sigin2
  data Photoionization_N2 /                                         &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00, 1.43e-17, 8.86e-18, 8.50e-18, 6.58e-17,  &
       1.51e-17, 2.55e-17, 2.92e-17, 2.33e-17, 2.34e-17, 2.28e-17,  &
       2.28e-17, 2.24e-17, 2.41e-17, 2.45e-17, 2.35e-17, 2.32e-17,  &
       2.17e-17, 1.64e-17, 1.69e-17, 1.39e-17, 1.17e-17, 1.17e-17,  &
       1.05e-17, 1.09e-17, 1.02e-17, 8.39e-18, 4.96e-18, 2.26e-18,  &
       7.20e-19/

! sigin
  data Photoionization_N /                                          &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.21e-18,10.29e-18,11.71e-18,10.96e-18,11.24e-18,11.32e-18,  &
       12.10e-18,13.26e-18,12.42e-18,11.95e-18,11.21e-18,11.80e-18, &
       11.76e-18,11.78e-18,11.77e-18,11.50e-18,11.02e-18,10.58e-18, &
       9.56e-18, 8.15e-18, 8.30e-18, 7.30e-18, 6.41e-18, 6.40e-18,  &
       5.24e-18, 5.73e-18, 4.87e-18, 3.95e-18, 2.49e-18, 0.99e-18,  &
       0.33e-18/

! O 4S
! brop4s
  data BranchingRatio_OPlus4S /                                     &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 1.00e+00,  &
       1.00e+00, 1.00e+00, 1.00e+00, 1.00e+00, 1.00e+00, 1.00e+00,  &
       6.30e-01, 4.30e-01, 3.00e-01, 3.20e-01, 2.90e-01, 2.70e-01,  &
       2.80e-01, 3.00e-01, 2.90e-01, 2.80e-01, 2.80e-01, 2.80e-01,  &
       2.70e-01, 2.60e-01, 2.60e-01, 2.60e-01, 2.50e-01, 2.50e-01,  &
       2.50e-01, 2.50e-01, 2.50e-01, 2.60e-01, 2.70e-01, 2.90e-01,  &
       3.00e-01/

! sigico2 total
  data Photoionization_CO2 /                                          &
       0.0e-18, 0.0e-18, 0.0e-18, 0.0e-18, 0.0e-18, 0.0e-18, 7.14e-18,&
       10.93e-18, 34.09e-18, 21.68e-18, 51.77e-18, 86.32e-18, &
       27.49e-18, 20.86e-18, 32.29e-18, 34.57e-18, 34.3e-18, &
       35.30e-18, 34.96e-18, 33.86e-18, 33.21e-18, 32.602e-18, 30.68e-18, &
       28.76e-18, 27.17e-18, 25.52e-18, 25.56e-18, 23.63e-18, 21.44e-18, &
       21.39e-18, 17.14e-18, 18.60e-18, 16.11e-18, 14.32e-18, 9.09e-18, &
       4.62e-18, 1.55e-18/

!  sigico total
   data Photoionization_CO /                                          &
        0.00e-18, 0.00e-18, 0.00e-18, 0.00e-18, 0.00e-18, 0.00e-18, 11.70e-18, &
        17.56e-18, 11.38e-18, 17.35e-18, 9.88e-18, 13.03e-18, 21.08e-18, &
        22.12e-18, 20.10e-18, 21.85e-18, 22.03e-18, 21.92e-18, 21.90e-18, &
        22.00e-18, 21.62e-18, 21.09e-18, 20.57e-18, 20.17e-18, 17.96e-18, &
        14.96e-18, 15.26e-18, 13.44e-18, 11.90e-18, 11.87e-18, 9.42e-18, &
        10.54e-18, 8.61e-18, 7.01e-18, 4.67e-18, 2.39e-18, 0.87e-18 /

! O 2D
! brop2d
  data BranchingRatio_OPlus2D /                                     &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,  &
       3.70e-01, 5.70e-01, 6.60e-01, 4.60e-01, 4.70e-01, 4.60e-01,  &
       4.50e-01, 4.60e-01, 4.50e-01, 4.50e-01, 4.50e-01, 4.50e-01,  &
       4.30e-01, 4.00e-01, 4.00e-01, 4.00e-01, 3.70e-01, 3.70e-01,  &
       3.60e-01, 3.70e-01, 3.50e-01, 3.50e-01, 3.30e-01, 3.20e-01,  &
       3.20e-01/
! O 2P
! brop2p
!     data BranchingRatio_OPlus2P
!    +     /0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,
!    +      0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,
!    +      0.00e+00, 0.00e+00, 4.00e-02, 2.20e-01, 2.40e-01, 2.70e-01,
!    +      2.70e-01, 2.40e-01, 2.60e-01, 2.70e-01, 2.70e-01, 2.70e-01,
!    +      2.60e-01, 2.50e-01, 2.60e-01, 2.50e-01, 2.50e-01, 2.50e-01,
!    +      2.30e-01, 2.30e-01, 2.30e-01, 2.20e-01, 2.20e-01, 2.10e-01,
!    +      2.10e-01/

! N2 -> N+
! brn2np
  data BranchingRatio_N2_to_NPlus /                                 &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00, 0.00e+00, 1.30e-03, 3.00e-02, 4.60e-02,  &
       4.50e-02, 1.05e-01, 9.00e-02, 1.63e-01, 2.13e-01, 2.13e-01,  &
       3.00e-01, 2.57e-01, 3.35e-01, 3.77e-01, 3.64e-01, 3.46e-01,  &
       3.85e-01/

! O2 -> O+
! bro2op
  data  BranchingRatio_O2_to_OPlus/                                 &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00, 8.91e-03, 3.86e-02, 3.31e-02, 7.01e-02,  &
       1.44e-01, 1.71e-01, 1.71e-01, 2.08e-01, 2.31e-01, 2.25e-01,  &
       2.37e-01, 2.59e-01, 2.49e-01, 2.99e-01, 3.53e-01, 3.53e-01,  &
       3.71e-01, 3.73e-01, 3.66e-01, 3.93e-01, 4.48e-01, 3.84e-01,  &
       0.00e+00/


!! Quantum Yields Used at Titan (Again Relative to the Absolute Absorption
!! Cross-Section, so do not use these with PhotoDis, only with PhotoAbs

!\
! N2 + hv ---> N(4S) + N(2D) 
!/
  data QuantumYield_N2_N4S /                                      &
       15 * 0.00,                                                   &
       0.00e+00, 0.00e+00, 0.00e+00, 1.00e+00, 1.00e+00, 1.00e+00,  &
       1.00e+00, 1.00e+00, 5.749e-01, 4.626e-01, 4.006e-01, 4.539e-01,  &
       3.893e-01, 3.990e-02, 7.940e-02, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00/
!\
! N2 + hv ---> N+ + N(4S) + e-
!/
  data QuantumYield_N2_NPlus /                                      &
       15 * 0.00,                                                   &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00, 0.00e+00, 1.300e-03, 2.980e-02, 4.580e-02,  &
       4.530e-02, 1.053e-01, 9.230e-02, 1.629e-01, 2.128e-01, 2.134e-01,  &
       2.997e-01, 2.569e-01, 3.350e-01, 3.773e-01, 3.641e-01, 3.459e-01,  &
       3.847e-01, 5.360e-01, 8.150e-01, 7.320e-01, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00/

!\
! N2 + hv ---> N2+ + e- 
!/
  data QuantumYield_N2_N2Plus /                                      &
       15 * 0.00,                                                   &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00, 4.251e-01, 5.374e-01, 5.994e-01, 5.461e-01,  &
       6.107e-01, 9.601e-01, 9.206e-01, 1.000e+00, 1.000e+00, 1.000e+00,  &
       1.000e+00, 1.000e+00, 1.000e+00, 9.987e-01, 9.702e-01, 9.542e-01,  &
       9.546e-01, 8.947e-01, 9.077e-01, 8.371e-01, 7.872e-01, 7.866e-01,  &
       7.002e-01, 7.431e-01, 6.642e-01, 6.227e-01, 6.359e-01, 6.541e-01,  &
       6.153e-01, 4.350e-01, 1.510e-02, 1.510e-01, 0.000e+00, 0.000e+00,  &
       0.00e+00, 0.00e+00/
!\
! CH4 + hv ---> CH3 + H 
!/
  data QuantumYield_CH4_CH3    /                                 &
       1.00e+00, 1.00e+00, 1.00e+00,                                &
       1.00e+00, 1.00e+00, 1.00e+00, 1.00e+00, 1.00e+00, 1.00e+00,  &
       1.00e+00, 1.00e+00, 4.10e-01, 1.00e+00, 1.00e+00, 1.00e+00,  &
       1.00e+00, 1.00e+00, 1.00e+00, 9.876e-01, 9.967e-01, 7.112e-01,  &
       4.787e-01, 1.664e-01, 2.67e-02, 4.01e-02, 2.01e-02, 1.45e-02,  &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00/

!\
! CH4 + hv ---> 3CH2 + H2 
!/
  data QuantumYield_CH4_3CH2    /                                 &
       0.00e+00, 0.00e+00, 0.00e+00,                                &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00, 2.10e-01, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00/
!\
! CH4 + hv ---> 1CH2 + H2 
!/
  data QuantumYield_CH4_1CH2    /                                 &
       0.00e+00, 0.00e+00, 0.00e+00,                                &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00, 2.80e-01, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00/

!\
! CH4 + hv ---> 1CH + H3 
!/
  data QuantumYield_CH4_CH    /                                 &
       0.00e+00, 0.00e+00, 0.00e+00,                                &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00, 1.00e-01, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00/
!\
! CH4 + hv ---> CH3+ + H + e- 
!/
  data QuantumYield_CH4_CH3Plus    /                                 &
       15*0.00,                                                     &
       0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00, 0.00e+00,  &
       2.640e-02, 3.032e-01, 4.605e-01, 4.497e-01, 4.663e-01, 4.716e-01,  &
       4.857e-01, 4.892e-01, 4.905e-01, 4.979e-01, 4.959e-01, 5.039e-01,  &
       5.008e-01, 4.992e-01, 4.961e-01, 4.859e-01, 4.761e-01, 4.676e-01,  &
       4.471e-01, 4.195e-01, 4.235e-01, 3.970e-01, 3.799e-01, 3.791e-01,  &
       3.472e-01, 3.610e-01, 3.345e-01, 3.164e-01, 2.734e-01, 2.563e-01,  &
       2.549e-01, 5.835e-01, 6.684e-01, 6.875e-01, 0.00e+00, 0.00e+00,  &
       0.00e+00, 0.00e+00/

!
!------ F74113 reference spectrum (doubled below 150-250 A, tripled <150)
!------ Will be multiplied by 1.0E9 later
!

  data F74113  /                                                   &
       1.200,0.450,4.800,3.100,0.460,0.210,1.679,0.800,6.900,      &
       0.965,0.650,0.314,0.383,0.290,0.285,0.452,0.720,1.270,      &
       0.357,0.530,1.590,0.342,0.230,0.360,0.141,0.170,0.260,      &
       0.702,0.758,1.625,3.537,3.000,4.400,1.475,3.500,2.100,      &
       2.467   /

!
!--- Scaling factors(Ai) for the EUV flux
!

  data AFAC /                                                      &
       1.0017E-02,7.1250E-03,1.3375E-02,1.9450E-02,2.7750E-03,     &
       1.3768E-01,2.6467E-02,2.5000E-02,3.3333E-03,2.2450E-02,     &
       6.5917E-03,3.6542E-02,7.4083E-03,7.4917E-03,2.0225E-02,     &
       8.7583E-03,3.2667E-03,5.1583E-03,3.6583E-03,1.6175E-02,     &
       3.3250E-03,1.1800E-02,4.2667E-03,3.0417E-03,4.7500E-03,     &
       3.8500E-03,1.2808E-02,3.2750E-03,4.7667E-03,4.8167E-03,     &
       5.6750E-03,4.9833E-03,3.9417E-03,4.4167E-03,5.1833E-03,     &
       5.2833E-03,4.3750E-03 /


  data WAVEL/                                                      &
       1750.00, 1700.00, 1650.00, 1600.00, 1550.00, 1500.00,       &
       1450.00, 1400.00, 1350.00, 1300.00, 1250.00, 1215.67,       &
       1200.00, 1150.00, 1100.00, 1050.00, 1031.91, 1025.72,       &
       1000.00,  977.02,  950.00,  900.00,  850.00,  800.00,       &
       789.36,  770.41,  765.15,  750.00,  703.31,  700.00,        &
       650.00,  629.73,  609.76,  600.00,  584.33,  554.37,        &
       550.00,  500.00,  465.22,  450.00,  400.00,  368.07,        &
       350.00,  303.78,  303.31,  300.00,  284.15,  256.30,        &
       250.00,  200.00,  150.00,  100.00,   50.00,   32.00,        &
       23.00,   16.00,    8.00,    4.00,    2.00/

  data WAVES/                                                      &
       1700.00, 1650.00, 1600.00, 1550.00, 1500.00, 1450.00,       &
       1400.00, 1350.00, 1300.00, 1250.00, 1200.00, 1215.67,       &
       1150.00, 1100.00, 1050.00, 1000.00, 1031.91, 1025.72,       &
       950.00,  977.02,  900.00,  850.00,  800.00,  750.00,        &
       789.36,  770.41,  765.15,  700.00,  703.31,  650.00,        &
       600.00,  629.73,  609.76,  550.00,  584.33,  554.37,        &
       500.00,  450.00,  465.22,  400.00,  350.00,  368.07,        &
       300.00,  303.78,  303.31,  250.00,  284.15,  256.30,        &
       200.00,  150.00,  100.00,   50.00,   32.00,   23.00,        &
       16.00,    8.00,    4.00,    2.00,    1.00/

  data RFLUX/                                                      &
       322.00,  168.00,   95.00,   62.00,   44.00,   25.00,        &
       16.90,   11.80,   19.50,    4.10,   11.10,  249.00,         &
       2.78,    0.70,    3.07,    3.64,    3.18,    4.38,          &
       1.78,    5.96,    4.22,    4.43,    1.93,    0.87,          &
       0.79,    0.24,    0.20,    0.17,    0.39,    0.22,          &
       0.17,    1.50,    0.45,    0.48,    1.58,    0.80,          &
       0.51,    0.31,    0.18,    0.39,    0.21,    0.74,          &
       0.87,    6.00,    0.24,    0.84,    0.10,    0.27,          &
       0.92,    1.84,    0.13,    0.38,  0.0215,  0.0067,          &
       1.E-3,   2.E-3,   1.E-5,   5.E-8,   1.E-10/

  data XFLUX/                                                      &
       354.00,  191.00,  110.00,   76.00,   55.00,   28.00,        &
       19.60,   14.30,   25.30,    5.00,   17.20,  401.00,         &
       6.26,    1.51,    6.11,    8.66,    9.04,   13.12,          &
       4.42,   13.18,   12.03,   13.29,    5.01,    2.18,          &
       1.59,    0.67,    0.43,    0.43,    0.72,    0.46,          &
       0.48,    3.02,    1.46,    1.02,    4.86,    1.59,          &
       1.57,    1.67,    0.36,    0.99,    2.20,    1.39,          &
       5.63,   11.28,    2.50,    4.14,    3.16,    0.59,          &
       3.70,    4.85,    0.34,    1.15,    0.18,    0.08,          &
       2.5E-2,   5.E-2,   8.E-4,   3.E-5,   5.E-7/

  data SCALE1/                                                     &
       0.0,     0.0,     0.0,     0.0,     0.0,     0.0,           &
       0.0,     0.0,     0.0,     0.0,     0.0,     0.0,           &  
       1692.09,  405.95, 1516.20, 2731.70, 3314.57, 4375.00,       &
       1316.91, 3621.91, 3908.56, 4432.54, 1541.21,  531.73,       &
       364.83,    0.00,  116.00,  129.41,  162.48,   94.07,        &
       41.29,  709.50,    0.00,  268.47, 1561.05,  367.64,         &
       290.06,  184.36,    0.00,   86.15,    7.50,    0.00,        &
       0.00, 2220.00,    0.00,   61.00,    0.00,   86.95,          &
       206.00,  135.89,   60.35,  157.12,    7.06,    0.75,        &
       0.00,    0.00,    0.00,    0.00,    0.00/

  data SCALE2/                                                     &
       0.00,    0.00,    0.00,    0.00,    0.00,    0.00,          &
       0.00,    0.00,    0.00,    0.00,    0.00,    0.00,          &
       0.00,    0.00,    0.00,    0.00,    0.00,    0.00,          &
       0.00,    0.00,    0.00,    0.00,    0.00,    0.00,          &
       0.00,    5.34,    0.00,    0.00,    0.00,    0.54,          &
       3.30,    0.00,   12.60,    0.00,    0.00,    0.00,          &
       5.34,   11.63,    2.28,    5.56,   24.93,    8.16,          &
       60.69,    0.00,   28.20,   45.90,   40.80,    1.27,         &
       35.47,   42.80,    1.12,    6.19,    1.26,    0.69,         &
       0.23,    0.46,  7.6E-3,  2.9E-4,  4.8E-6/

  data TCHR0/                                                              &
       0.0,       0.0,       0.0,       0.0,       0.0,       0.0,        &
       0.0,       0.0,       0.0,       0.0,       0.0,       0.0,         &
       0.0,       0.0,       0.0,-4.290E+00,-5.709E+00,-8.493E+00,         &
       -1.161E+00,-3.429E+00,-5.464E+00,-6.502E+00,-1.912E+00,-4.034E-01,  &
       -1.448E-01, 0.000E+00,-9.702E-02,-6.591E-02,-2.338E-02,-1.273E-01,  &
       -2.406E-01,-3.351E-01, 0.000E+00,-1.465E+00,-2.405E+00,-7.975E-02,  &
       -4.197E-01,-1.971E-01, 0.000E+00,-5.895E-02,-5.815E-03, 0.000E+00,  &
       0.000E+00, 2.138E-01, 0.000E+00,-7.713E-02, 0.000E+00,-3.035E-02,   &
       -2.039E-01,-1.749E-01,-1.041E-01,-2.638E-01,-1.094E-02, 0.000E+00,  &
       0.0,       0.0,       0.0,       0.0,       0.0/

  data TCHR1/                                                              &
       0.0,       0.0,       0.0,       0.0,       0.0,       0.0,         &
       0.0,       0.0,       0.0,       0.0,       0.0,       0.0,         &
       0.0,       0.0,       0.0,-3.023E-13,-3.745E-13,-5.385E-13,         &
       -1.211E-13,-3.868E-13,-3.646E-13,-4.125E-13,-1.527E-13,-4.753E-14,  &
       -3.411E-14, 0.000E+00,-1.190E-14,-1.034E-14,-1.343E-14,-1.539E-14,  &
       -5.174E-14,-6.934E-14, 0.000E+00,-1.215E-13,-1.537E-13,-2.024E-14,  &
       -4.596E-14,-1.562E-14, 0.000E+00,-1.221E-14,-1.123E-15, 0.000E+00,  &
       0.000E+00,-2.263E-13, 0.000E+00,-1.508E-14, 0.000E+00,-1.744E-14,   &
       -2.100E-14,-1.805E-14,-8.224E-15,-1.919E-14,-7.944E-16, 0.000E+00,  &
       0.0,       0.0,       0.0,       0.0,       0.0/

  data TCHR2/                                                              &
       0.0,       0.0,       0.0,       0.0,       0.0,       0.0,         &
       0.0,       0.0,       0.0,       0.0,       0.0,       0.0,         &
       0.0,       0.0,       0.0, 3.275E-11, 4.057E-11, 6.160E-11,         &
       1.312E-11, 4.189E-11, 4.167E-11, 4.716E-11, 1.654E-11, 5.150E-12,   &
       3.901E-12, 0.000E+00, 1.289E-12, 1.120E-12, 1.455E-12, 1.667E-12,   &
       5.604E-12, 7.931E-12, 0.000E+00, 1.317E-11, 1.757E-11, 2.194E-12,   &
       4.978E-12, 1.693E-12, 0.000E+00, 1.324E-12, 1.285E-13, 0.000E+00,   &
       0.000E+00, 2.586E-11, 0.000E+00, 1.724E-12, 0.000E+00, 1.889E-12,   &
       2.400E-12, 2.063E-12, 8.911E-13, 2.193E-12, 9.090E-14, 0.000E+00,   &
       0.0,       0.0,       0.0,       0.0,       0.0/

  data TCOR0/                                                              &
       0.0,       0.0,       0.0,       0.0,       0.0,       0.0,         &
       0.0,       0.0,       0.0,       0.0,       0.0,       0.0,         &
       0.0,       0.0,       0.0, 0.000E+00, 0.000E+00, 0.000E+00,         &
       0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00,-6.060E-02,   &
       0.000E+00,-3.399E-02, 0.000E+00, 0.000E+00, 0.000E+00, 4.866E-02,   &
       -1.762E-01, 0.000E+00,-2.412E-01, 0.000E+00, 0.000E+00, 0.000E+00,  &
       -4.743E-01,-9.713E-01, 5.891E-02,-1.263E-01,-1.246E+00, 2.870E-01,  &
       -4.659E+00, 0.000E+00,-1.058E+00,-3.821E+00,-1.874E+00, 0.000E+00,  &
       -1.896E+00,-8.505E-01,-2.101E-04,-2.012E-01,-6.097E-02,-2.925E-02,  &
       -4.875E-03,       0.0,       0.0,       0.0,       0.0/

  data TCOR1/                                                              &
       0.0,       0.0,       0.0,       0.0,       0.0,       0.0,         &
       0.0,       0.0,       0.0,       0.0,       0.0,       0.0,         &
       0.0,       0.0,       0.0, 0.000E+00, 0.000E+00, 0.000E+00,         &
       0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00, 2.877E-03,   &
       0.000E+00, 1.760E-03, 0.000E+00, 0.000E+00, 0.000E+00, 3.313E-04,   &
       3.643E-03, 0.000E+00, 5.225E-03, 0.000E+00, 0.000E+00, 0.000E+00,   &
       4.085E-03, 1.088E-02, 8.447E-04, 3.237E-03, 1.907E-02, 2.796E-03,   &
       4.460E-02, 0.000E+00, 1.007E-02, 3.481E-02, 1.604E-02, 0.000E+00,   &
       2.029E-02, 2.160E-02, 6.342E-04, 3.594E-03, 5.503E-04, 2.687E-04,   &
       4.479E-05,       0.0,       0.0,       0.0,       0.0/

  data TCOR2/                                                              &
       0.0,       0.0,       0.0,       0.0,       0.0,       0.0,         &
       0.0,       0.0,       0.0,       0.0,       0.0,       0.0,         &
       0.0,       0.0,       0.0, 0.000E+00, 0.000E+00, 0.000E+00,         &
       0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00, 0.000E+00, 1.846E-03,   &
       0.000E+00, 1.127E-03, 0.000E+00, 0.000E+00, 0.000E+00, 1.891E-04,   &
       2.326E-03, 0.000E+00, 2.801E-03, 0.000E+00, 0.000E+00, 0.000E+00,   &
       2.446E-03, 7.121E-03, 5.204E-04, 1.983E-03, 1.204E-02, 1.721E-03,   &
       2.911E-02, 0.000E+00, 7.177E-03, 2.272E-02, 9.436E-03, 0.000E+00,   &
       1.316E-02, 1.398E-02, 4.098E-04, 2.328E-03, 3.574E-04, 1.745E-04,   &
       2.909E-05,       0.0,       0.0,       0.0,       0.0/

  data WAR1/                                                               &
       0.00,    0.00,    0.00,    0.00,    0.00,    0.00,                  &
       0.00,    0.00,    0.00,    0.00,    0.00,    0.00,                  &
       0.00,    0.00,    3.80,    6.25,    4.93,    6.06,                  &
       2.70,    7.07,    8.62,    9.60,    4.54,    2.37,                  &
       0.82,    0.33,    0.24,    0.67,    0.28,    0.55,                  &
       1.56,    1.11,    0.77,    1.32,    1.71,    0.44,                  &
       1.11,    0.95,    0.39,    0.81,    2.00,    1.49,                  &
       6.81,    5.07,    1.63,    5.62,    2.08,    0.59,                  &
       3.89,    5.19,    0.35,    1.18,    0.099,   0.04,                  &
       0.007,   0.00,    0.00,    0.00,    0.00/
  
  data WAR2/                                                               &
       0.00,    0.00,    0.00,    0.00,    0.00,    0.00,                  &
       0.00,    0.00,    0.00,    0.00,    0.00,    0.00,                  &
       0.00,    0.00,   20.80,   17.90,    9.30,   14.30,                  &
       6.90,   12.00,   15.60,   18.60,   10.10,    4.30,                  &
       12.40,    8.00,    3.60,    1.80,    0.50,    1.40,                 &
       3.90,    2.60,    1.60,    3.40,    4.10,    0.70,                  &
       4.30,    4.30,    3.80,    2.60,    6.08,    1.35,                  &
       12.60,    9.78,    2.96,   10.20,    4.11,    6.68,                 &
       6.62,    8.07,    0.47,    1.73,    0.17,    0.075,                 &
       0.012,   0.00,    0.00,    0.00,    0.00/

  !
  ! Declaration and array constructors defining real,dim(lmax) :: 
  !   wla xco xco2 xn2 xo2 yn2i ycoi yco2i yo2i brop
  ! This file is included in vdis.F (lmax is in iflx.h).
  !

  ! Here we have a new spectrum, provided by Steve Bougher for Mars.

  data S2WaveLengths / &
       2.25000E+03, 2.20000E+03, 2.15000E+03, 2.10000E+03, 2.05000E+03, &
       2.00000E+03, 1.95000E+03, 1.92000E+03, 1.90000E+03, 1.88000E+03, &
       1.86000E+03, 1.84000E+03, 1.82000E+03, 1.80000E+03, 1.78000E+03, &
       1.76000E+03, 1.74000E+03, 1.72000E+03, 1.70000E+03, 1.68000E+03, &
       1.65000E+03, 1.60000E+03, 1.55000E+03, 1.50000E+03, 1.45000E+03, &
       1.40000E+03, 1.35000E+03, 1.30500E+03, 1.30200E+03, 1.26500E+03, &
       1.26100E+03, 1.24300E+03, 1.23900E+03, 1.21600E+03, 1.20700E+03, &
       1.17500E+03, 1.12800E+03, 1.12300E+03, 1.08500E+03, 1.03800E+03, &
       1.11800E+03, 1.02500E+03, 1.03200E+03, 1.02600E+03, 9.75000E+02, &
       9.77020E+02, 9.25000E+02, 8.75000E+02, 8.25000E+02, 7.75000E+02, &
       7.89400E+02, 7.70410E+02, 7.65150E+02, 7.25000E+02, 7.03310E+02, &
       6.75000E+02, 6.25000E+02, 6.29730E+02, 6.09760E+02, 5.75000E+02, &
       5.84330E+02, 5.54370E+02, 5.25000E+02, 4.75000E+02, 4.65220E+02, &
       4.25000E+02, 3.75000E+02, 3.68070E+02, 3.25000E+02, 3.03780E+02, &
       3.03310E+02, 2.75000E+02, 2.84150E+02, 2.56300E+02, 2.25000E+02, &
       1.75000E+02, 1.25000E+02, 7.50000E+01, 4.00000E+01, 2.40000E+01 /

  data S2PhotoAbsCO2 / &
       1.00000E-12, 1.00000E-11, 1.00000E-09, 1.00000E-08, 1.00000E-07, &
       1.30000E-06, 2.00000E-05, 6.00000E-05, 1.00000E-04, 2.00000E-04, &
       4.00000E-04, 4.50000E-04, 1.00000E-03, 2.00000E-03, 3.00000E-03, &
       5.00000E-03, 1.00000E-02, 2.00000E-02, 3.00000E-02, 4.00000E-02, &
       7.40000E-02, 1.80000E-01, 3.35000E-01, 5.40000E-01, 6.00000E-01, &
       6.30000E-01, 7.70000E-01, 7.50000E-01, 7.00000E-01, 2.80000E-01, &
       2.60000E-01, 1.50000E-01, 1.40000E-01, 7.00000E-02, 4.00000E-02, &
       1.00000E-01, 2.05000E+01, 5.95000E+01, 9.30000E+00, 6.70000E+00, &
       4.00000E+00, 2.32000E+01, 1.45000E+01, 1.51000E+01, 3.44100E+01, &
       2.99100E+01, 7.08900E+01, 4.90600E+01, 1.28400E+01, 3.18300E+01, &
       2.17900E+01, 2.65000E+01, 5.39600E+01, 2.24800E+01, 2.17600E+01, &
       2.59600E+01, 2.58800E+01, 2.58600E+01, 2.53100E+01, 3.40000E+01, &
       3.42100E+01, 3.32000E+01, 3.16100E+01, 2.92700E+01, 2.84800E+01, &
       2.75200E+01, 2.58100E+01, 2.57000E+01, 2.38800E+01, 2.34400E+01, &
       2.34400E+01, 2.00000E+01, 2.12100E+01, 1.78800E+01, 1.49800E+01, &
       1.10300E+01, 7.51000E+00, 4.42000E+00, 3.20000E-01, 3.95000E-01 /

  data S2PhotoAbsCO / &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 3.00000E-03, 1.00000E-02, 2.00000E-02, 3.00000E-02, &
       2.00000E-02, 1.00000E-02, 1.00000E-02, 1.00000E-02, 1.00000E-02, &
       1.00000E-02, 1.00000E-02, 1.00000E-02, 1.00000E-02, 1.00000E-02, &
       1.00000E-02, 1.00000E-02, 1.00000E-02, 1.00000E-02, 1.00000E-02, &
       1.00000E-02, 1.60000E+00, 5.00000E-02, 1.00000E-02, 5.29000E+01, &
       2.85000E+01, 4.94400E+01, 3.76400E+01, 2.25900E+01, 2.15500E+01, &
       3.32200E+01, 1.52600E+01, 2.62800E+01, 2.59800E+01, 2.44500E+01, &
       2.55900E+01, 1.97800E+01, 1.86000E+01, 1.84200E+01, 2.24100E+01, &
       2.25200E+01, 2.22800E+01, 2.16100E+01, 2.00900E+01, 1.99200E+01, &
       1.80100E+01, 1.56900E+01, 1.54300E+01, 1.36100E+01, 1.24700E+01, &
       1.25200E+01, 1.10100E+01, 1.17000E+01, 1.00200E+01, 8.02000E+00, &
       5.48000E+00, 3.53000E+00, 1.92000E+00, 1.35000E-01, 7.00000E-01 /

  data S2PhotoAbsO / &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 2.12000E+00, 4.18000E+00, 4.38000E+00, 4.23000E+00, &
       4.28000E+00, 4.18000E+00, 4.18000E+00, 8.00000E+00, 1.13500E+01, &
       1.00400E+01, 1.22100E+01, 1.22200E+01, 1.22300E+01, 1.19000E+01, &
       1.21700E+01, 1.21300E+01, 1.19100E+01, 1.16400E+01, 1.12500E+01, &
       1.12100E+01, 1.07000E+01, 1.08400E+01, 1.00300E+01, 9.72000E+00, &
       9.70000E+00, 8.78000E+00, 9.26000E+00, 8.43000E+00, 7.55000E+00, &
       5.96000E+00, 3.53000E+00, 1.06000E+00, 1.50000E-01, 1.98000E-01 /

  data S2PhotoAbsN2 / &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 3.61600E+01, &
       7.00000E-01, 1.69900E+01, 4.66300E+01, 1.50500E+01, 3.07100E+01, &
       1.92600E+01, 2.68800E+01, 3.54600E+01, 3.09400E+01, 2.63000E+01, &
       2.97500E+01, 2.32200E+01, 2.32000E+01, 2.31000E+01, 2.23800E+01, &
       2.32000E+01, 2.46900E+01, 2.45300E+01, 2.18500E+01, 2.18000E+01, &
       2.10700E+01, 1.75100E+01, 1.80000E+01, 1.46000E+01, 1.16000E+01, &
       1.15800E+01, 1.00800E+01, 1.06000E+01, 9.65000E+00, 8.15000E+00, &
       5.40000E+00, 2.32000E+00, 6.00000E-01, 1.25000E-01, 6.80000E-01 /

  data S2PhotoAbsO2 / &
       1.00000E-05, 1.00000E-05, 1.00000E-05, 1.00000E-05, 1.00000E-05, &
       2.00000E-05, 5.00000E-05, 3.00000E-04, 2.00000E-03, 5.00000E-03, &
       1.00000E-02, 1.00000E-02, 2.00000E-02, 3.50000E-02, 5.00000E-02, &
       2.00000E-01, 2.00000E-01, 8.00000E-01, 1.00000E+00, 1.50000E+00, &
       2.45000E+00, 4.70000E+00, 8.00000E+00, 1.15000E+01, 1.40000E+01, &
       1.20000E+01, 7.00000E+00, 4.00000E-01, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 1.00000E-02, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 1.10000E+00, 1.00000E+00, 1.60000E+00, 1.65300E+01, &
       4.00000E+00, 1.55400E+01, 9.85000E+00, 2.08700E+01, 2.70900E+01, &
       2.66600E+01, 2.51800E+01, 2.19800E+01, 2.90500E+01, 2.50000E+01, &
       2.62700E+01, 2.60200E+01, 2.58000E+01, 2.61000E+01, 2.50400E+01, &
       2.20000E+01, 2.55900E+01, 2.40600E+01, 2.15900E+01, 2.04000E+01, &
       1.93900E+01, 1.81700E+01, 1.84000E+01, 1.71900E+01, 1.60000E+01, &
       1.59800E+01, 1.36500E+01, 1.48000E+01, 1.28000E+01, 1.05000E+01, &
       7.27000E+00, 3.61000E+00, 1.18000E+00, 3.20000E-01, 3.95000E-01 /

  data S2PhotoIonN2 / &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 5.45000E-01, &
       5.29000E-01, 6.84000E-01, 6.70000E-01, 7.50000E-01, 8.75000E-01, &
       8.42000E-01, 1.00000E+00, 1.00000E+00, 1.00000E+00, 1.00000E+00, &
       1.00000E+00, 1.00000E+00, 1.00000E+00, 1.00000E+00, 1.00000E+00, &
       1.00000E+00, 1.00000E+00, 1.00000E+00, 1.00000E+00, 1.00000E+00, &
       1.00000E+00, 1.00000E+00, 1.00000E+00, 1.00000E+00, 1.00000E+00, &
       1.00000E+00, 1.00000E+00, 1.00000E+00, 1.00000E+00, 1.00000E+00 /

  data S2PhotoIonCO / &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 3.11000E-01, 7.58000E-01, 5.33000E-01, &
       4.65000E-01, 6.03000E-01, 4.63000E-01, 6.55000E-01, 6.83000E-01, &
       6.66000E-01, 8.60000E-01, 9.01000E-01, 9.19000E-01, 9.65000E-01, &
       9.49000E-01, 1.00000E+00, 9.22000E-01, 1.00000E+00, 1.00000E+00, &
       1.00000E+00, 1.00000E+00, 1.00000E+00, 1.00000E+00, 1.00000E+00, &
       1.00000E+00, 1.00000E+00, 1.00000E+00, 1.00000E+00, 1.00000E+00, &
       1.00000E+00, 1.00000E+00, 1.00000E+00, 1.00000E+00, 1.00000E+00 /

  data S2PhotoIonCO2 / &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 4.01000E-01, 8.31000E-01, 6.76000E-01, &
       7.83000E-01, 7.55000E-01, 9.34000E-01, 7.57000E-01, 8.14000E-01, &
       8.37000E-01, 8.17000E-01, 8.23000E-01, 7.97000E-01, 1.00000E+00, &
       1.00000E+00, 1.00000E+00, 1.00000E+00, 1.00000E+00, 1.00000E+00, &
       1.00000E+00, 1.00000E+00, 1.00000E+00, 1.00000E+00, 1.00000E+00, &
       1.00000E+00, 1.00000E+00, 1.00000E+00, 1.00000E+00, 1.00000E+00, &
       1.00000E+00, 1.00000E+00, 1.00000E+00, 1.00000E+00, 1.00000E+00 /

  data S2PhotoIonO2 / &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 2.45000E-01, 0.00000E+00, 6.25000E-01, 7.39000E-01, &
       6.25000E-01, 6.01000E-01, 4.76000E-01, 2.93000E-01, 3.47000E-01, &
       4.14000E-01, 3.85000E-01, 3.91000E-01, 8.20000E-01, 9.20000E-01, &
       8.39000E-01, 9.97000E-01, 1.00000E+00, 1.00000E+00, 1.00000E+00, &
       1.00000E+00, 1.00000E+00, 1.00000E+00, 1.00000E+00, 1.00000E+00, &
       1.00000E+00, 1.00000E+00, 1.00000E+00, 1.00000E+00, 1.00000E+00, &
       1.00000E+00, 1.00000E+00, 1.00000E+00, 1.00000E+00, 1.00000E+00, &
       1.00000E+00, 1.00000E+00, 1.00000E+00, 1.00000E+00, 1.00000E+00 /

  data S2BranchingRatioOP / &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, 0.00000E+00, &
       4.50000E-02, 5.90000E-02, 7.30000E-02, 8.70000E-02, 1.01000E-01, &
       1.15000E-01, 1.28000E-01, 1.42000E-01, 1.56000E-01, 1.70000E-01, &
       1.70000E-01, 1.63000E-01, 1.60000E-01, 1.85000E-01, 2.43000E-01, &
       2.75000E-01, 3.45000E-01, 3.70000E-01, 4.00000E-01, 4.00000E-01 /

contains
  !=========================================================================
  subroutine init_mod_euv
  end subroutine init_mod_euv
  !=========================================================================
  subroutine clean_mod_euv
  end subroutine clean_mod_euv
  !=========================================================================
end module ModEUV

