function figdata = setfigure(whichway)
%%
%  figure out a page layout
%  extra space at the bottom for the date/file annotation
%  extra space at the top because the titles have multiple lines

if (strncmpi(whichway,'land',4))
    orientation   = 'landscape';
    position      = [0.10 0.15 0.8 0.7];
else
    orientation   = 'tall';
    position      = [0.15 0.12 0.7 0.75];
end

fontsize      = 16;
linewidth     = 2.5;
markersize    = 8.0;
ges_color     = [  0 128   0]/255; % prior_green
anl_color     = [  0   0 255]/255; % poste_blue
obs_color     = [215  10  83]/255; % obs_red
teal          = [  0 128 128]/255;
ges_marker    = '*';
anl_marker    = 'd';
ges_linestyle = '-';
anl_linestyle = '-';

figdata = struct( ...
    'expcolors',  {{'k','r','b','m','g','c','y'}}, ...
    'expsymbols', {{'o','s','d','p','h','s','*'}}, ...
    'prpolines',  {{'-','--'}}, ...
    'position'     , position, ...
    'fontsize'     , fontsize, ...
    'orientation'  , orientation, ...
    'linewidth'    , linewidth, ...
    'markersize'   , markersize, ...
    'ges_color'    , ges_color, ...
    'anl_color'    , anl_color, ...
    'obs_color'    , obs_color, ...
    'teal'         , teal, ...
    'ges_marker'   , ges_marker, ...
    'anl_marker'   , anl_marker, ...
    'ges_linestyle', ges_linestyle, ...
    'anl_linestyle', anl_linestyle );

