#!/bin/csh
#
# quick script to just loop over a bunch of files and do something.
# The list of files is contained in a file called 'file_list.txt'

set NFILES = `cat file_list.txt | wc -l `

@ ifile = 1

while ( $ifile <= $NFILES )

   echo "Converting file $ifile of $NFILES at "`date`

   # get the file name from the list of filenames.
   set ORGFILE = `head -n $ifile file_list.txt  | tail -n 1`

   # the filename extension is a unique date
   # grab that so we can use it to rename the output.

   set FILEDATE = $ORGFILE:e

   echo "Converting observations for $FILEDATE at " `date`

   # The namelist for the obs_sequence tool defines the
   # input file name ... I have it set to 'obs_seq.final'

   ln -sf $ORGFILE obs_seq.final

   # The obs_sequence_tool_nml is set to:
   # geographically subset the observations, 
   # only keep the first 13 'copies', and write 
   # output to a file named 'obs_seq.subsetted'.
   # The obs_sequence_nml is set to write the output as ASCII

   ./obs_sequence_tool || exit 1

   # The obs_seq_to_to_netcdf_nml is set to read 
   # 'obs_seq.subsetted' and convert all the observations to
   # a netCDF file that has most (but not all) of the observation
   # metadata. obs_seq_to_netcdf also uses the schedule_nml
   # which (in this case) does not temporal subsetting.
   # In this case, the output filename will be obs_epoch_001.nc
   # which we will rename.

   ./obs_seq_to_netcdf || exit 2
   \mv obs_epoch_001.nc observations/obs_epoch.$FILEDATE.nc

   # Now is the time to rename the subsetted observation
   # sequence file to something unique. 

   \mv obs_seq.subsetted observations/obs_seq.final.$FILEDATE

   @ ifile ++

end
