
;   Script to produce plots for a WRF real-data run,
;   with the ARW coordinate dynamics option.

load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "WRFUserARW.ncl"

begin
;
; Make a list of all files we are interested in
  DATADir = "/ptmp/gill/global/WRFV2_top_parallel/test/em_real/"
  FILES = systemfunc ("csh -c ' ls " + DATADir + "wrfout* '")
  numFILES = dimsizes(FILES)
  print("numFILES = " + numFILES)
  print(FILES)
  print (" ")

; We generate plots, but what kind do we prefer?
; type = "x11"
; type = "pdf"
; type = "ps"
  type = "ncgm"
  wks = gsn_open_wks(type,"gwrf_061012_merc")

; Basic Plot Information                             
    resB = True
    resB@MainTitle = " "
    resB@Footer = False

; Interval to loop through the data
  timeINT = 1

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; The specific pressure levels that we want the data interpolated to.
  pressure_levels = (/ 850., 700., 500., 300./)   ; pressure levels to plot
  nlevels         = dimsizes(pressure_levels)     ; number of pressure levels

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

FirstTime = True
do ifil = 0, numFILES-1      ; BIG FILES LOOP
   a = addfile(FILES(ifil)+".nc","r")
   print("Working on FILE: " +FILES(ifil) )

   ; What times and how many time steps are in this data set?
     times  = wrf_user_list_times(a)  ; get times in the file
     ntimes = dimsizes(times)         ; number of times in the file

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

  do it = 0,ntimes-1,timeINT        ; TIME LOOP

    print("Working on time: " + times(it) )
    resB@TimeLabel = times(it)      ; Set Valid time to use on plots
    if (FirstTime) then
      times_sav = times(it)
    end if

    mpres = True                   ; Create map background
    map = wrf_map(wks,a,mpres)
    
    res = resB
    res@cnRasterModeOn = True
    res@cnFillOn = False

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; First get the variables we will need        

    ter = wrf_user_getvar(a,"HGT",it)    
    slp = wrf_user_getvar(a,"slp",it)       ; psl
      wrf_smooth_2d(slp, 3)                 ; smooth psl          
    tc  = wrf_user_getvar(a,"tc",it)        ; T in C
    td  = wrf_user_getvar(a,"td",it)        ; Td
    u   = wrf_user_getvar(a,"ua",it)        ; u averaged to mass points
    v   = wrf_user_getvar(a,"va",it)        ; v averaged to mass points
    p   = wrf_user_getvar(a, "pressure",it) ; pressure
    z   = wrf_user_getvar(a, "z",it)        ; grid point height
    rh = wrf_user_getvar(a,"rh",it)         ; relative humidity

    if ( it .eq. 0 ) then                
      tc2 = tc(0,:,:)                       ; Use lowest T at time zero
      td2 = td(0,:,:)                       ; Use lowest Td at time zero
      u10 = u(0,:,:)                        ; Use lowest level at time 0
      v10 = v(0,:,:)
    else
      tc2 = wrf_user_getvar(a,"T2",it)      ; T2 in Kelvin
         tc2 = tc2-273.16                   ; T2 in C
      td2 =  wrf_user_getvar(a,"td2",it)    ; Td2 in C
      u10 = wrf_user_getvar(a,"U10",it)     ; u at 10 m, mass point
      v10 = wrf_user_getvar(a,"V10",it)     ; v at 10 m, mass point
    end if

  ;       Get non-convective, convective and total precipitation
  ;       Calculate tendency values                               
    rain_exp = wrf_user_getvar(a,"RAINNC",it)
    rain_con = wrf_user_getvar(a,"RAINC",it)
    snow_exp = wrf_user_getvar(a,"SNOWNC",it)
    rain_tot = rain_exp + rain_con
    if( FirstTime ) then
      rain_exp_save = rain_exp
      rain_con_save = rain_con
      rain_tot_save = rain_tot
    end if
    rain_exp_tend = rain_exp - rain_exp_save
    rain_con_tend = rain_con - rain_con_save
    rain_tot_tend = rain_tot - rain_tot_save
  ;       Bookkeeping, just to allow the tendency at the next time step
    rain_exp_save = rain_exp
    rain_con_save = rain_con
    rain_tot_save = rain_tot

    tf2 = 1.8*tc2+32.                    ; Turn temperature into Fahrenheit
      tf2@description = "Surface Temperature"
      tf2@units = "F"
    td_f = 1.8*td2+32.                   ; Turn temperature into Fahrenheit
      td_f@description = "Surface Dew Point Temp"
      td_f@units = "F"
    u10 = u10*1.94386                ; Turn wind into knots
    v10 = v10*1.94386
      u10@units = "kts"
      v10@units = "kts"

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

    if (FirstTime) then
      opts = res
      opts@cnFillOn = True
      opts@cnLevelSelectionMode = "ExplicitLevels"
      opts@cnLevels = (/ 0., 100., 200., 300., 400., 500., \
                         1000., 1500., 2000., 2500., 3000.,\
                         3500., 4000., 4500., 5000., 5500. /)
      contour = wrf_contour(a,wks,ter,opts)
      wrf_map_overlay(wks,map,(/contour/),True)
      delete(opts)
    end if

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

    ; Plotting options for T                
      opts = res                          
      opts@cnFillOn = True  
      opts@ContourParameters = (/ -20., 90., 5./)
      opts@gsnSpreadColorEnd = -3 
      contour_tc  = wrf_contour(a,wks,tf2,opts)
      delete(opts)
 
    ; Plotting options for Td
      opts = res          
      opts@cnFillOn = True 
      opts@cnLinesOn = True
      opts@cnLineLabelsOn = True
      opts@ContourParameters = (/ -20., 90., 5./)
      opts@cnLineLabelBackgroundColor = -1
      opts@gsnSpreadColorEnd = -3
      contour_td  = wrf_contour(a,wks,td_f,opts)
      delete(opts)

    ; Plotting options for SLP                     
      opts = res          
      opts@ContourParameters = (/ 900., 1100., 10. /)
      ;opts@cnLineColor = "NavyBlue"
      ;opts@cnHighLabelsOn = True
      ;opts@cnLowLabelsOn = True
      opts@cnLineLabelsOn = False
      opts@cnLineLabelBackgroundColor = -1
      opts@gsnContourLineThicknessesScale = 1.5
      contour_psl = wrf_contour(a,wks,slp,opts)
      delete(opts)

    ; Plotting options for Wind Vectors                 
      opts = resB          
      opts@FieldTitle = "Wind"
      opts@NumVectors = 30
      vector = wrf_vector(a,wks,u10,v10,opts)
      delete(opts)


    ; MAKE PLOTS                                       
      wrf_map_overlay(wks,map,(/contour_tc,contour_psl,vector/),True)
      ;wrf_map_overlay(wks,map,(/contour_td,vector/),True)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

    times_sav = times(it)
    FirstTime = False

  end do  ;       end of the time loop
end do  ;       END IF BIG FILE LOOP

end
