#!/bin/csh
#
#BSUB -P 64000400           # account
#BSUB -n 1                  # number of tasks
#BSUB -J real               # job name
#BSUB -o real.%J.out        # stdout redirect
#BSUB -e real.%J.err        # stderr redirect
#BSUB -q share              # queue
#BSUB -N                    # send email report
#BSUB -W 1:00               # wall-clock limit (HH:MM)
#

# This is a LSF script to run WRF for a simple MPI-only em_real case 
# on bluevista.  jan00 case is used.  
# Only real.exe is run.  
# To use it, type "bsub < real.lsf.csh" from the test/em_esmf_exp 
# subdirectory.  

unalias cd cp rm ls pushd popd mv

# Modify namelist if needed...  
cp -f ../em_real/namelist.input.jan00 namelist.input

# Link in SI data sets for em_real jan00 case
set WRFREGDATAEM = /mmm/users/gill/WRF-data-EM
set thedataem = ${WRFREGDATAEM}/jan00
ln -sf $thedataem/* .

# Build "real" input data files for WRF from SI data sets
mpirun.lsf ./real.exe

