#!/bin/csh
#set echo
#unalias tail

set DataSource = ` cat GraphicsInput | cut -f1 -d" " `
set wskTYPE    = ` cat GraphicsInput | cut -f2 -d" " `
set outputFILE = ` cat GraphicsInput | cut -f3 -d" " `
set Date       = ` cat GraphicsInput | cut -f4 -d" " `

# outputFILE should always be hur_track if we want to set it to the web

MakePNG:
if ( $wskTYPE == "pdf" ) then
#  ~sog/bin/convert $outputFILE.pdf $outputFILE.png
   ~sog/bin/convert -rotate -90 $outputFILE.pdf $outputFILE.png
endif
if ( $wskTYPE == "ncgm" ) then
  ctrans -d sun $outputFILE.ncgm > $outputFILE.ras
  ~sog/bin/convert $outputFILE.ras $outputFILE.png
endif

MakeTAR:
rm -rf wrf
mkdir wrf
cd wrf
if ( $DataSource == "RIP4" ) then
  set StartTime = $Date
  mkdir hur12
  cd hur12
endif
if ( $DataSource == "AFWA" ) then
  mkdir hur
  cd hur
  set StartTime = ` echo $Date | cut -c1-4,6-7,9-10,12-13 `
endif
mkdir $StartTime
cd $StartTime
cp ../../../$outputFILE.png .
cd ../../..
tar -cvf cb_hur_tracks.tar wrf
