;----------------------------------------------------------------------
; Add a title header topleft and time information topright
;----------------------------------------------------------------------
undef("PlotHeaderL")
procedure PlotHeaderL(wks,map,tkres) 
begin

  ;Add header at top
  txt0 = create "MainPlotTille" textItemClass wks
    "txString"              : tkres@header
    "txFontHeightF"         : 0.018
    "txBackgroundFillColor" : "White"
    "txPerimOn"             : True
    "txPerimColor"          : "Black"
    "txFont"                : "helvetica-bold"
  end create
  anno = NhlAddAnnotation(map,txt0)
  setvalues anno
    "amZone"           : 0
    "amSide"           : "Top"
    "amJust"           : "TopLeft"
    "amParallelPosF"   : -0.5
    "amOrthogonalPosF" : 0.5
    "amResizeNotify"   : False
  end setvalues

end

undef("PlotHeaderR")
procedure PlotHeaderR(wks,map,header,tkres) 
begin

  ; Set return character
    cr = "~C~"

  ; Placement of the time info
    slon = tkres@max_lon - 0.2
    slat = tkres@max_lat - 0.2

    txres                       = True
    txres@txFont                = "helvetica-bold"
    txres@txFontColor           = "Black"
    txres@txFontHeightF         = 0.01
    txres@txPerimOn             = True
    txres@txPerimColor          = "Black"
    txres@txJust                = "TopRight"
    txres@txBackgroundFillColor = "White"

    if (tkres@plotType .eq. 0) then
      timestring = "TIME:" 
      do i = 0, dimsizes(header)-1
        timestring = timestring + cr + header(i)
      end do 
    else
      timestring = "Forecasts:" 
      do i = 0, dimsizes(header)-1
        ii = i+1
        timestring = timestring + cr + ii + ". " + header(i)
      end do 
    end if

    gsn_text(wks,map,timestring,slon,slat,txres)

end
