;----------------------------------------------------------------------
; Add Hurricane sysmbols (color) and cat's bottomleft
;----------------------------------------------------------------------
undef("HurricaneLegend")
procedure HurricaneLegend(wks,map,tkres)
begin

    if (tkres@plotType .eq. 4) 
      return
    end if

  ; Placement of the legdends
    slon = tkres@min_lon + 0.5
    slat = tkres@min_lat + 0.5

    pmres = True
    pmres@gsMarkerSizeF = 0.013
    pmres@gsMarkerIndex = create_hurricane_symbol(wks)

    txres               = True
    txres@txFont        = "helvetica-bold"
    txres@txFontColor   = "White"
    txres@txFontHeightF = 0.008

    start_color = 5   ; our color table has Blue as color number 5
    do j=0,4          ; plot 5 color symbols
      pmres@gsMarkerColor = start_color + j
      gsn_polymarker(wks,map,slon,slat,pmres)
      gsn_text(wks,map,1+j,slon,slat,txres)
      slon = slon + 0.5
    end do

    ; Draw a box around the legend
    lnres                  = True
    lnres@gsLineColor      = "Black"
    lnres@gsLineThicknessF = 1.7
    slat = slat + 0.4
    gsn_polyline(wks,map,(/tkres@min_lon,slon/),(/slat+0.4,slat+0.4/),lnres)
    gsn_polyline(wks,map,(/slon,slon/),(/slat+0.4,tkres@min_lat/),lnres)
    slon = slon - 0.5 - 0.5 - 0.5

    ; Add some text
    txres@txFontColor   = "Black"
    txres@txFontHeightF = 0.009
    txres@txJust        = "BottomCenter"
    gsn_text(wks,map,"hur cat:",slon,slat,txres)

end


;----------------------------------------------------------------------
; Add pressure/wind and dd/hh legend to bottomright
;----------------------------------------------------------------------
undef("SymbolLegend")
procedure SymbolLegend(wks,map,tkres)
begin

    if ( tkres@plotType .ge. 2)
      return
    end if
  ; Set return character
    cr = "~C~"

  ; Placement of the ledgends
    slon = tkres@max_lon - 2.0
    slat = tkres@min_lat + 0.5

    pmres               = True
    pmres@gsMarkerSizeF = 0.008
    pmres@gsMarkerIndex = create_hurricane_symbol(wks)
    pmres@gsMarkerColor = "Black"
    gsn_polymarker(wks,map,slon,slat,pmres)

    txres               = True
    txres@txFont        = "helvetica-bold"
    txres@txFontHeightF = 0.008
    txres@txJust        = "CenterRight"
    sslon = slon - 0.5
    left = "pressure" + cr + "max wnd ("+tkres@DataType+")"
    gsn_text(wks,map,left,sslon,slat,txres)

    txres@txBackgroundFillColor = "White"
    txres@txPerimOn             = True
    txres@txJust                = "CenterLeft"
    right = "dd/hh"
    slon = slon + 0.5
    gsn_text(wks,map,right,slon,slat,txres)

end
