;----------------------------------------------------------------------
; Draw the track line on the map that we have created previously
;----------------------------------------------------------------------
undef("PlotTrackLine")
procedure PlotTrackLine(wks,map,lat,lon,wnd,cat,tkres)
begin
  
  ; We are going to draw the line every 3 hour, or every timestep, 
  ; Depending on frequency of input data
    line_int = floattoint(3/tkres@interval)   
    if ( line_int .le. 1 )
      line_int = 1
    end if

  ; Line resources
    lnres                  = True
    lnres@gsLineColor      = "Black"
    lnres@gsLineThicknessF = 1.7

    if (tkres@plotType .eq. 4)
      lnres@gsLineColor      = tkres@StartLineColor + tkres@iNumFil
      lnres@gsLineThicknessF = 3.0
    end if

  ; Draw the line
    do i=0,dimsizes(wnd)-line_int-1,line_int
      if ( wnd(i) .ne. -1.0 .and. wnd(i+line_int) .ne. -1.0 ) then
        if (tkres@plotType .eq. 3)
          lnres@gsLineColor      = "Azure4"
          if (wnd(i) .gt. stringtofloat(cat(1)))
            lnres@gsLineColor    = 5
          end if
          if (wnd(i) .gt. stringtofloat(cat(2)))
            lnres@gsLineColor    = 6
          end if
          if (wnd(i) .gt. stringtofloat(cat(3)))
            lnres@gsLineColor    = 7
          end if
          if (wnd(i) .gt. stringtofloat(cat(4)))
            lnres@gsLineColor    = 8
          end if
          if (wnd(i) .gt. stringtofloat(cat(5)))
            lnres@gsLineColor    =9
          end if
        end if
        gsn_polyline(wks,map,(/lon(i),lon(i+line_int)/),(/lat(i),lat(i+line_int)/),lnres)
      end if
    end do

end


;----------------------------------------------------------------------
; Draw pressure and wind information to left of track line       
; Plot date information to the right of the track line
;----------------------------------------------------------------------
undef("PlotTrackInfo")
procedure PlotTrackInfo(wks,map,lat,lon,wnd,wndlev,dd_hh,tkres)
begin
  
  ; We are going to plot the information every 12 hours, or every timestep,
  ; Depending on frequency of input data
    label_int= floattoint(12/tkres@interval)   
    if ( label_int .le. 1 )
      label_int = 1
    end if

    if (tkres@plotType .le. 1)
    ; Plot the Pressure/Wind Info to left of track line
      txres               = True
      txres@txFont        = "helvetica-bold"
      txres@txFontHeightF = 0.009
      txres@txJust        = "CenterRight"
      txres@txAngleF      = tkres@textAngle
      do i=0,dimsizes(wnd)-1,label_int
        if ( wnd(i) .ne. -1.0) then
          gsn_text(wks,map,wndlev(i),lon(i),lat(i),txres)
        end if
      end do
      delete(txres)
    end if

  ; Plot date information to right of track line
    txres               = True
    txres@txFont        = "helvetica-bold"
    txres@txJust        = "CenterLeft"
    txres@txAngleF      = tkres@textAngle

    if (tkres@plotType .le. 1)
      txres@txBackgroundFillColor = "White"
      txres@txPerimOn             = True
      txres@txPerimColor          = "Black"
      txres@txFontHeightF         = 0.008
      lon_dd_hh = lon + 0.5   ; how far must time stamp be drawn from marker
    end if

    if (tkres@plotType .ge. 2)
      txres@txFontHeightF         = 0.007
      lon_dd_hh = lon + 0.2   ; how far must time stamp be drawn from marker
      label_int= floattoint(24/tkres@interval)   ; we will only plot these every 24 hours
    end if

    do i=0,dimsizes(wnd)-1,label_int
      if ( wnd(i) .ne. -1.0) then
        gsn_text(wks,map,dd_hh(i),lon_dd_hh(i),lat(i),txres)
      end if
    end do
    delete(txres)

  ; Add forecast numbers
    if (tkres@plotType .ge. 2)
      txres                       = True
      txres@txFont                = "helvetica-bold"
      txres@txJust                = "BottomLeft"
      txres@txBackgroundFillColor = "White"
      txres@txPerimOn             = True
      txres@txPerimColor          = "Black"
      txres@txFontHeightF         = 0.008
      forecastnumber = 0
      do i=0,dimsizes(wnd)-1,floattoint(3/tkres@interval) ; this is to find end of track line
        itest = dimsizes(wnd)-1-i
        if ( forecastnumber .eq. 0 .and. wnd(itest) .ne. -1.0 ) then
          gsn_text(wks,map,tkres@iNumFil+1,lon(itest),lat(itest),txres)
          forecastnumber = 1
        end if
      end do

    end if  

end


;----------------------------------------------------------------------
; Draw Sysmbols over the track line        
;----------------------------------------------------------------------
undef("PlotTrackSymbols")
procedure PlotTrackSymbols(wks,map,lat,lon,wnd,cat,tkres)
begin

  ; We are going to draw the symbols every 6 hours, or every timestep,
  ; Depending on frequency of input data
    symbol_int= floattoint(6/tkres@interval)   
    if ( symbol_int .le. 1 )
      symbol_int = 1
    end if

    pmres               = True

    if (tkres@plotType .ge. 3 ) then
      do i=0,dimsizes(wnd)-1,symbol_int
        if ( wnd(i) .ne. -1.0) then
          pmres@gsMarkerColor = "White"
          pmres@gsMarkerIndex = 16
          pmres@gsMarkerSizeF = 0.003
          gsn_polymarker(wks,map,lon(i),lat(i),pmres)
        end if
      end do
      return
    end if
  
    do i=0,dimsizes(wnd)-1,symbol_int
      if ( wnd(i) .ne. -1.0) then
        pmres@gsMarkerColor = "Black"
        if ( wnd(i) .gt. stringtofloat(cat(1))) then
          pmres@gsMarkerIndex = create_hurricane_symbol(wks)
          pmres@gsMarkerSizeF = 0.01
        else
          ;pmres@gsMarkerIndex = 4
          pmres@gsMarkerIndex = 16
          pmres@gsMarkerSizeF = 0.006
        end if
        if (wnd(i) .gt. stringtofloat(cat(1))) then
          pmres@gsMarkerColor = "Blue"
        end if
        if (wnd(i) .gt. stringtofloat(cat(2))) then
          pmres@gsMarkerColor = "DarkGreen"
        end if
        if (wnd(i) .gt. stringtofloat(cat(3))) then
          pmres@gsMarkerColor = "Yellow"
        end if
        if (wnd(i) .gt. stringtofloat(cat(4))) then
          pmres@gsMarkerColor = "Red"
        end if
        if (wnd(i) .gt. stringtofloat(cat(5))) then
          pmres@gsMarkerColor = "Purple3"
        end if
        gsn_polymarker(wks,map,lon(i),lat(i),pmres)
      end if
    end do

end
